/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MergeMethodArguments
extends FixableUsageInfo {
    private final PsiMethod method;
    private final PsiClass myContainingClass;
    private final boolean myChangeSignature;
    private final boolean myKeepMethodAsDelegate;
    private final List<PsiTypeParameter> typeParams;
    private final String className;
    private final String packageName;
    private final String parameterName;
    private final int[] paramsToMerge;
    private final boolean lastParamIsVararg;

    public MergeMethodArguments(PsiMethod method, String className, String packageName, String parameterName, int[] paramsToMerge, List<PsiTypeParameter> typeParams, boolean keepMethodAsDelegate, PsiClass containingClass, boolean changeSignature) {
        super((PsiElement)method);
        this.paramsToMerge = paramsToMerge;
        this.packageName = packageName;
        this.className = className;
        this.parameterName = parameterName;
        this.method = method;
        this.myContainingClass = containingClass;
        this.myChangeSignature = changeSignature;
        this.lastParamIsVararg = method.isVarArgs() && this.isParameterToMerge(method.getParameterList().getParametersCount() - 1);
        this.myKeepMethodAsDelegate = keepMethodAsDelegate;
        this.typeParams = new ArrayList<PsiTypeParameter>(typeParams);
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        final JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.method.getProject());
        PsiMethod deepestSuperMethod = this.method.findDeepestSuperMethod();
        PsiClass psiClass = this.myContainingClass != null ? this.myContainingClass.findInnerClassByName(this.className, false) : psiFacade.findClass(StringUtil.getQualifiedName((String)this.packageName, (String)this.className), GlobalSearchScope.allScope((Project)this.getProject()));
        assert (psiClass != null);
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        if (deepestSuperMethod != null) {
            PsiClass parentClass = deepestSuperMethod.getContainingClass();
            PsiSubstitutor parentSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)this.method.getContainingClass(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
            block0: for (int i1 = 0; i1 < psiClass.getTypeParameters().length; ++i1) {
                PsiTypeParameter typeParameter = psiClass.getTypeParameters()[i1];
                for (PsiTypeParameter parameter : parentClass.getTypeParameters()) {
                    if (!Comparing.strEqual((String)typeParameter.getName(), (String)parameter.getName())) continue;
                    subst = subst.put(typeParameter, parentSubstitutor.substitute((PsiType)new PsiImmediateClassType((PsiClass)parameter, PsiSubstitutor.EMPTY)));
                    continue block0;
                }
            }
        }
        final ArrayList<ParameterInfoImpl> parametersInfo = new ArrayList<ParameterInfoImpl>();
        PsiClassType classType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createType(psiClass, subst);
        ParameterInfoImpl mergedParamInfo = new ParameterInfoImpl(-1, this.parameterName, (PsiType)classType, null){

            @Override
            public PsiExpression getValue(PsiCallExpression expr) throws IncorrectOperationException {
                return (PsiExpression)JavaCodeStyleManager.getInstance((Project)MergeMethodArguments.this.getProject()).shortenClassReferences((PsiElement)psiFacade.getElementFactory().createExpressionFromText(MergeMethodArguments.this.getMergedParam(expr), (PsiElement)expr));
            }
        };
        int firstIncludedIdx = -1;
        PsiParameter[] parameters = this.method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!this.isParameterToMerge(i)) {
                parametersInfo.add(new ParameterInfoImpl(i, parameters[i].getName(), parameters[i].getType()));
                continue;
            }
            if (firstIncludedIdx != -1) continue;
            firstIncludedIdx = i;
        }
        parametersInfo.add(firstIncludedIdx == -1 ? 0 : firstIncludedIdx, mergedParamInfo);
        final SmartPsiElementPointer meth = SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)this.method);
        Runnable performChangeSignatureRunnable = new Runnable(){

            @Override
            public void run() {
                PsiMethod psiMethod = (PsiMethod)meth.getElement();
                if (psiMethod == null) {
                    return;
                }
                if (MergeMethodArguments.this.myChangeSignature) {
                    ChangeSignatureProcessor changeSignatureProcessor = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, MergeMethodArguments.this.myKeepMethodAsDelegate, null, psiMethod.getName(), psiMethod.getReturnType(), parametersInfo.toArray(new ParameterInfoImpl[parametersInfo.size()]));
                    changeSignatureProcessor.run();
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            performChangeSignatureRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(performChangeSignatureRunnable);
        }
    }

    private boolean isParameterToMerge(int index) {
        for (int i : this.paramsToMerge) {
            if (i != index) continue;
            return true;
        }
        return false;
    }

    private String getMergedParam(PsiCallExpression call) {
        String containingClassQName;
        PsiExpression[] args = call.getArgumentList().getExpressions();
        StringBuffer newExpression = new StringBuffer();
        String qualifiedName = this.myContainingClass != null ? ((containingClassQName = this.myContainingClass.getQualifiedName()) != null ? containingClassQName + "." + this.className : this.className) : StringUtil.getQualifiedName((String)this.packageName, (String)this.className);
        newExpression.append("new ").append(qualifiedName);
        if (!this.typeParams.isEmpty()) {
            JavaResolveResult resolvant = call.resolveMethodGenerics();
            PsiSubstitutor substitutor = resolvant.getSubstitutor();
            newExpression.append('<');
            final Map substitutionMap = substitutor.getSubstitutionMap();
            newExpression.append(StringUtil.join(this.typeParams, (Function)new Function<PsiTypeParameter, String>(){

                public String fun(PsiTypeParameter typeParameter) {
                    PsiType boundType = (PsiType)substitutionMap.get(typeParameter);
                    if (boundType != null) {
                        return boundType.getCanonicalText();
                    }
                    return typeParameter.getName();
                }
            }, (String)", "));
            newExpression.append('>');
        }
        newExpression.append('(');
        boolean isFirst = true;
        for (int index : this.paramsToMerge) {
            if (!isFirst) {
                newExpression.append(", ");
            }
            isFirst = false;
            newExpression.append(this.getArgument(args, index));
        }
        if (this.lastParamIsVararg) {
            int lastArg = this.paramsToMerge[this.paramsToMerge.length - 1];
            for (int i = lastArg + 1; i < args.length; ++i) {
                newExpression.append(',');
                newExpression.append(this.getArgument(args, i));
            }
        }
        newExpression.append(')');
        return newExpression.toString();
    }

    @Nullable
    private String getArgument(PsiExpression[] args, int i) {
        if (i < args.length) {
            return args[i].getText();
        }
        PsiParameter[] parameters = this.method.getParameterList().getParameters();
        if (i < parameters.length) {
            return parameters[i].getName();
        }
        return null;
    }
}

