/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.SliceDereferenceUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceForwardUtil {
    public static boolean processUsagesFlownFromThe(@NotNull PsiElement element, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "processUsagesFlownFromThe"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "processUsagesFlownFromThe"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "processUsagesFlownFromThe"));
        }
        Pair<PsiElement, PsiSubstitutor> pair = SliceForwardUtil.getAssignmentTarget(element, parent);
        if (pair != null) {
            PsiParameter parameter;
            PsiElement declarationScope;
            PsiElement target = (PsiElement)pair.getFirst();
            final PsiSubstitutor substitutor = (PsiSubstitutor)pair.getSecond();
            if (target instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)target).getDeclarationScope()) instanceof PsiMethod) {
                final PsiMethod method = (PsiMethod)declarationScope;
                final int parameterIndex = method.getParameterList().getParameterIndex(parameter);
                Processor<PsiMethod> myProcessor = new Processor<PsiMethod>(){

                    public boolean process(PsiMethod override) {
                        if (!parent.getScope().contains((PsiElement)override)) {
                            return true;
                        }
                        PsiSubstitutor superSubstitutor = method == override ? substitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)method.getSignature(substitutor), (MethodSignature)override.getSignature(substitutor));
                        PsiParameter[] parameters = override.getParameterList().getParameters();
                        if (parameters.length <= parameterIndex) {
                            return true;
                        }
                        PsiParameter actualParam = parameters[parameterIndex];
                        SliceUsage usage = SliceUtil.createSliceUsage((PsiElement)actualParam, parent, superSubstitutor, parent.indexNesting, "");
                        return processor.process((Object)usage);
                    }
                };
                if (!myProcessor.process((Object)method)) {
                    return false;
                }
                return OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach((Processor)myProcessor);
            }
            SliceUsage usage = SliceUtil.createSliceUsage(target, parent, parent.getSubstitutor(), parent.indexNesting, "");
            return processor.process((Object)usage);
        }
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            PsiVariable variable = (PsiVariable)resolved;
            return SliceForwardUtil.processAssignedFrom((PsiElement)variable, (PsiElement)ref, parent, processor);
        }
        if (element instanceof PsiVariable) {
            return SliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        if (element instanceof PsiMethod) {
            return SliceForwardUtil.processAssignedFrom(element, element, parent, processor);
        }
        return true;
    }

    private static boolean processAssignedFrom(PsiElement from, PsiElement context, SliceUsage parent, @NotNull Processor<SliceUsage> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "processAssignedFrom"));
        }
        if (from instanceof PsiLocalVariable) {
            return SliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, context, parent, processor);
        }
        if (from instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)from;
            PsiElement scope = parameter.getDeclarationScope();
            THashSet parametersToAnalyze = new THashSet();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                int index = method.getParameterList().getParameterIndex(parameter);
                THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
                superMethods.add(method);
                Iterator iterator = superMethods.iterator();
                while (iterator.hasNext()) {
                    ProgressManager.checkCanceled();
                    PsiMethod superMethod = (PsiMethod)iterator.next();
                    if (parent.params.scope.contains((PsiElement)superMethod)) continue;
                    iterator.remove();
                }
                final THashSet implementors = new THashSet((Collection)superMethods);
                for (PsiMethod superMethod : superMethods) {
                    ProgressManager.checkCanceled();
                    if (OverridingMethodsSearch.search((PsiMethod)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach((Processor)new Processor<PsiMethod>(){

                        public boolean process(PsiMethod sub) {
                            ProgressManager.checkCanceled();
                            implementors.add((Object)sub);
                            return true;
                        }
                    })) continue;
                    return false;
                }
                for (PsiMethod implementor : implementors) {
                    ProgressManager.checkCanceled();
                    if (!parent.params.scope.contains((PsiElement)implementor)) continue;
                    if (implementor instanceof PsiCompiledElement) {
                        implementor = (PsiMethod)implementor.getNavigationElement();
                    }
                    PsiParameter[] parameters = implementor.getParameterList().getParameters();
                    if (index == -1 || index >= parameters.length) continue;
                    parametersToAnalyze.add(parameters[index]);
                }
            } else {
                parametersToAnalyze.add(parameter);
            }
            for (PsiParameter psiParameter : parametersToAnalyze) {
                ProgressManager.checkCanceled();
                if (SliceForwardUtil.searchReferencesAndProcessAssignmentTarget((PsiElement)psiParameter, null, parent, processor)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof PsiField) {
            return SliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, null, parent, processor);
        }
        if (from instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)from;
            THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
            superMethods.add(method);
            THashSet processed = new THashSet();
            for (PsiMethod containingMethod : superMethods) {
                if (MethodReferencesSearch.search((PsiMethod)containingMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach((Processor)new Processor<PsiReference>((Set)processed, parent, processor){
                    final /* synthetic */ Set val$processed;
                    final /* synthetic */ SliceUsage val$parent;
                    final /* synthetic */ Processor val$processor;
                    {
                        this.val$processed = set;
                        this.val$parent = sliceUsage;
                        this.val$processor = processor;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean process(PsiReference reference) {
                        ProgressManager.checkCanceled();
                        Set set = this.val$processed;
                        synchronized (set) {
                            if (!this.val$processed.add(reference)) {
                                return true;
                            }
                        }
                        PsiElement element = reference.getElement().getParent();
                        return SliceForwardUtil.processAssignmentTarget(element, this.val$parent, (Processor<SliceUsage>)this.val$processor);
                    }
                })) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean searchReferencesAndProcessAssignmentTarget(@NotNull PsiElement element, final @Nullable PsiElement context, final SliceUsage parent, final Processor<SliceUsage> processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "searchReferencesAndProcessAssignmentTarget"));
        }
        return ReferencesSearch.search((PsiElement)element).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (context != null && element.getTextOffset() < context.getTextOffset()) {
                    return true;
                }
                return SliceForwardUtil.processAssignmentTarget(element, parent, (Processor<SliceUsage>)processor);
            }
        });
    }

    private static boolean processAssignmentTarget(PsiElement element, SliceUsage parent, Processor<SliceUsage> processor) {
        Pair<PsiElement, PsiSubstitutor> pair;
        if (!parent.params.scope.contains(element)) {
            return true;
        }
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        if ((pair = SliceForwardUtil.getAssignmentTarget(element, parent)) != null) {
            SliceUsage usage = SliceUtil.createSliceUsage(element, parent, (PsiSubstitutor)pair.getSecond(), parent.indexNesting, "");
            return processor.process((Object)usage);
        }
        if (parent.params.showInstanceDereferences && SliceForwardUtil.isDereferenced(element)) {
            SliceDereferenceUsage usage = new SliceDereferenceUsage(element.getParent(), parent, parent.getSubstitutor());
            return processor.process((Object)usage);
        }
        return true;
    }

    private static boolean isDereferenced(PsiElement element) {
        if (!(element instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        return ((PsiReferenceExpression)parent).getQualifierExpression() == element;
    }

    private static Pair<PsiElement, PsiSubstitutor> getAssignmentTarget(PsiElement element, SliceUsage parentUsage) {
        PsiReturnStatement statement;
        element = SliceForwardUtil.complexify(element);
        PsiVariable target = null;
        PsiSubstitutor substitutor = parentUsage.getSubstitutor();
        PsiElement parent = element.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression left;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            if (element.equals(assignment.getRExpression()) && (left = assignment.getLExpression()) instanceof PsiReferenceExpression) {
                JavaResolveResult result = ((PsiReferenceExpression)left).advancedResolve(false);
                target = result.getElement();
                substitutor = result.getSubstitutor();
            }
        } else if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiExpression initializer = variable.getInitializer();
            if (element.equals(initializer)) {
                target = variable;
            }
        } else if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression) {
            PsiParameter[] parameters;
            Object[] expressions = ((PsiExpressionList)parent).getExpressions();
            int index = ArrayUtilRt.find((Object[])expressions, (Object)element);
            PsiCallExpression methodCall = (PsiCallExpression)parent.getParent();
            JavaResolveResult result = methodCall.resolveMethodGenerics();
            PsiMethod method = (PsiMethod)result.getElement();
            if (index != -1 && method != null && index < (parameters = method.getParameterList().getParameters()).length) {
                target = parameters[index];
                substitutor = result.getSubstitutor();
            }
        } else if (parent instanceof PsiReturnStatement && element.equals((statement = (PsiReturnStatement)parent).getReturnValue())) {
            target = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
        }
        return target == null ? null : Pair.create(target, (Object)substitutor);
    }

    @NotNull
    public static PsiElement complexify(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "complexify"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiParenthesizedExpression && element.equals(((PsiParenthesizedExpression)parent).getExpression())) {
            PsiElement psiElement = SliceForwardUtil.complexify(parent);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceForwardUtil", "complexify"));
            }
            return psiElement;
        }
        if (parent instanceof PsiTypeCastExpression && element.equals(((PsiTypeCastExpression)parent).getOperand())) {
            PsiElement psiElement = SliceForwardUtil.complexify(parent);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceForwardUtil", "complexify"));
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceForwardUtil", "complexify"));
        }
        return psiElement;
    }
}

