/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;

public class SmartPsiPointer {
    private SmartPsiElementPointer pointer;

    public SmartPsiPointer(PsiElement element) {
        this.pointer = element != null ? SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element) : null;
    }

    public VirtualFile getFile() {
        return this.pointer != null ? this.pointer.getVirtualFile() : null;
    }

    public int getOffset() {
        return this.pointer != null ? this.pointer.getElement().getTextRange().getStartOffset() : -1;
    }

    public int getLength() {
        return this.pointer != null ? this.pointer.getElement().getTextRange().getEndOffset() : 0;
    }

    public PsiElement getElement() {
        return this.pointer != null ? this.pointer.getElement() : null;
    }

    public void clear() {
        this.pointer = null;
    }

    public Project getProject() {
        return this.pointer != null ? this.pointer.getElement().getProject() : null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SmartPsiPointer)) {
            return false;
        }
        SmartPsiPointer ref = (SmartPsiPointer)o;
        return ref.pointer.equals(this.pointer);
    }

    public int hashCode() {
        return this.pointer != null ? this.getElement().hashCode() : 0;
    }
}

