/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTabColorProviderImpl
implements EditorTabColorProvider {
    @Override
    @Nullable
    public Color getEditorTabColor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/tabs/EditorTabColorProviderImpl", "getEditorTabColor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/tabs/EditorTabColorProviderImpl", "getEditorTabColor"));
        }
        FileColorManager colorManager = FileColorManager.getInstance((Project)project);
        return colorManager.isEnabledForTabs() ? colorManager.getFileColor(file) : null;
    }
}

