/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;

public class CompressionUtil {
    private static final int COMPRESSION_THRESHOLD = 64;
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final int STRING_COMPRESSION_THRESHOLD = 1024;

    public static int writeCompressed(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/CompressionUtil", "writeCompressed"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/CompressionUtil", "writeCompressed"));
        }
        if (length > 64) {
            byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength((int)length));
            int compressedSize = Snappy.compress((byte[])bytes, (int)0, (int)length, (byte[])compressedOutputBuffer, (int)0);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)(-compressedSize));
            out.write(compressedOutputBuffer, 0, compressedSize);
            return compressedSize;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)length);
        out.write(bytes, 0, length);
        return length;
    }

    @NotNull
    public static byte[] readCompressed(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/CompressionUtil", "readCompressed"));
        }
        int size = DataInputOutputUtil.readINT((DataInput)in);
        if (size < 0) {
            byte[] bytes = spareBufferLocal.getBuffer(-size);
            in.readFully(bytes, 0, -size);
            byte[] byArray = Snappy.uncompress((byte[])bytes, (int)0, (int)(-size));
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "readCompressed"));
            }
            return byArray;
        }
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "readCompressed"));
        }
        return bytes;
    }

    @NotNull
    public static CharSequence uncompressCharSequence(@NotNull Object string, @NotNull Charset charset) {
        String string2;
        block6: {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
            }
            if (string instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)string;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
                }
                return charSequence;
            }
            byte[] b = (byte[])string;
            try {
                int uncompressedLength = Snappy.getUncompressedLength((byte[])b, (int)0);
                byte[] bytes = spareBufferLocal.getBuffer(uncompressedLength);
                int bytesLength = Snappy.uncompress((byte[])b, (int)0, (int)b.length, (byte[])bytes, (int)0);
                string2 = new String(bytes, 0, bytesLength, charset);
                if (string2 != null) break block6;
            }
            catch (CorruptionException ex) {
                throw new RuntimeException(ex);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
        }
        return string2;
    }

    @NotNull
    public static Object compressCharSequence(@NotNull CharSequence string, @NotNull Charset charset) {
        byte[] byArray;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/CompressionUtil", "compressCharSequence"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/util/CompressionUtil", "compressCharSequence"));
        }
        if (string.length() < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = ((Object)string).toString();
            }
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressCharSequence"));
            }
            return charSequence;
        }
        try {
            byArray = Snappy.compress((byte[])((Object)string).toString().getBytes(charset));
        }
        catch (CorruptionException ex) {
            ex.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressCharSequence"));
            }
            return charSequence;
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressCharSequence"));
        }
        return byArray;
    }
}

