/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.awt.EventQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsCommitCache<CommitId, T extends VcsShortCommitDetails> {
    private final SLRUMap<CommitId, T> myCache = new SLRUMap(5000, 5000);

    VcsCommitCache() {
    }

    public void put(@NotNull CommitId hash, @NotNull T commit) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "put"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VcsCommitCache", "put"));
        }
        assert (EventQueue.isDispatchThread());
        this.myCache.put(hash, commit);
    }

    public boolean isKeyCached(@NotNull CommitId hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "isKeyCached"));
        }
        assert (EventQueue.isDispatchThread());
        return this.myCache.get(hash) != null;
    }

    @Nullable
    public T get(@NotNull CommitId hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "get"));
        }
        assert (EventQueue.isDispatchThread());
        return (T)((VcsShortCommitDetails)this.myCache.get(hash));
    }

    public void remove(@NotNull CommitId hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "remove"));
        }
        this.myCache.remove(hash);
    }
}

