/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import com.intellij.vcs.log.graph.impl.print.elements.AbstractPrintElement;
import org.jetbrains.annotations.NotNull;

public class EdgePrintElementImpl
extends AbstractPrintElement
implements EdgePrintElement {
    @NotNull
    private final EdgePrintElement.Type myType;
    @NotNull
    private final EdgePrintElement.LineStyle myLineStyle;
    private final int myPositionInOtherRow;

    @NotNull
    public static EdgePrintElement.LineStyle convertToLineStyle(@NotNull GraphEdge.Type edgeType) {
        if (edgeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeType", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "convertToLineStyle"));
        }
        switch (edgeType) {
            case USUAL: {
                EdgePrintElement.LineStyle lineStyle = EdgePrintElement.LineStyle.SOLID;
                if (lineStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "convertToLineStyle"));
                }
                return lineStyle;
            }
            case HIDE: {
                EdgePrintElement.LineStyle lineStyle = EdgePrintElement.LineStyle.DASHED;
                if (lineStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "convertToLineStyle"));
                }
                return lineStyle;
            }
        }
        throw new IllegalStateException("Edge type not supported: " + (Object)((Object)edgeType));
    }

    public EdgePrintElementImpl(int rowIndex, int positionInCurrentRow, int positionInOtherRow, @NotNull EdgePrintElement.Type type, @NotNull GraphEdge graphEdge, @NotNull PrintElementsManager printElementsManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "<init>"));
        }
        if (graphEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphEdge", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "<init>"));
        }
        super(rowIndex, positionInCurrentRow, graphEdge, printElementsManager);
        this.myType = type;
        this.myLineStyle = EdgePrintElementImpl.convertToLineStyle(graphEdge.getType());
        this.myPositionInOtherRow = positionInOtherRow;
    }

    public int getPositionInOtherRow() {
        return this.myPositionInOtherRow;
    }

    @NotNull
    public EdgePrintElement.Type getType() {
        EdgePrintElement.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public EdgePrintElement.LineStyle getLineStyle() {
        EdgePrintElement.LineStyle lineStyle = this.myLineStyle;
        if (lineStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "getLineStyle"));
        }
        return lineStyle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgePrintElement)) {
            return false;
        }
        EdgePrintElement that = (EdgePrintElement)o;
        if (this.myPositionInCurrentRow != that.getPositionInCurrentRow()) {
            return false;
        }
        if (this.myPositionInOtherRow != that.getPositionInOtherRow()) {
            return false;
        }
        if (this.myRowIndex != that.getRowIndex()) {
            return false;
        }
        return this.myType == that.getType();
    }

    public int hashCode() {
        int result = this.myRowIndex;
        result = 31 * result + this.myPositionInCurrentRow;
        result = 31 * result + this.myPositionInOtherRow;
        result = 37 * result + this.myType.hashCode();
        return result;
    }
}

