/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class XmlPsiManager
extends AbstractProjectComponent {
    private final PsiManagerImpl myPsiManager;

    protected XmlPsiManager(Project project, PsiManagerImpl psiManager) {
        super(project);
        this.myPsiManager = psiManager;
    }

    public void initComponent() {
        super.initComponent();
        new PsiTreeChangePreprocessorBase(this.myPsiManager){

            @Override
            protected boolean isInsideCodeBlock(PsiElement element) {
                if (element instanceof PsiFileSystemItem) {
                    return false;
                }
                if (element == null || element.getParent() == null) {
                    return true;
                }
                boolean isXml = element.getLanguage() instanceof XMLLanguage;
                return !isXml;
            }

            @Override
            public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/XmlPsiManager$1", "treeChanged"));
                }
                if (!(event.getFile() instanceof XmlFile)) {
                    return;
                }
                super.treeChanged(event);
            }
        };
    }
}

