/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class InlineCallFix
extends InspectionGadgetsFix {
    private String myName;

    public InlineCallFix(String name) {
        this.myName = name;
    }

    public InlineCallFix() {
        this(InspectionGadgetsBundle.message("inline.call.quickfix", new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InlineCallFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InlineCallFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement nameElement = descriptor.getPsiElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)nameElement.getParent();
        if (methodExpression == null) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        this.inline(project, methodExpression, method);
    }

    protected void inline(Project project, PsiReferenceExpression methodExpression, PsiMethod method) {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        InlineMethodProcessor processor = new InlineMethodProcessor(project, method, (PsiJavaCodeReferenceElement)methodExpression, null, true, settings.RENAME_SEARCH_IN_COMMENTS_FOR_METHOD, settings.RENAME_SEARCH_FOR_TEXT_FOR_METHOD);
        processor.inlineMethodCall(processor.addBracesWhenNeeded(new PsiReferenceExpression[]{methodExpression})[0]);
    }
}

