/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ConvertToVarargsMethodFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MethodCanBeVariableArityMethodInspection
extends BaseInspection {
    public boolean ignoreByteAndShortArrayParameters = false;
    public boolean ignoreOverridingMethods = false;
    public boolean onlyReportPublicMethods = false;
    boolean ignoreMultipleArrayParameters = false;

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if (!"ignoreMultipleArrayParameters".equals(option.getAttributeValue("name"))) continue;
            this.ignoreMultipleArrayParameters = Boolean.parseBoolean(option.getAttributeValue("value"));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.ignoreMultipleArrayParameters) {
            node.addContent(new Element("option").setAttribute("name", "ignoreMultipleArrayParameters").setAttribute("value", String.valueOf(this.ignoreMultipleArrayParameters)));
        }
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.can.be.variable.arity.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.can.be.variable.arity.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/MethodCanBeVariableArityMethodInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.byte.short.option", new Object[0]), "ignoreByteAndShortArrayParameters");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), "ignoreOverridingMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("only.report.public.methods.option", new Object[0]), "onlyReportPublicMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("method.can.be.variable.arity.method.ignore.multiple.arrays.option", new Object[0]), "ignoreMultipleArrayParameters");
        return panel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConvertToVarargsMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeVariableArityMethodVisitor();
    }

    private class MethodCanBeVariableArityMethodVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeVariableArityMethodVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
                return;
            }
            super.visitMethod(method);
            if (MethodCanBeVariableArityMethodInspection.this.onlyReportPublicMethods && !method.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)lastParameter)) {
                return;
            }
            PsiType type = lastParameter.getType();
            if (!(type instanceof PsiArrayType) || type instanceof PsiEllipsisType) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            if (componentType instanceof PsiArrayType) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreByteAndShortArrayParameters && (PsiType.BYTE.equals((Object)componentType) || PsiType.SHORT.equals((Object)componentType))) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreOverridingMethods && MethodUtils.hasSuper(method)) {
                return;
            }
            if (MethodCanBeVariableArityMethodInspection.this.ignoreMultipleArrayParameters) {
                int length = parameters.length - 1;
                for (int i = 0; i < length; ++i) {
                    PsiParameter parameter = parameters[i];
                    if (!(parameter.getType() instanceof PsiArrayType)) continue;
                    return;
                }
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

