/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextAdditionalParameter;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;

public abstract class EvaluateContextBase<VALUE_MANAGER extends ValueManager>
implements EvaluateContext {
    protected final VALUE_MANAGER valueManager;

    protected EvaluateContextBase(@NotNull VALUE_MANAGER valueManager) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "org/jetbrains/debugger/EvaluateContextBase", "<init>"));
        }
        this.valueManager = valueManager;
    }

    @Override
    @NotNull
    public AsyncResult<Value> evaluate(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/EvaluateContextBase", "evaluate"));
        }
        AsyncResult<Value> asyncResult = this.evaluate(expression, null);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "evaluate"));
        }
        return asyncResult;
    }

    @Override
    @NotNull
    public EvaluateContext withValueManager(@NotNull String objectGroup) {
        if (objectGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectGroup", "org/jetbrains/debugger/EvaluateContextBase", "withValueManager"));
        }
        EvaluateContextBase evaluateContextBase = this;
        if (evaluateContextBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "withValueManager"));
        }
        return evaluateContextBase;
    }

    @Override
    public void releaseObjects() {
    }

    @Override
    @NotNull
    public abstract AsyncResult<Value> evaluate(@NotNull String var1, @Nullable Map<String, EvaluateContextAdditionalParameter> var2);

    @NotNull
    public final VALUE_MANAGER getValueManager() {
        VALUE_MANAGER VALUE_MANAGER = this.valueManager;
        if (VALUE_MANAGER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "getValueManager"));
        }
        return VALUE_MANAGER;
    }

    @Override
    @NotNull
    public ActionCallback refreshOnDone(@NotNull ActionCallback result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/debugger/EvaluateContextBase", "refreshOnDone"));
        }
        ActionCallback actionCallback = result.doWhenDone(((ValueManager)this.valueManager).getClearCachesTask());
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/EvaluateContextBase", "refreshOnDone"));
        }
        return actionCallback;
    }
}

