/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class OnePixelDivider
extends Divider {
    public static final Color BACKGROUND = new JBColor(Gray._153.withAlpha(128), Gray._100.withAlpha(128));
    private boolean myVertical;
    private Splitter mySplitter;
    private boolean myResizeEnabled;
    private boolean mySwitchOrientationEnabled;
    protected Point myPoint;
    private IdeGlassPane myGlassPane;
    private final MouseAdapter myListener = new MyMouseAdapter();
    private Disposable myDisposable;
    private boolean dragging = false;

    public OnePixelDivider(boolean vertical, Splitter splitter) {
        super((LayoutManager)new GridBagLayout());
        this.mySplitter = splitter;
        this.myResizeEnabled = true;
        this.mySwitchOrientationEnabled = false;
        this.setFocusable(false);
        this.enableEvents(48L);
        this.setOrientation(vertical);
        this.setBackground(BACKGROUND);
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private MouseEvent getTargetEvent(MouseEvent e) {
        return SwingUtilities.convertMouseEvent(e.getComponent(), e, (Component)((Object)this));
    }

    private void init() {
        this.myGlassPane = IdeGlassPaneUtil.find((Component)((Object)this));
        this.myDisposable = Disposer.newDisposable();
        this.myGlassPane.addMouseMotionPreprocessor(this.myListener, this.myDisposable);
        this.myGlassPane.addMousePreprocessor(this.myListener, this.myDisposable);
    }

    public void setOrientation(boolean vertical) {
        this.removeAll();
        this.myVertical = vertical;
        int cursorType = this.isVertical() ? 8 : 10;
        this.setCursor(Cursor.getPredefinedCursor(cursorType));
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (!this.myResizeEnabled) {
            return;
        }
        if (506 == e.getID() && this.dragging) {
            this.myPoint = SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), (Component)this.mySplitter);
            float firstMinProportion = this.getMinProportion(this.mySplitter.getFirstComponent());
            float secondMinProportion = this.getMinProportion(this.mySplitter.getSecondComponent());
            if (this.isVertical()) {
                if (this.getHeight() > 0) {
                    float proportion = Math.min(1.0f, Math.max(0.0f, Math.min(Math.max(firstMinProportion, (float)this.myPoint.y / (float)this.mySplitter.getHeight()), 1.0f - secondMinProportion)));
                    this.mySplitter.setProportion(proportion);
                }
            } else if (this.getWidth() > 0) {
                float proportion = Math.min(1.0f, Math.max(0.0f, Math.min(Math.max(firstMinProportion, (float)this.myPoint.x / (float)this.mySplitter.getWidth()), 1.0f - secondMinProportion)));
                this.mySplitter.setProportion(proportion);
            }
        }
    }

    private float getMinProportion(JComponent component) {
        if (component != null && this.mySplitter.getFirstComponent() != null && this.mySplitter.getFirstComponent().isVisible() && this.mySplitter.getSecondComponent() != null && this.mySplitter.getSecondComponent().isVisible()) {
            if (this.isVertical()) {
                return (float)component.getMinimumSize().height / (float)(this.mySplitter.getHeight() - 1);
            }
            return (float)component.getMinimumSize().width / (float)(this.mySplitter.getWidth() - 1);
        }
        return 0.0f;
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 500) {
            if (this.mySwitchOrientationEnabled && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown())) {
                this.mySplitter.setOrientation(!this.mySplitter.getOrientation());
            }
            if (this.myResizeEnabled && e.getClickCount() == 2) {
                this.mySplitter.setProportion(0.5f);
            }
        }
    }

    public void setResizeEnabled(boolean resizeEnabled) {
        this.myResizeEnabled = resizeEnabled;
        if (!this.myResizeEnabled) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
        }
    }

    public void setSwitchOrientationEnabled(boolean switchOrientationEnabled) {
        this.mySwitchOrientationEnabled = switchOrientationEnabled;
    }

    public boolean isVertical() {
        return this.myVertical;
    }

    private class MyMouseAdapter
    extends MouseAdapter
    implements Weighted {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            OnePixelDivider.this.dragging = this.isInDragZone(e);
            this._processMouseEvent(e);
        }

        boolean isInDragZone(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            Point p = event.getPoint();
            int r = Math.abs(OnePixelDivider.this.isVertical() ? p.y : p.x);
            return r < 6;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._processMouseEvent(e);
            OnePixelDivider.this.dragging = false;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            OnePixelDivider divider = OnePixelDivider.this;
            if (this.isInDragZone(e)) {
                OnePixelDivider.this.myGlassPane.setCursor(divider.getCursor(), (Object)divider);
            } else {
                OnePixelDivider.this.myGlassPane.setCursor(null, (Object)divider);
            }
            this._processMouseMotionEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._processMouseMotionEvent(e);
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        private void _processMouseMotionEvent(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                OnePixelDivider.this.myGlassPane.setCursor(null, OnePixelDivider.this.myListener);
                return;
            }
            OnePixelDivider.this.processMouseMotionEvent(event);
            if (event.isConsumed()) {
                e.consume();
            }
        }

        private void _processMouseEvent(MouseEvent e) {
            MouseEvent event = OnePixelDivider.this.getTargetEvent(e);
            if (event == null) {
                OnePixelDivider.this.myGlassPane.setCursor(null, OnePixelDivider.this.myListener);
                return;
            }
            OnePixelDivider.this.processMouseEvent(event);
            if (event.isConsumed()) {
                e.consume();
            }
        }
    }
}

