/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListToolbarDecorator;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableToolbarDecorator;
import com.intellij.ui.TreeToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolbarDecorator
implements CommonActionsPanel.ListenerFactory {
    protected Border myPanelBorder;
    protected Border myToolbarBorder;
    protected boolean myAddActionEnabled;
    protected boolean myEditActionEnabled;
    protected boolean myRemoveActionEnabled;
    protected boolean myUpActionEnabled;
    protected boolean myDownActionEnabled;
    protected Border myActionsPanelBorder;
    private final List<AnActionButton> myExtraActions = new SmartList();
    private ActionToolbarPosition myToolbarPosition;
    protected AnActionButtonRunnable myAddAction;
    protected AnActionButtonRunnable myEditAction;
    protected AnActionButtonRunnable myRemoveAction;
    protected AnActionButtonRunnable myUpAction;
    protected AnActionButtonRunnable myDownAction;
    private String myAddName;
    private String myEditName;
    private String myRemoveName;
    private String myMoveUpName;
    private String myMoveDownName;
    private AnActionButtonUpdater myAddActionUpdater = null;
    private AnActionButtonUpdater myRemoveActionUpdater = null;
    private AnActionButtonUpdater myEditActionUpdater = null;
    private AnActionButtonUpdater myMoveUpActionUpdater = null;
    private AnActionButtonUpdater myMoveDownActionUpdater = null;
    private Dimension myPreferredSize;
    private CommonActionsPanel myActionsPanel;
    private Comparator<AnActionButton> myButtonComparator;
    private boolean myAsUsualTopToolbar = false;
    private Icon myAddIcon;
    private boolean myForcedDnD = false;

    protected abstract JComponent getComponent();

    protected abstract void updateButtons();

    protected void updateExtraElementActions(boolean someElementSelected) {
        for (AnActionButton action : this.myExtraActions) {
            if (!(action instanceof ElementActionButton)) continue;
            action.setEnabled(someElementSelected);
        }
    }

    public final CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    public ToolbarDecorator initPosition() {
        this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.RIGHT);
        return this;
    }

    public ToolbarDecorator setAsUsualTopToolbar() {
        this.myAsUsualTopToolbar = true;
        this.setToolbarPosition(ActionToolbarPosition.TOP);
        return this;
    }

    public static ToolbarDecorator createDecorator(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ui/ToolbarDecorator", "createDecorator"));
        }
        return new TableToolbarDecorator(table, null).initPosition();
    }

    public static ToolbarDecorator createDecorator(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/ToolbarDecorator", "createDecorator"));
        }
        return ToolbarDecorator.createDecorator(tree, null);
    }

    private static ToolbarDecorator createDecorator(@NotNull JTree tree, @Nullable ElementProducer<?> producer) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/ToolbarDecorator", "createDecorator"));
        }
        return new TreeToolbarDecorator(tree, producer).initPosition();
    }

    public static ToolbarDecorator createDecorator(@NotNull JList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/ToolbarDecorator", "createDecorator"));
        }
        return new ListToolbarDecorator(list, null).initPosition();
    }

    public static ToolbarDecorator createDecorator(@NotNull JList list, EditableModel editableModel) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/ToolbarDecorator", "createDecorator"));
        }
        return new ListToolbarDecorator(list, editableModel).initPosition();
    }

    public static <T> ToolbarDecorator createDecorator(@NotNull TableView<T> table, @Nullable ElementProducer<T> producer) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ui/ToolbarDecorator", "createDecorator"));
        }
        return new TableToolbarDecorator(table, producer).initPosition();
    }

    public ToolbarDecorator disableAddAction() {
        this.myAddActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableRemoveAction() {
        this.myRemoveActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableUpAction() {
        this.myUpActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableUpDownActions() {
        this.myUpActionEnabled = false;
        this.myDownActionEnabled = false;
        return this;
    }

    public ToolbarDecorator disableDownAction() {
        this.myDownActionEnabled = false;
        return this;
    }

    public ToolbarDecorator setPanelBorder(Border border) {
        this.myPanelBorder = border;
        return this;
    }

    public ToolbarDecorator setToolbarBorder(Border border) {
        this.myActionsPanelBorder = border;
        return this;
    }

    public ToolbarDecorator setButtonComparator(Comparator<AnActionButton> buttonComparator) {
        this.myButtonComparator = buttonComparator;
        return this;
    }

    public ToolbarDecorator setButtonComparator(String ... actionNames) {
        final List<String> names = Arrays.asList(actionNames);
        this.myButtonComparator = new Comparator<AnActionButton>(){

            @Override
            public int compare(AnActionButton o1, AnActionButton o2) {
                String t1 = o1.getTemplatePresentation().getText();
                String t2 = o2.getTemplatePresentation().getText();
                if (t1 == null || t2 == null) {
                    return 0;
                }
                int ind1 = names.indexOf(t1);
                int ind2 = names.indexOf(t2);
                if (ind1 == -1 && ind2 >= 0) {
                    return 1;
                }
                if (ind2 == -1 && ind1 >= 0) {
                    return -1;
                }
                return ind1 - ind2;
            }
        };
        return this;
    }

    public ToolbarDecorator setLineBorder(int top, int left, int bottom, int right) {
        return this.setToolbarBorder(new CustomLineBorder(top, left, bottom, right));
    }

    public ToolbarDecorator addExtraAction(@NotNull AnActionButton action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ui/ToolbarDecorator", "addExtraAction"));
        }
        this.myExtraActions.add(action);
        return this;
    }

    public ToolbarDecorator addExtraActions(AnActionButton ... actions) {
        for (AnActionButton action : actions) {
            if (action == null) continue;
            this.addExtraAction(action);
        }
        return this;
    }

    public ToolbarDecorator setToolbarPosition(ActionToolbarPosition position) {
        this.myToolbarPosition = position;
        this.myActionsPanelBorder = new CustomLineBorder(this.myToolbarPosition == ActionToolbarPosition.BOTTOM ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.RIGHT ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.TOP ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.LEFT ? 1 : 0);
        return this;
    }

    public ToolbarDecorator setAddAction(AnActionButtonRunnable action) {
        this.myAddActionEnabled = action != null;
        this.myAddAction = action;
        return this;
    }

    public ToolbarDecorator setEditAction(AnActionButtonRunnable action) {
        this.myEditActionEnabled = action != null;
        this.myEditAction = action;
        return this;
    }

    public ToolbarDecorator setRemoveAction(AnActionButtonRunnable action) {
        this.myRemoveActionEnabled = action != null;
        this.myRemoveAction = action;
        return this;
    }

    public ToolbarDecorator setMoveUpAction(AnActionButtonRunnable action) {
        this.myUpActionEnabled = action != null;
        this.myUpAction = action;
        return this;
    }

    public ToolbarDecorator setMoveDownAction(AnActionButtonRunnable action) {
        this.myDownActionEnabled = action != null;
        this.myDownAction = action;
        return this;
    }

    public ToolbarDecorator setAddActionName(String name) {
        this.myAddName = name;
        return this;
    }

    public ToolbarDecorator setEditActionName(String name) {
        this.myEditName = name;
        return this;
    }

    public ToolbarDecorator setRemoveActionName(String name) {
        this.myRemoveName = name;
        return this;
    }

    public ToolbarDecorator setMoveUpActionName(String name) {
        this.myMoveUpName = name;
        return this;
    }

    public ToolbarDecorator setMoveDownActionName(String name) {
        this.myMoveDownName = name;
        return this;
    }

    public ToolbarDecorator setAddActionUpdater(AnActionButtonUpdater updater) {
        this.myAddActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setRemoveActionUpdater(AnActionButtonUpdater updater) {
        this.myRemoveActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setEditActionUpdater(AnActionButtonUpdater updater) {
        this.myEditActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setMoveUpActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveUpActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setMoveDownActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveDownActionUpdater = updater;
        return this;
    }

    public ToolbarDecorator setForcedDnD() {
        this.myForcedDnD = true;
        return this;
    }

    public ToolbarDecorator setActionGroup(@NotNull ActionGroup actionGroup) {
        AnAction[] actions;
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/ToolbarDecorator", "setActionGroup"));
        }
        for (AnAction action : actions = actionGroup.getChildren(null)) {
            if (action instanceof Separator) continue;
            this.addExtraAction(AnActionButton.fromAction(action));
        }
        return this;
    }

    public ToolbarDecorator setPreferredSize(Dimension size) {
        this.myPreferredSize = size;
        return this;
    }

    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        return this;
    }

    public ToolbarDecorator setAddIcon(Icon addIcon) {
        this.myAddIcon = addIcon;
        return this;
    }

    public JPanel createPanel() {
        Border mainBorder;
        CommonActionsPanel.Buttons[] buttons = this.getButtons();
        JComponent contextComponent = this.getComponent();
        this.myActionsPanel = new CommonActionsPanel(this, contextComponent, this.myToolbarPosition, this.myExtraActions.toArray(new AnActionButton[this.myExtraActions.size()]), this.myButtonComparator, this.myAddName, this.myRemoveName, this.myMoveUpName, this.myMoveDownName, this.myEditName, this.myAddIcon, buttons);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)contextComponent, true);
        if (this.myPreferredSize != null) {
            scrollPane.setPreferredSize(this.myPreferredSize);
        }
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                ToolbarDecorator.this.updateButtons();
            }
        };
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.myActionsPanel, this.getPlacement());
        this.installUpdaters();
        this.updateButtons();
        this.installDnD();
        panel.putClientProperty("ACTION_TOOLBAR", this.myActionsPanel.getComponent(0));
        Border border = mainBorder = this.myPanelBorder != null ? this.myPanelBorder : IdeBorderFactory.createBorder(15);
        if (this.myAsUsualTopToolbar) {
            scrollPane.setBorder(mainBorder);
        } else {
            this.myActionsPanel.setBorder(this.myActionsPanelBorder);
            panel.setBorder(mainBorder);
        }
        return panel;
    }

    private void installUpdaters() {
        if (this.myAddActionEnabled && this.myAddAction != null && this.myAddActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.ADD).addCustomUpdater(this.myAddActionUpdater);
        }
        if (this.myEditActionEnabled && this.myEditAction != null && this.myEditActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.EDIT).addCustomUpdater(this.myEditActionUpdater);
        }
        if (this.myRemoveActionEnabled && this.myRemoveAction != null && this.myRemoveActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.REMOVE).addCustomUpdater(this.myRemoveActionUpdater);
        }
        if (this.myUpActionEnabled && this.myUpAction != null && this.myMoveUpActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.UP).addCustomUpdater(this.myMoveUpActionUpdater);
        }
        if (this.myDownActionEnabled && this.myDownAction != null && this.myMoveDownActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.DOWN).addCustomUpdater(this.myMoveDownActionUpdater);
        }
    }

    protected void installDnD() {
        if ((this.myForcedDnD || this.myUpAction != null && this.myUpActionEnabled && this.myDownAction != null && this.myDownActionEnabled) && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.isModelEditable()) {
            this.installDnDSupport();
        }
    }

    protected abstract void installDnDSupport();

    protected abstract boolean isModelEditable();

    private Object getPlacement() {
        switch (this.myToolbarPosition) {
            case TOP: {
                return "North";
            }
            case LEFT: {
                return "West";
            }
            case BOTTOM: {
                return "South";
            }
            case RIGHT: {
                return "East";
            }
        }
        return "South";
    }

    private CommonActionsPanel.Buttons[] getButtons() {
        ArrayList<CommonActionsPanel.Buttons> buttons = new ArrayList<CommonActionsPanel.Buttons>();
        HashMap<CommonActionsPanel.Buttons, Pair> map = new HashMap<CommonActionsPanel.Buttons, Pair>();
        map.put(CommonActionsPanel.Buttons.ADD, Pair.create((Object)this.myAddActionEnabled, (Object)this.myAddAction));
        map.put(CommonActionsPanel.Buttons.REMOVE, Pair.create((Object)this.myRemoveActionEnabled, (Object)this.myRemoveAction));
        map.put(CommonActionsPanel.Buttons.EDIT, Pair.create((Object)this.myEditActionEnabled, (Object)this.myEditAction));
        map.put(CommonActionsPanel.Buttons.UP, Pair.create((Object)this.myUpActionEnabled, (Object)this.myUpAction));
        map.put(CommonActionsPanel.Buttons.DOWN, Pair.create((Object)this.myDownActionEnabled, (Object)this.myDownAction));
        for (CommonActionsPanel.Buttons button : CommonActionsPanel.Buttons.values()) {
            Pair action = (Pair)map.get((Object)button);
            if (action == null || action.first == null || !((Boolean)action.first).booleanValue() || action.second == null) continue;
            buttons.add(button);
        }
        return buttons.toArray(new CommonActionsPanel.Buttons[buttons.size()]);
    }

    @Override
    public CommonActionsPanel.Listener createListener(final CommonActionsPanel panel) {
        return new CommonActionsPanel.Listener(){

            @Override
            public void doAdd() {
                if (ToolbarDecorator.this.myAddAction != null) {
                    ToolbarDecorator.this.myAddAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.ADD));
                }
            }

            @Override
            public void doEdit() {
                if (ToolbarDecorator.this.myEditAction != null) {
                    ToolbarDecorator.this.myEditAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.EDIT));
                }
            }

            @Override
            public void doRemove() {
                if (ToolbarDecorator.this.myRemoveAction != null) {
                    ToolbarDecorator.this.myRemoveAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.REMOVE));
                }
            }

            @Override
            public void doUp() {
                if (ToolbarDecorator.this.myUpAction != null) {
                    ToolbarDecorator.this.myUpAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.UP));
                }
            }

            @Override
            public void doDown() {
                if (ToolbarDecorator.this.myDownAction != null) {
                    ToolbarDecorator.this.myDownAction.run(panel.getAnActionButton(CommonActionsPanel.Buttons.DOWN));
                }
            }
        };
    }

    public static AnActionButton findAddButton(@NotNull JComponent container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/ToolbarDecorator", "findAddButton"));
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.ADD);
    }

    public static AnActionButton findEditButton(@NotNull JComponent container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/ToolbarDecorator", "findEditButton"));
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.EDIT);
    }

    public static AnActionButton findRemoveButton(@NotNull JComponent container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/ToolbarDecorator", "findRemoveButton"));
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.REMOVE);
    }

    public static AnActionButton findUpButton(@NotNull JComponent container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/ToolbarDecorator", "findUpButton"));
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.UP);
    }

    public static AnActionButton findDownButton(@NotNull JComponent container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/ToolbarDecorator", "findDownButton"));
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.DOWN);
    }

    private static AnActionButton findButton(JComponent comp, CommonActionsPanel.Buttons type) {
        CommonActionsPanel panel = (CommonActionsPanel)UIUtil.findComponentOfType((JComponent)comp, CommonActionsPanel.class);
        if (panel != null) {
            return panel.getAnActionButton(type);
        }
        return null;
    }

    public static abstract class ElementActionButton
    extends AnActionButton {
        public ElementActionButton(String text, String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        public ElementActionButton(String text, Icon icon) {
            super(text, icon);
        }

        public ElementActionButton() {
        }

        public ElementActionButton(String text) {
            super(text);
        }
    }
}

