/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Base64;
import com.intellij.util.SystemProperties;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.net.IdeaWideAuthenticator;
import com.intellij.util.net.IdeaWideProxySelector;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="HttpConfigurable", storages={@Storage(file="$APP_CONFIG$/proxy.settings.xml"), @Storage(file="$APP_CONFIG$/other.xml", deprecated=true)})
public class HttpConfigurable
implements PersistentStateComponent<HttpConfigurable>,
ExportableApplicationComponent {
    public static final int CONNECTION_TIMEOUT = SystemProperties.getIntProperty((String)"idea.connection.timeout", (int)10000);
    public static final int READ_TIMEOUT = SystemProperties.getIntProperty((String)"idea.read.timeout", (int)60000);
    public static final int REDIRECT_LIMIT = SystemProperties.getIntProperty((String)"idea.redirect.limit", (int)10);
    public boolean PROXY_TYPE_IS_SOCKS;
    public boolean USE_HTTP_PROXY;
    public boolean USE_PROXY_PAC;
    public volatile transient boolean AUTHENTICATION_CANCELLED;
    public String PROXY_HOST;
    public int PROXY_PORT = 80;
    public volatile boolean PROXY_AUTHENTICATION;
    public volatile String PROXY_LOGIN;
    public volatile String PROXY_PASSWORD_CRYPT;
    public boolean KEEP_PROXY_PASSWORD;
    public transient String LAST_ERROR;
    private final THashMap<CommonProxy.HostInfo, ProxyInfo> myGenericPasswords = new THashMap();
    private final Set<CommonProxy.HostInfo> myGenericCancelled = new THashSet();
    public String PROXY_EXCEPTIONS;
    public boolean USE_PAC_URL;
    public String PAC_URL;
    private transient IdeaWideProxySelector mySelector;
    private final transient Object myLock = new Object();
    public transient Getter<PasswordAuthentication> myTestAuthRunnable = new StaticGetter(null);
    public transient Getter<PasswordAuthentication> myTestGenericAuthRunnable = new StaticGetter(null);

    public static HttpConfigurable getInstance() {
        return ServiceManager.getService(HttpConfigurable.class);
    }

    public static boolean editConfigurable(@Nullable JComponent parent) {
        return ShowSettingsUtil.getInstance().editConfigurable(parent, (Configurable)new HttpProxyConfigurable());
    }

    @Override
    public HttpConfigurable getState() {
        CommonProxy.isInstalledAssertion();
        HttpConfigurable state = new HttpConfigurable();
        XmlSerializerUtil.copyBean((Object)this, (Object)state);
        if (!this.KEEP_PROXY_PASSWORD) {
            state.PROXY_PASSWORD_CRYPT = null;
        }
        this.correctPasswords(state);
        return state;
    }

    @Override
    public void initComponent() {
        this.mySelector = new IdeaWideProxySelector(this);
        String name = this.getClass().getName();
        CommonProxy.getInstance().setCustom(name, this.mySelector);
        CommonProxy.getInstance().setCustomAuth(name, new IdeaWideAuthenticator(this));
    }

    @NotNull
    public ProxySelector getOnlyBySettingsSelector() {
        IdeaWideProxySelector ideaWideProxySelector = this.mySelector;
        if (ideaWideProxySelector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getOnlyBySettingsSelector"));
        }
        return ideaWideProxySelector;
    }

    @Override
    public void disposeComponent() {
        String name = this.getClass().getName();
        CommonProxy.getInstance().removeCustom(name);
        CommonProxy.getInstance().removeCustomAuth(name);
    }

    @Override
    @NotNull
    public String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getComponentName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctPasswords(@NotNull HttpConfigurable to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/net/HttpConfigurable", "correctPasswords"));
        }
        Object object = this.myLock;
        synchronized (object) {
            to.myGenericPasswords.retainEntries((TObjectObjectProcedure)new TObjectObjectProcedure<CommonProxy.HostInfo, ProxyInfo>(){

                public boolean execute(CommonProxy.HostInfo hostInfo, ProxyInfo proxyInfo) {
                    return proxyInfo.isStore();
                }
            });
        }
    }

    @Override
    public void loadState(@NotNull HttpConfigurable state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/util/net/HttpConfigurable", "loadState"));
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.PROXY_PASSWORD_CRYPT = null;
        }
        this.correctPasswords(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGenericPasswordCanceled(@NotNull String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/net/HttpConfigurable", "isGenericPasswordCanceled"));
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myGenericCancelled.contains(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenericPasswordCanceled(String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.add(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getGenericPassword(@NotNull String host, int port) {
        ProxyInfo proxyInfo;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/net/HttpConfigurable", "getGenericPassword"));
        }
        Object object = this.myLock;
        synchronized (object) {
            proxyInfo = (ProxyInfo)this.myGenericPasswords.get((Object)new CommonProxy.HostInfo(null, host, port));
        }
        if (proxyInfo == null) {
            return null;
        }
        return new PasswordAuthentication(proxyInfo.getUsername(), HttpConfigurable.decode(String.valueOf(proxyInfo.getPasswordCrypt())).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putGenericPassword(String host, int port, @NotNull PasswordAuthentication authentication, boolean remember) {
        if (authentication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authentication", "com/intellij/util/net/HttpConfigurable", "putGenericPassword"));
        }
        PasswordAuthentication coded = new PasswordAuthentication(authentication.getUserName(), HttpConfigurable.encode(String.valueOf(authentication.getPassword())).toCharArray());
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.put((Object)new CommonProxy.HostInfo(null, host, port), (Object)new ProxyInfo(remember, coded.getUserName(), String.valueOf(coded.getPassword())));
        }
    }

    @Transient
    @Nullable
    public String getPlainProxyPassword() {
        return this.PROXY_PASSWORD_CRYPT == null ? null : HttpConfigurable.decode(this.PROXY_PASSWORD_CRYPT);
    }

    private static String decode(String value) {
        return new String(Base64.decode((String)value));
    }

    @Transient
    public void setPlainProxyPassword(String password) {
        this.PROXY_PASSWORD_CRYPT = HttpConfigurable.encode(password);
    }

    private static String encode(String password) {
        return new String(Base64.encode((byte[])password.getBytes(CharsetToolkit.UTF8_CHARSET)));
    }

    public PasswordAuthentication getGenericPromptedAuthentication(final String prefix, final String host, final String prompt, final int port, final boolean remember) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PasswordAuthentication)this.myTestGenericAuthRunnable.get();
        }
        final Ref value = Ref.create();
        HttpConfigurable.runAboveAll(new Runnable(){

            @Override
            public void run() {
                if (HttpConfigurable.this.isGenericPasswordCanceled(host, port)) {
                    return;
                }
                PasswordAuthentication password = HttpConfigurable.this.getGenericPassword(host, port);
                if (password != null) {
                    value.set((Object)password);
                    return;
                }
                AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), prefix + host, "Please enter credentials for: " + prompt, "", "", remember);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    AuthenticationPanel panel = dialog.getPanel();
                    PasswordAuthentication passwordAuthentication = new PasswordAuthentication(panel.getLogin(), panel.getPassword());
                    HttpConfigurable.this.putGenericPassword(host, port, passwordAuthentication, remember && panel.isRememberPassword());
                    value.set((Object)passwordAuthentication);
                } else {
                    HttpConfigurable.this.setGenericPasswordCanceled(host, port);
                }
            }
        });
        return (PasswordAuthentication)value.get();
    }

    public PasswordAuthentication getPromptedAuthentication(final String host, final String prompt) {
        if (this.AUTHENTICATION_CANCELLED) {
            return null;
        }
        String password = this.getPlainProxyPassword();
        if (this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)this.PROXY_LOGIN) && !StringUtil.isEmptyOrSpaces((String)password)) {
            return new PasswordAuthentication(this.PROXY_LOGIN, password.toCharArray());
        }
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isDisposeInProgress() || ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PasswordAuthentication)this.myTestGenericAuthRunnable.get();
        }
        final PasswordAuthentication[] value = new PasswordAuthentication[1];
        HttpConfigurable.runAboveAll(new Runnable(){

            @Override
            public void run() {
                if (HttpConfigurable.this.AUTHENTICATION_CANCELLED) {
                    return;
                }
                String password = HttpConfigurable.this.getPlainProxyPassword();
                if (HttpConfigurable.this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)HttpConfigurable.this.PROXY_LOGIN) && !StringUtil.isEmptyOrSpaces((String)password)) {
                    value[0] = new PasswordAuthentication(HttpConfigurable.this.PROXY_LOGIN, password.toCharArray());
                    return;
                }
                AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), "Proxy authentication: " + host, "Please enter credentials for: " + prompt, HttpConfigurable.this.PROXY_LOGIN, "", HttpConfigurable.this.KEEP_PROXY_PASSWORD);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    HttpConfigurable.this.PROXY_AUTHENTICATION = true;
                    AuthenticationPanel panel = dialog.getPanel();
                    HttpConfigurable.this.KEEP_PROXY_PASSWORD = panel.isRememberPassword();
                    HttpConfigurable.this.PROXY_LOGIN = StringUtil.nullize((String)panel.getLogin());
                    HttpConfigurable.this.setPlainProxyPassword(String.valueOf(panel.getPassword()));
                    value[0] = new PasswordAuthentication(panel.getLogin(), panel.getPassword());
                } else {
                    HttpConfigurable.this.AUTHENTICATION_CANCELLED = true;
                }
            }
        });
        return value[0];
    }

    private static void runAboveAll(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/net/HttpConfigurable", "runAboveAll"));
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isModal()) {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(runnable);
        } else {
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread()) {
                runnable.run();
            } else {
                app.invokeAndWait(runnable, ModalityState.any());
            }
        }
    }

    @Deprecated
    public void readExternal(Element element) throws InvalidDataException {
        this.loadState((HttpConfigurable)XmlSerializer.deserialize((Element)element, HttpConfigurable.class));
    }

    @Deprecated
    public void writeExternal(Element element) throws WriteExternalException {
        XmlSerializer.serializeInto((Object)this.getState(), (Element)element);
        if (this.USE_PROXY_PAC && this.USE_HTTP_PROXY && !ApplicationManager.getApplication().isDisposed()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
                    if (frame != null) {
                        HttpConfigurable.this.USE_PROXY_PAC = false;
                        Messages.showMessageDialog(frame.getComponent(), "Proxy: both 'use proxy' and 'autodetect proxy' settings were set.\nOnly one of these options should be selected.\nPlease re-configure.", "Proxy Setup", Messages.getWarningIcon());
                        HttpConfigurable.editConfigurable(frame.getComponent());
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareURL(@NotNull String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/net/HttpConfigurable", "prepareURL"));
        }
        URLConnection connection = this.openConnection(url);
        try {
            connection.connect();
            connection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    @NotNull
    public URLConnection openConnection(@NotNull String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/util/net/HttpConfigurable", "openConnection"));
        }
        URL url = new URL(location);
        URLConnection urlConnection = null;
        List<Proxy> proxies = CommonProxy.getInstance().select(url);
        if (ContainerUtil.isEmpty(proxies)) {
            urlConnection = url.openConnection();
        } else {
            IOException exception = null;
            for (Proxy proxy : proxies) {
                try {
                    urlConnection = url.openConnection(proxy);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            if (urlConnection == null && exception != null) {
                throw exception;
            }
        }
        assert (urlConnection != null);
        urlConnection.setReadTimeout(READ_TIMEOUT);
        urlConnection.setConnectTimeout(CONNECTION_TIMEOUT);
        URLConnection uRLConnection = urlConnection;
        if (uRLConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "openConnection"));
        }
        return uRLConnection;
    }

    @NotNull
    public HttpURLConnection openHttpConnection(@NotNull String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/util/net/HttpConfigurable", "openHttpConnection"));
        }
        URLConnection urlConnection = this.openConnection(location);
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            if (httpURLConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "openHttpConnection"));
            }
            return httpURLConnection;
        }
        throw new IOException("Expected " + HttpURLConnection.class + ", but got " + urlConnection.getClass());
    }

    @NotNull
    public RequestConfig.Builder setProxy(@NotNull RequestConfig.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/net/HttpConfigurable", "setProxy"));
        }
        RequestConfig.Builder builder2 = this.setProxy(builder, this.USE_HTTP_PROXY);
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "setProxy"));
        }
        return builder2;
    }

    @NotNull
    public CredentialsProvider setProxyCredentials(@NotNull CredentialsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/net/HttpConfigurable", "setProxyCredentials"));
        }
        CredentialsProvider credentialsProvider = this.setProxyCredentials(provider, this.USE_HTTP_PROXY);
        if (credentialsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "setProxyCredentials"));
        }
        return credentialsProvider;
    }

    @NotNull
    public RequestConfig.Builder setProxy(@NotNull RequestConfig.Builder builder, boolean useProxy) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/net/HttpConfigurable", "setProxy"));
        }
        if (useProxy) {
            builder.setProxy(new HttpHost(this.PROXY_HOST, this.PROXY_PORT));
        }
        RequestConfig.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "setProxy"));
        }
        return builder2;
    }

    @NotNull
    public CredentialsProvider setProxyCredentials(@NotNull CredentialsProvider provider, boolean useProxy) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/net/HttpConfigurable", "setProxyCredentials"));
        }
        if (useProxy && this.PROXY_AUTHENTICATION) {
            provider.setCredentials(new AuthScope(this.PROXY_HOST, this.PROXY_PORT), (Credentials)new UsernamePasswordCredentials(this.PROXY_LOGIN, this.getPlainProxyPassword()));
        }
        CredentialsProvider credentialsProvider = provider;
        if (credentialsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "setProxyCredentials"));
        }
        return credentialsProvider;
    }

    public static List<KeyValue<String, String>> getJvmPropertiesList(boolean withAutodetection, @Nullable URI uri) {
        ArrayList<KeyValue<String, String>> result;
        block7: {
            List<Proxy> proxies;
            HttpConfigurable me;
            block5: {
                boolean putCredentials;
                block6: {
                    me = HttpConfigurable.getInstance();
                    if (!me.USE_HTTP_PROXY && !me.USE_PROXY_PAC) {
                        return Collections.emptyList();
                    }
                    result = new ArrayList<KeyValue<String, String>>();
                    if (!me.USE_HTTP_PROXY) break block5;
                    boolean bl = putCredentials = me.KEEP_PROXY_PASSWORD && StringUtil.isNotEmpty((String)me.PROXY_LOGIN);
                    if (!me.PROXY_TYPE_IS_SOCKS) break block6;
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyHost", (Object)me.PROXY_HOST));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyPort", (Object)String.valueOf(me.PROXY_PORT)));
                    if (putCredentials) {
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"java.net.socks.username", (Object)me.PROXY_LOGIN));
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"java.net.socks.password", (Object)me.getPlainProxyPassword()));
                    }
                    break block7;
                }
                result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyHost", (Object)me.PROXY_HOST));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyPort", (Object)String.valueOf(me.PROXY_PORT)));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyHost", (Object)me.PROXY_HOST));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyPort", (Object)String.valueOf(me.PROXY_PORT)));
                if (!putCredentials) break block7;
                result.add((KeyValue<String, String>)KeyValue.create((Object)"proxy.authentication.username", (Object)me.PROXY_LOGIN));
                result.add((KeyValue<String, String>)KeyValue.create((Object)"proxy.authentication.password", (Object)me.getPlainProxyPassword()));
                break block7;
            }
            if (me.USE_PROXY_PAC && withAutodetection && uri != null && (proxies = CommonProxy.getInstance().select(uri)) != null && !proxies.isEmpty()) {
                for (Proxy proxy : proxies) {
                    SocketAddress address;
                    if (!HttpConfigurable.isRealProxy(proxy) || !((address = proxy.address()) instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    if (Proxy.Type.SOCKS.equals((Object)proxy.type())) {
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyHost", (Object)inetSocketAddress.getHostName()));
                        result.add((KeyValue<String, String>)KeyValue.create((Object)"socksProxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                        continue;
                    }
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"http.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((KeyValue<String, String>)KeyValue.create((Object)"https.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                }
            }
        }
        return result;
    }

    public static boolean isRealProxy(@NotNull Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "com/intellij/util/net/HttpConfigurable", "isRealProxy"));
        }
        return !Proxy.NO_PROXY.equals(proxy) && !Proxy.Type.DIRECT.equals((Object)proxy.type());
    }

    @NotNull
    public static List<String> convertArguments(@NotNull List<KeyValue<String, String>> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
        }
        if (list.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
            }
            return list2;
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (KeyValue<String, String> value : list) {
            result.add("-D" + (String)value.getKey() + "=" + (String)value.getValue());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGenericPasswords() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.clear();
            this.myGenericCancelled.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeneric(@NotNull CommonProxy.HostInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/util/net/HttpConfigurable", "removeGeneric"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.remove((Object)info);
        }
    }

    @Override
    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"proxy.settings")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getExportFiles"));
        }
        return fileArray;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("Proxy Settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getPresentableName"));
        }
        return "Proxy Settings";
    }

    public static class ProxyInfo {
        public boolean myStore;
        public String myUsername;
        public String myPasswordCrypt;

        public ProxyInfo() {
        }

        public ProxyInfo(boolean store, String username, String passwordCrypt) {
            this.myStore = store;
            this.myUsername = username;
            this.myPasswordCrypt = passwordCrypt;
        }

        public boolean isStore() {
            return this.myStore;
        }

        public void setStore(boolean store) {
            this.myStore = store;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPasswordCrypt() {
            return this.myPasswordCrypt;
        }

        public void setPasswordCrypt(String passwordCrypt) {
            this.myPasswordCrypt = passwordCrypt;
        }
    }
}

