/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.run.ExternalToolRunner;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class EmulatorRunner
extends ExternalToolRunner {
    public EmulatorRunner(@NotNull Project project, @NotNull String consoleTitle, @NotNull GeneralCommandLine commandLine) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/avdmanager/EmulatorRunner", "<init>"));
        }
        if (consoleTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTitle", "com/android/tools/idea/avdmanager/EmulatorRunner", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/android/tools/idea/avdmanager/EmulatorRunner", "<init>"));
        }
        super(project, consoleTitle, commandLine);
    }

    @Override
    @NotNull
    protected ProcessHandler createProcessHandler(Process process) {
        OSProcessHandler oSProcessHandler = new OSProcessHandler(process){

            protected void destroyProcessImpl() {
                this.closeStreams();
                this.notifyProcessTerminated(0);
            }

            public boolean isSilentlyDestroyOnClose() {
                return true;
            }
        };
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/EmulatorRunner", "createProcessHandler"));
        }
        return oSProcessHandler;
    }

    @Override
    protected void fillToolBarActions(DefaultActionGroup toolbarActions) {
    }

    @Override
    protected ConsoleView initConsoleUi() {
        ConsoleView consoleView = super.initConsoleUi();
        String avdHome = System.getenv("ANDROID_SDK_HOME");
        if (!StringUtil.isEmpty((String)avdHome)) {
            consoleView.print("\nNote: The environment variable $ANDROID_SDK_HOME is set, and the emulator uses that variable to locate AVDs.\nThis may result in the emulator failing to start if it cannot find the AVDs in the folder pointed to by the\ngiven environment variable.\nANDROID_SDK_HOME=" + avdHome + "\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        return consoleView;
    }
}

