/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.avdmanager.LogWrapper;
import com.android.tools.idea.welcome.ComponentInstaller;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallOperation;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.WizardException;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsOperation
extends InstallOperation<File, File> {
    @NotNull
    private final Logger LOG;
    @Nullable
    private Multimap<PkgType, RemotePkgInfo> myRemotePackages;
    @NotNull
    private Collection<? extends InstallableComponent> myComponents;

    protected InstallComponentsOperation(@NotNull InstallContext context, @NotNull Collection<? extends InstallableComponent> components, @Nullable Multimap<PkgType, RemotePkgInfo> remotePackages, double progressRatio) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/InstallComponentsOperation", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/InstallComponentsOperation", "<init>"));
        }
        super(context, progressRatio);
        this.LOG = Logger.getInstance(this.getClass());
        this.myRemotePackages = remotePackages;
        this.myComponents = components;
    }

    @Nullable
    private static String getRetryMessage(ArrayList<String> packages) {
        String message = null;
        if (packages.size() == 1) {
            message = String.format("The following SDK component was not installed: %s", Iterables.getFirst(packages, null));
        } else if (!packages.isEmpty()) {
            message = String.format("The following SDK components were not installed: %s", Joiner.on((String)", ").join(packages));
        }
        return message;
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File sdkLocation) throws WizardException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/InstallComponentsOperation", "perform"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/welcome/InstallComponentsOperation", "perform"));
        }
        ComponentInstaller componentInstaller = new ComponentInstaller(this.myComponents, this.myRemotePackages);
        SdkManager manager = SdkManager.createManager((String)sdkLocation.getAbsolutePath(), (ILogger)new LogWrapper(this.LOG));
        if (manager != null) {
            indicator.setText("Checking for updated SDK components");
            ArrayList<String> packages = componentInstaller.getPackagesToInstall(manager);
            while (!packages.isEmpty()) {
                SdkManagerProgressIndicatorIntegration logger = new SdkManagerProgressIndicatorIntegration(indicator, this.myContext, packages.size());
                componentInstaller.installPackages(manager, packages, (ILogger)logger);
                manager.reloadSdk((ILogger)new LogWrapper(this.LOG));
                packages = componentInstaller.getPackagesToInstall(manager);
                String message = InstallComponentsOperation.getRetryMessage(packages);
                if (message == null) continue;
                this.promptToRetry(message, message, null);
            }
        } else {
            throw new WizardException("Corrupt SDK installation");
        }
        this.myContext.print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        File file = sdkLocation;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallComponentsOperation", "perform"));
        }
        return file;
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/InstallComponentsOperation", "cleanup"));
        }
    }
}

