/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.ActivityGalleryStep;
import com.android.tools.idea.wizard.AddAndroidActivityPath;
import com.android.tools.idea.wizard.ConfigureAndroidModuleStepDynamic;
import com.android.tools.idea.wizard.ConfigureFormFactorStep;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.TemplateEntry;
import com.android.tools.idea.wizard.TemplateParameterStep2;
import com.android.tools.idea.wizard.TemplateWizard;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NewFormFactorModulePath
extends DynamicWizardPath {
    private static final Logger LOG = Logger.getInstance(NewFormFactorModulePath.class);
    private static final ScopedStateStore.Key<Boolean> CREATE_ACTIVITY_KEY = ScopedStateStore.createKey("createActivity", ScopedStateStore.Scope.PATH, Boolean.class);
    private static final ScopedStateStore.Key<String> MODULE_LOCATION_KEY = ScopedStateStore.createKey("projectOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> RES_DIR_KEY = ScopedStateStore.createKey("resDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> SRC_DIR_KEY = ScopedStateStore.createKey("srcDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> AIDL_DIR_KEY = ScopedStateStore.createKey("aidlDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> MANIFEST_DIR_KEY = ScopedStateStore.createKey("manifestDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> TEST_DIR_KEY = ScopedStateStore.createKey("testDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> RES_OUT_KEY = ScopedStateStore.createKey("resOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> SRC_OUT_KEY = ScopedStateStore.createKey("srcOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> AIDL_OUT_KEY = ScopedStateStore.createKey("aidlOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> MANIFEST_OUT_KEY = ScopedStateStore.createKey("manifestOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> TEST_OUT_KEY = ScopedStateStore.createKey("testOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> RELATIVE_PACKAGE_KEY = ScopedStateStore.createKey("relativePackage", ScopedStateStore.Scope.PATH, String.class);
    private static final String RELATIVE_SRC_ROOT = FileUtil.join((String[])new String[]{TemplateWizard.MAIN_FLAVOR_SOURCE_PATH, "java"});
    private static final String RELATIVE_TEST_ROOT = FileUtil.join((String[])new String[]{TemplateWizard.TEST_SOURCE_PATH, "java"});
    private FormFactorUtils.FormFactor myFormFactor;
    private File myTemplateFile;
    private Disposable myDisposable;
    private final ScopedStateStore.Key<Boolean> myIsIncludedKey;
    private final ScopedStateStore.Key<String> myModuleNameKey;
    private TemplateParameterStep2 myParameterStep;
    private List<File> myFilesToOpen;

    public static List<NewFormFactorModulePath> getAvailableFormFactorModulePaths(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/NewFormFactorModulePath", "getAvailableFormFactorModulePaths"));
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        ArrayList toReturn = Lists.newArrayList();
        for (File templateFile : applicationTemplates) {
            FormFactorUtils.FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplate(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactorUtils.FormFactor.get(metadata.getFormFactor())) == null) continue;
            NewFormFactorModulePath path = new NewFormFactorModulePath(formFactor, templateFile, disposable);
            toReturn.add(path);
        }
        return toReturn;
    }

    public NewFormFactorModulePath(@NotNull FormFactorUtils.FormFactor formFactor, @NotNull File templateFile, @NotNull Disposable disposable) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/NewFormFactorModulePath", "<init>"));
        }
        if (templateFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFile", "com/android/tools/idea/wizard/NewFormFactorModulePath", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/NewFormFactorModulePath", "<init>"));
        }
        this.myFilesToOpen = Lists.newArrayList();
        this.myFormFactor = formFactor;
        this.myTemplateFile = templateFile;
        this.myDisposable = disposable;
        this.myIsIncludedKey = FormFactorUtils.getInclusionKey(formFactor);
        this.myModuleNameKey = FormFactorUtils.getModuleNameKey(formFactor);
    }

    @Override
    protected void init() {
        this.myState.put(WizardConstants.IS_LIBRARY_KEY, false);
        this.myState.put(SRC_DIR_KEY, this.calculateSrcDir());
        this.myState.put(RES_DIR_KEY, "src/main/res");
        this.myState.put(AIDL_DIR_KEY, "src/main/aidl");
        this.myState.put(MANIFEST_DIR_KEY, "src/main");
        this.myState.put(TEST_DIR_KEY, "src/androidTest");
        this.myState.put(CREATE_ACTIVITY_KEY, false);
        this.myState.put(RELATIVE_PACKAGE_KEY, "");
        this.addStep(new ConfigureAndroidModuleStepDynamic(this.getProject(), this.myDisposable));
        this.addStep(new ActivityGalleryStep(this.myFormFactor, true, AddAndroidActivityPath.KEY_SELECTED_TEMPLATE, this.myDisposable));
        String packageName = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        if (packageName == null) {
            packageName = "";
        }
        ImmutableMap presetsMap = ImmutableMap.of((Object)WizardConstants.PACKAGE_NAME_KEY.name, (Object)packageName, (Object)"isLauncher", (Object)true, (Object)"parentActivityClass", (Object)"");
        this.myParameterStep = new TemplateParameterStep2(this.myFormFactor, (Map<String, Object>)presetsMap, this.myDisposable, WizardConstants.PACKAGE_NAME_KEY, new SourceProvider[0]);
        this.addStep(this.myParameterStep);
    }

    @Override
    public void onPathStarted(boolean fromBeginning) {
        super.onPathStarted(fromBeginning);
        this.updatePackageDerivedValues();
    }

    void updatePackageDerivedValues() {
        this.myParameterStep.setPresetValue(WizardConstants.PACKAGE_NAME_KEY.name, this.myState.get(WizardConstants.PACKAGE_NAME_KEY));
        HashSet keys = Sets.newHashSetWithExpectedSize((int)5);
        keys.add(WizardConstants.PACKAGE_NAME_KEY);
        keys.add(SRC_DIR_KEY);
        keys.add(TEST_DIR_KEY);
        keys.add(WizardConstants.PROJECT_LOCATION_KEY);
        keys.add(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY);
        this.deriveValues(keys);
    }

    @NotNull
    private String calculateSrcDir() {
        String packageSegment = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        packageSegment = packageSegment == null ? "" : packageSegment.replace('.', File.separatorChar);
        String string = FileUtil.join((String[])new String[]{RELATIVE_SRC_ROOT, packageSegment});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFormFactorModulePath", "calculateSrcDir"));
        }
        return string;
    }

    @NotNull
    private String calculateTestDir() {
        String packageSegment = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        packageSegment = packageSegment == null ? "" : packageSegment.replace('.', File.separatorChar);
        String string = FileUtil.join((String[])new String[]{RELATIVE_TEST_ROOT, packageSegment});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFormFactorModulePath", "calculateTestDir"));
        }
        return string;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        boolean basePathModified;
        if (modified.contains(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY)) {
            if (this.myState.containsKey(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY) && this.myState.get(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY) == 1) {
                this.myState.put(this.myModuleNameKey, "app");
            } else if (!this.myState.containsKey(this.myModuleNameKey)) {
                this.myState.put(this.myModuleNameKey, FormFactorUtils.getModuleName(this.myFormFactor));
            }
        }
        boolean bl = basePathModified = modified.contains(WizardConstants.PROJECT_LOCATION_KEY) || modified.contains(this.myModuleNameKey);
        if (basePathModified) {
            this.myState.put(MODULE_LOCATION_KEY, FileUtil.join((String[])new String[]{this.myState.get(WizardConstants.PROJECT_LOCATION_KEY), this.myState.get(this.myModuleNameKey)}));
        }
        if (modified.contains(SRC_DIR_KEY) || modified.contains(WizardConstants.PACKAGE_NAME_KEY)) {
            this.myState.put(SRC_DIR_KEY, this.calculateSrcDir());
        }
        if (modified.contains(TEST_DIR_KEY) || modified.contains(WizardConstants.PACKAGE_NAME_KEY)) {
            this.myState.put(TEST_DIR_KEY, this.calculateTestDir());
        }
        if (modified.contains(SRC_DIR_KEY) || basePathModified) {
            this.updateOutputPath(SRC_DIR_KEY, SRC_OUT_KEY);
        }
        if (modified.contains(RES_DIR_KEY) || basePathModified) {
            this.updateOutputPath(RES_DIR_KEY, RES_OUT_KEY);
        }
        if (modified.contains(AIDL_DIR_KEY) || basePathModified) {
            this.updateOutputPath(AIDL_DIR_KEY, AIDL_OUT_KEY);
        }
        if (modified.contains(MANIFEST_DIR_KEY) || basePathModified) {
            this.updateOutputPath(MANIFEST_DIR_KEY, MANIFEST_OUT_KEY);
        }
        if (modified.contains(TEST_DIR_KEY) || basePathModified) {
            this.updateOutputPath(TEST_DIR_KEY, TEST_OUT_KEY);
        }
        if (this.myState.containsKey(WizardConstants.NEWLY_INSTALLED_API_KEY)) {
            Integer newApiLevel = this.myState.get(WizardConstants.NEWLY_INSTALLED_API_KEY);
            assert (newApiLevel != null);
            ScopedStateStore.Key<Integer> targetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(this.myFormFactor);
            Integer currentTargetLevel = this.myState.get(targetApiLevelKey);
            if (currentTargetLevel == null || newApiLevel > currentTargetLevel) {
                String newApiString = Integer.toString(newApiLevel);
                this.myState.put(targetApiLevelKey, newApiLevel);
                this.myState.put(FormFactorUtils.getTargetApiStringKey(this.myFormFactor), newApiString);
                this.myState.put(FormFactorUtils.getBuildApiLevelKey(this.myFormFactor), newApiLevel);
                this.myState.put(FormFactorUtils.getBuildApiKey(this.myFormFactor), newApiString);
            }
        }
    }

    private void updateOutputPath(@NotNull ScopedStateStore.Key<String> relativeDirKey, @NotNull ScopedStateStore.Key<String> outputDirKey) {
        if (relativeDirKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeDirKey", "com/android/tools/idea/wizard/NewFormFactorModulePath", "updateOutputPath"));
        }
        if (outputDirKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirKey", "com/android/tools/idea/wizard/NewFormFactorModulePath", "updateOutputPath"));
        }
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        String moduleName = this.myState.get(this.myModuleNameKey);
        String relativeLocation = this.myState.get(relativeDirKey);
        if (relativeLocation == null || projectLocation == null || moduleName == null) {
            return;
        }
        File baseLocation = new File(projectLocation, moduleName);
        relativeLocation = FileUtil.toSystemDependentName((String)relativeLocation);
        this.myState.put(outputDirKey, new File(baseLocation, relativeLocation).getPath());
    }

    @Override
    @NotNull
    public String getPathName() {
        String string = this.myFormFactor + " Module Creation Path";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFormFactorModulePath", "getPathName"));
        }
        return string;
    }

    @Override
    public boolean isPathVisible() {
        Boolean included = this.myState.get(this.myIsIncludedKey);
        return included == null ? false : included;
    }

    @Override
    public boolean performFinishingActions() {
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        if (projectLocation != null) {
            File projectRoot = new File(projectLocation);
            File moduleRoot = new File(projectRoot, this.myState.get(this.myModuleNameKey));
            try {
                Template.checkedCreateDirectoryIfMissing(moduleRoot);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
            Template template = Template.createFromPath(this.myTemplateFile);
            Map<String, Object> templateState = FormFactorUtils.scrubFormFactorPrefixes(this.myFormFactor, this.myState.flatten());
            template.render(projectRoot, moduleRoot, templateState, this.myWizard.getProject());
            TemplateEntry templateEntry = this.myState.get(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE);
            if (templateEntry == null) {
                return true;
            }
            Template activityTemplate = templateEntry.getTemplate();
            for (Parameter parameter : templateEntry.getMetadata().getParameters()) {
                templateState.put(parameter.id, this.myState.get(this.myParameterStep.getParameterKey(parameter)));
            }
            activityTemplate.render(projectRoot, moduleRoot, templateState, this.myWizard.getProject());
            this.myFilesToOpen = activityTemplate.getFilesToOpen();
            return true;
        }
        return false;
    }

    @NotNull
    public List<File> getFilesToOpen() {
        List<File> list = this.myFilesToOpen;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFormFactorModulePath", "getFilesToOpen"));
        }
        return list;
    }
}

