/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.model.RadComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadAbsListView
extends RadViewComponent {
    @Override
    public boolean addPopupActions(@NotNull AndroidDesignerEditorPanel designer, @NotNull DefaultActionGroup beforeGroup, @NotNull DefaultActionGroup afterGroup, @Nullable JComponent shortcuts, @NotNull List<RadComponent> selection) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/android/designer/model/RadAbsListView", "addPopupActions"));
        }
        if (beforeGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeGroup", "com/intellij/android/designer/model/RadAbsListView", "addPopupActions"));
        }
        if (afterGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGroup", "com/intellij/android/designer/model/RadAbsListView", "addPopupActions"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/android/designer/model/RadAbsListView", "addPopupActions"));
        }
        super.addPopupActions(designer, beforeGroup, afterGroup, shortcuts, selection);
        Configuration configuration = designer.getConfiguration();
        Module module = designer.getModule();
        IAndroidTarget target = configuration.getTarget();
        if (target != null && RenderService.supportsCapability(module, target, 8)) {
            beforeGroup.add((AnAction)this.createListTypeAction(designer));
            beforeGroup.addSeparator();
        }
        return true;
    }

    private DefaultActionGroup createListTypeAction(AndroidDesignerEditorPanel designer) {
        XmlTag tag = this.getTag();
        String tagName = tag.getName();
        boolean isSpinner = tagName.equals("Spinner");
        boolean isGridView = tagName.equals("GridView");
        String previewType = isGridView ? "Preview Grid Content" : (isSpinner ? "Preview Spinner Layout" : "Preview List Content");
        String selected = tag.getAttributeValue("listitem", "http://schemas.android.com/tools");
        if (selected != null && selected.startsWith("@android:layout/")) {
            selected = selected.substring("@android:layout/".length());
        }
        DefaultActionGroup previewGroup = new DefaultActionGroup("_" + previewType, true);
        previewGroup.add((AnAction)new PickLayoutAction(designer, "Choose Item Layout...", "listitem"));
        previewGroup.addSeparator();
        if (isSpinner) {
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Spinner Item", "simple_spinner_item", selected));
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Spinner Dropdown Item", "simple_spinner_dropdown_item", selected));
        } else {
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Simple List Item", "simple_list_item_1", selected));
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Simple 2-Line List Item", "simple_list_item_2", selected));
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Checked List Item", "simple_list_item_checked", selected));
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Single Choice List Item", "simple_list_item_single_choice", selected));
            previewGroup.add((AnAction)new SetListTypeAction(designer, "Multiple Choice List Item", "simple_list_item_multiple_choice", selected));
            if (!isGridView) {
                previewGroup.addSeparator();
                previewGroup.add((AnAction)new SetListTypeAction(designer, "Simple Expandable List Item", "simple_expandable_list_item_1", selected));
                previewGroup.add((AnAction)new SetListTypeAction(designer, "Simple 2-Line Expandable List Item", "simple_expandable_list_item_2", selected));
                previewGroup.addSeparator();
                previewGroup.add((AnAction)new PickLayoutAction(designer, "Choose Header...", "listheader"));
                previewGroup.add((AnAction)new PickLayoutAction(designer, "Choose Footer...", "listfooter"));
            }
        }
        return previewGroup;
    }

    private void setNewType(@NotNull AndroidDesignerEditorPanel panel, @NotNull String type, @Nullable String layout) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/android/designer/model/RadAbsListView", "setNewType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/android/designer/model/RadAbsListView", "setNewType"));
        }
        LayoutMetadata.setProperty(panel.getProject(), "Set List Type", panel.getXmlFile(), this.getTag(), type, "http://schemas.android.com/tools", layout);
        panel.requestRender();
    }

    private class SetListTypeAction
    extends AnAction {
        private final AndroidDesignerEditorPanel myPanel;
        private final String myLayout;

        public SetListTypeAction(@NotNull AndroidDesignerEditorPanel panel, @NotNull String title, @Nullable String layout, String selected) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/android/designer/model/RadAbsListView$SetListTypeAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/android/designer/model/RadAbsListView$SetListTypeAction", "<init>"));
            }
            if (layout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/android/designer/model/RadAbsListView$SetListTypeAction", "<init>"));
            }
            super(title);
            this.myPanel = panel;
            this.myLayout = layout;
            if (layout.equals(selected)) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.putClientProperty("selected", (Object)selected);
                templatePresentation.setIcon(AllIcons.Actions.Checked);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RadAbsListView.this.setNewType(this.myPanel, "listitem", "@android:layout/" + this.myLayout);
        }
    }

    private class PickLayoutAction
    extends AnAction {
        private final AndroidDesignerEditorPanel myPanel;
        private final String myType;

        private PickLayoutAction(AndroidDesignerEditorPanel panel, String title, String type) {
            super(title);
            this.myPanel = panel;
            this.myType = type;
        }

        public void actionPerformed(AnActionEvent e) {
            ChooseResourceDialog dialog = new ChooseResourceDialog(this.myPanel.getModule(), new ResourceType[]{ResourceType.LAYOUT}, null, null);
            dialog.setAllowCreateResource(false);
            dialog.show();
            if (dialog.isOK()) {
                String layout = dialog.getResourceName();
                RadAbsListView.this.setNewType(this.myPanel, this.myType, layout);
            }
        }
    }
}

