/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class ConcatenationHelper {
    private static final String builderClass = "java/lang/StringBuilder";
    private static final String bufferClass = "java/lang/StringBuffer";
    private static final String stringClass = "java/lang/String";
    private static final VarType builderType = new VarType(8, 0, "java/lang/StringBuilder");
    private static final VarType bufferType = new VarType(8, 0, "java/lang/StringBuffer");

    public static Exprent contractStringConcat(Exprent expr) {
        int found;
        InvocationExprent iex;
        Exprent exprTmp = null;
        VarType cltype = null;
        if (expr.type == 8 && "toString".equals((iex = (InvocationExprent)expr).getName())) {
            if (builderClass.equals(iex.getClassname())) {
                cltype = builderType;
            } else if (bufferClass.equals(iex.getClassname())) {
                cltype = bufferType;
            }
            if (cltype != null) {
                exprTmp = iex.getInstance();
            }
        }
        if (exprTmp == null) {
            return expr;
        }
        ArrayList<Exprent> lstOperands = new ArrayList<Exprent>();
        do {
            found = 0;
            switch (exprTmp.type) {
                case 8: {
                    InvocationExprent iex2 = (InvocationExprent)exprTmp;
                    if (!ConcatenationHelper.isAppendConcat(iex2, cltype)) break;
                    lstOperands.add(0, iex2.getLstParameters().get(0));
                    exprTmp = iex2.getInstance();
                    found = 1;
                    break;
                }
                case 10: {
                    NewExprent nex = (NewExprent)exprTmp;
                    if (!ConcatenationHelper.isNewConcat(nex, cltype)) break;
                    VarType[] params = nex.getConstructor().getDescriptor().params;
                    if (params.length == 1) {
                        lstOperands.add(0, nex.getConstructor().getLstParameters().get(0));
                    }
                    found = 2;
                }
            }
            if (found != 0) continue;
            return expr;
        } while (found != 2);
        int first2str = 0;
        for (int index = 0; index < lstOperands.size() && index < 2; ++index) {
            if (!((Exprent)lstOperands.get(index)).getExprType().equals(VarType.VARTYPE_STRING)) continue;
            first2str |= index + 1;
        }
        if (first2str == 0) {
            lstOperands.add(0, new ConstExprent(VarType.VARTYPE_STRING, ""));
        }
        for (int i = 0; i < lstOperands.size(); ++i) {
            boolean ok;
            Exprent rep = ConcatenationHelper.removeStringValueOf((Exprent)lstOperands.get(i));
            boolean bl = ok = i > 1;
            if (!ok) {
                boolean isstr = rep.getExprType().equals(VarType.VARTYPE_STRING);
                boolean bl2 = ok = isstr || first2str != i + 1;
                if (i == 0) {
                    first2str &= 2;
                }
            }
            if (!ok) continue;
            lstOperands.set(i, rep);
        }
        Exprent func = (Exprent)lstOperands.get(0);
        for (int i = 1; i < lstOperands.size(); ++i) {
            ArrayList<Exprent> lstTmp = new ArrayList<Exprent>();
            lstTmp.add(func);
            lstTmp.add((Exprent)lstOperands.get(i));
            func = new FunctionExprent(50, lstTmp);
        }
        return func;
    }

    private static boolean isAppendConcat(InvocationExprent expr, VarType cltype) {
        if ("append".equals(expr.getName())) {
            MethodDescriptor md = expr.getDescriptor();
            if (md.ret.equals(cltype) && md.params.length == 1) {
                VarType param = md.params[0];
                switch (param.type) {
                    case 8: {
                        if (!param.equals(VarType.VARTYPE_STRING) && !param.equals(VarType.VARTYPE_OBJECT)) break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isNewConcat(NewExprent expr, VarType cltype) {
        VarType[] params;
        return expr.getNewtype().equals(cltype) && ((params = expr.getConstructor().getDescriptor().params).length == 0 || params.length == 1 && params[0].equals(VarType.VARTYPE_STRING));
    }

    private static Exprent removeStringValueOf(Exprent exprent) {
        InvocationExprent iex;
        if (exprent.type == 8 && "valueOf".equals((iex = (InvocationExprent)exprent).getName()) && stringClass.equals(iex.getClassname())) {
            MethodDescriptor md = iex.getDescriptor();
            if (md.params.length == 1) {
                VarType param = md.params[0];
                switch (param.type) {
                    case 8: {
                        if (!param.equals(VarType.VARTYPE_OBJECT)) break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        return iex.getLstParameters().get(0);
                    }
                }
            }
        }
        return exprent;
    }
}

