/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class FieldExprent
extends Exprent {
    private String name;
    private String classname;
    private boolean isStatic;
    private Exprent instance;
    private FieldDescriptor descriptor;

    public FieldExprent(LinkConstant cn, Exprent instance) {
        this.type = 5;
        this.instance = instance;
        if (instance == null) {
            this.isStatic = true;
        }
        this.classname = cn.classname;
        this.name = cn.elementname;
        this.descriptor = FieldDescriptor.parseDescriptor(cn.descriptor);
    }

    public FieldExprent(String name, String classname, boolean isStatic, Exprent instance, FieldDescriptor descriptor) {
        this.type = 5;
        this.name = name;
        this.classname = classname;
        this.isStatic = isStatic;
        this.instance = instance;
        this.descriptor = descriptor;
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.type;
    }

    @Override
    public int getExprentUse() {
        if (this.instance == null) {
            return 1;
        }
        return this.instance.getExprentUse() & 1;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        return new FieldExprent(this.name, this.classname, this.isStatic, this.instance == null ? null : this.instance.copy(), this.descriptor);
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        StringBuilder buf = new StringBuilder();
        if (this.isStatic) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.classname)));
                buf.append(".");
            }
        } else {
            String super_qualifier = null;
            if (this.instance != null && this.instance.type == 12) {
                String this_classname;
                VarExprent instvar = (VarExprent)this.instance;
                VarVersionPaar varpaar = new VarVersionPaar(instvar);
                MethodWrapper current_meth = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
                if (current_meth != null && (this_classname = current_meth.varproc.getThisvars().get(varpaar)) != null && !this.classname.equals(this_classname)) {
                    super_qualifier = this_classname;
                }
            }
            if (super_qualifier != null) {
                StructClass current_class = ((ClassesProcessor.ClassNode)DecompilerContext.getProperty((String)"CURRENT_CLASS_NODE")).classStruct;
                if (!super_qualifier.equals(current_class.qualifiedName)) {
                    buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(super_qualifier)));
                    buf.append(".");
                }
                buf.append("super");
            } else {
                StringBuilder buff = new StringBuilder();
                boolean casted = ExprProcessor.getCastedExprent(this.instance, new VarType(8, 0, this.classname), buff, indent, true, tracer);
                String res = buff.toString();
                if (casted || this.instance.getPrecedence() > this.getPrecedence()) {
                    res = "(" + res + ")";
                }
                buf.append(res);
            }
            if (buf.toString().equals("<VAR_NAMELESS_ENCLOSURE>")) {
                buf.setLength(0);
            } else {
                buf.append(".");
            }
        }
        buf.append(this.name);
        tracer.addMapping(this.bytecode);
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof FieldExprent)) {
            return false;
        }
        FieldExprent ft = (FieldExprent)o;
        return InterpreterUtil.equalObjects(this.name, ft.getName()) && InterpreterUtil.equalObjects(this.classname, ft.getClassname()) && this.isStatic == ft.isStatic() && InterpreterUtil.equalObjects(this.instance, ft.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, ft.getDescriptor());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.instance) {
            this.instance = newexpr;
        }
    }

    public String getClassname() {
        return this.classname;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }
}

