/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class CatchStatement
extends Statement {
    private List<List<String>> exctstrings = new ArrayList<List<String>>();
    private List<VarExprent> vars = new ArrayList<VarExprent>();

    private CatchStatement() {
        this.type = 7;
    }

    private CatchStatement(Statement head, Statement next, HashSet<Statement> setHandlers) {
        this();
        this.first = head;
        this.stats.addWithKey(this.first, this.first.id);
        for (StatEdge edge : head.getSuccessorEdges(2)) {
            Statement stat = edge.getDestination();
            if (!setHandlers.contains(stat)) continue;
            this.stats.addWithKey(stat, stat.id);
            this.exctstrings.add(new ArrayList<String>(edge.getExceptions()));
            this.vars.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, edge.getExceptions().get(0)), (VarProcessor)DecompilerContext.getProperty("CURRENT_VAR_PROCESSOR")));
        }
        if (next != null) {
            this.post = next;
        }
    }

    public static Statement isHead(Statement head) {
        if (head.getLastBasicType() != 2) {
            return null;
        }
        HashSet<Statement> setHandlers = DecHelper.getUniquePredExceptions(head);
        if (!setHandlers.isEmpty()) {
            int hnextcount = 0;
            Statement next = null;
            List<StatEdge> lstHeadSuccs = head.getSuccessorEdges(0x40000000);
            if (!lstHeadSuccs.isEmpty() && lstHeadSuccs.get(0).getType() == 1) {
                next = lstHeadSuccs.get(0).getDestination();
                hnextcount = 2;
            }
            for (StatEdge edge : head.getSuccessorEdges(2)) {
                Statement stat = edge.getDestination();
                boolean handlerok = true;
                if (edge.getExceptions() != null && setHandlers.contains(stat)) {
                    if (stat.getLastBasicType() != 2) {
                        handlerok = false;
                    } else {
                        List<StatEdge> lstStatSuccs = stat.getSuccessorEdges(0x40000000);
                        if (!lstStatSuccs.isEmpty() && lstStatSuccs.get(0).getType() == 1) {
                            Statement statn = lstStatSuccs.get(0).getDestination();
                            if (next == null) {
                                next = statn;
                            } else if (next != statn) {
                                handlerok = false;
                            }
                            if (handlerok) {
                                ++hnextcount;
                            }
                        }
                    }
                } else {
                    handlerok = false;
                }
                if (handlerok) continue;
                setHandlers.remove(stat);
            }
            if (hnextcount != 1 && !setHandlers.isEmpty()) {
                ArrayList<Statement> lst = new ArrayList<Statement>();
                lst.add(head);
                lst.addAll(setHandlers);
                for (Statement st : lst) {
                    if (!st.isMonitorEnter()) continue;
                    return null;
                }
                if (DecHelper.checkStatementExceptions(lst)) {
                    return new CatchStatement(head, next, setHandlers);
                }
            }
        }
        return null;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        String indstr = InterpreterUtil.getIndentString(indent);
        StringBuilder buf = new StringBuilder();
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        if (this.isLabeled()) {
            buf.append(indstr).append("label").append(this.id).append(":").append(new_line_separator);
            tracer.incrementSourceLine();
        }
        buf.append(indstr).append("try {").append(new_line_separator);
        tracer.incrementSourceLine();
        buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, true, tracer));
        buf.append(indstr).append("}");
        for (int i = 1; i < this.stats.size(); ++i) {
            List<String> exception_types = this.exctstrings.get(i - 1);
            buf.append(" catch (");
            if (exception_types.size() > 1) {
                for (int exc_index = 1; exc_index < exception_types.size(); ++exc_index) {
                    VarType exc_type = new VarType(8, 0, exception_types.get(exc_index));
                    String exc_type_name = ExprProcessor.getCastTypeName(exc_type);
                    buf.append(exc_type_name).append(" | ");
                }
            }
            buf.append(this.vars.get(i - 1).toJava(indent, tracer));
            buf.append(") {").append(new_line_separator);
            tracer.incrementSourceLine();
            buf.append(ExprProcessor.jmpWrapper((Statement)this.stats.get(i), indent + 1, true, tracer)).append(indstr).append("}");
            tracer.incrementSourceLine();
        }
        buf.append(new_line_separator);
        tracer.incrementSourceLine();
        return buf.toString();
    }

    @Override
    public Statement getSimpleCopy() {
        CatchStatement cs = new CatchStatement();
        for (List<String> exc : this.exctstrings) {
            cs.exctstrings.add(new ArrayList<String>(exc));
            cs.vars.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, exc.get(0)), (VarProcessor)DecompilerContext.getProperty("CURRENT_VAR_PROCESSOR")));
        }
        return cs;
    }

    public List<VarExprent> getVars() {
        return this.vars;
    }
}

