/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.gant.GantRunner;
import org.jetbrains.plugins.groovy.gant.GantSettings;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GantScriptType
extends GroovyRunnableScriptType {
    @NonNls
    public static final String DEFAULT_EXTENSION = "gant";
    public static final GroovyScriptType INSTANCE = new GantScriptType();

    private GantScriptType() {
        super(DEFAULT_EXTENSION);
    }

    @Override
    @NotNull
    public Icon getScriptIcon() {
        Icon icon = JetgroovyIcons.Groovy.Gant_16x16;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/GantScriptType", "getScriptIcon"));
        }
        return icon;
    }

    @Override
    public GroovyScriptRunner getRunner() {
        return new GantRunner();
    }

    @Override
    public boolean isConfigurationByLocation(@NotNull GroovyScriptRunConfiguration existing, @NotNull Location place) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "org/jetbrains/plugins/groovy/gant/GantScriptType", "isConfigurationByLocation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/gant/GantScriptType", "isConfigurationByLocation"));
        }
        String params = existing.getScriptParameters();
        String s = GantScriptType.getTargetName(place);
        return s != null && params != null && (params.startsWith(s + " ") || params.equals(s));
    }

    @Nullable
    private static String getTargetName(Location location) {
        PsiElement parent = location.getPsiElement();
        while (!(parent.getParent() instanceof PsiFile) && parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCallExpression)parent, "target")) {
            GrArgumentLabel label;
            GrNamedArgument[] args = ((GrMethodCallExpression)parent).getNamedArguments();
            if (args.length == 1 && (label = args[0].getLabel()) != null) {
                return label.getName();
            }
            return null;
        }
        return null;
    }

    @Override
    public void tuneConfiguration(@NotNull GroovyFile file, @NotNull GroovyScriptRunConfiguration configuration, Location location) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/gant/GantScriptType", "tuneConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/groovy/gant/GantScriptType", "tuneConfiguration"));
        }
        String target = GantScriptType.getTargetName(location);
        if (target != null) {
            configuration.setScriptParameters(target);
            configuration.setName(configuration.getName() + "." + target);
        }
        RunManagerEx.disableTasks((Project)file.getProject(), (RunConfiguration)configuration, (Key[])new Key[]{CompileStepBeforeRun.ID, CompileStepBeforeRunNoErrorCheck.ID});
    }

    public static List<VirtualFile> additionalScopeFiles(@NotNull GroovyFile file) {
        String sdkHome;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/gant/GantScriptType", "additionalScopeFiles"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null && (sdkHome = GantUtils.getSdkHomeFromClasspath(module)) != null) {
            return Collections.emptyList();
        }
        GantSettings gantSettings = GantSettings.getInstance(file.getProject());
        VirtualFile home = gantSettings.getSdkHome();
        if (home == null) {
            return Collections.emptyList();
        }
        return gantSettings.getClassRoots();
    }

    @Override
    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/gant/GantScriptType", "patchResolveScope"));
        }
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "org/jetbrains/plugins/groovy/gant/GantScriptType", "patchResolveScope"));
        }
        return baseScope.uniteWith((GlobalSearchScope)new NonClasspathDirectoriesScope(GantScriptType.additionalScopeFiles(file)));
    }
}

