/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GroovyStringLexerBase
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(GroovyStringLexerBase.class);
    private final IElementType myContentElementType;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private int myStart;
    private int myEnd;
    private IElementType myTokenType;

    public GroovyStringLexerBase(IElementType contentElementType) {
        this.myContentElementType = contentElementType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/groovy/highlighter/GroovyStringLexerBase", "start"));
        }
        if (buffer.length() < endOffset) {
            LOG.error("buffer Length: " + buffer.length() + ", endOffset: " + endOffset, new Attachment[]{new Attachment("", ((Object)buffer).toString())});
        }
        this.myBuffer = buffer;
        this.myEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myTokenType = this.locateToken();
    }

    @Nullable
    private IElementType locateToken() {
        if (this.myEnd >= this.myBufferEnd) {
            return null;
        }
        this.myStart = this.myEnd;
        if (this.checkForSimpleValidEscape(this.myStart)) {
            this.myEnd = this.myStart + 2;
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (this.checkForHexCodeStart(this.myStart)) {
            this.myEnd = this.myStart + 2;
            while (this.myEnd < this.myStart + 6) {
                if (this.myEnd >= this.myBufferEnd || !StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd))) {
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                ++this.myEnd;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (this.checkForInvalidSimpleEscape(this.myStart)) {
            this.myEnd = this.myStart + 2;
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        while (this.myEnd < this.myBufferEnd && !this.checkForSimpleValidEscape(this.myEnd) && !this.checkForHexCodeStart(this.myEnd)) {
            ++this.myEnd;
        }
        return this.myContentElementType;
    }

    protected abstract boolean checkForSimpleValidEscape(int var1);

    protected abstract boolean checkForInvalidSimpleEscape(int var1);

    protected abstract boolean checkForHexCodeStart(int var1);

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myTokenType = this.locateToken();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/highlighter/GroovyStringLexerBase", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    protected char charAt(int i) {
        return this.myBuffer.charAt(i);
    }
}

