/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.GroovySdkForProjectFromSourcesStep;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public abstract class MvcProjectStructureDetector
extends ProjectStructureDetector {
    private final MvcFramework myFramework;
    private final String myDirectoryName;

    public MvcProjectStructureDetector(MvcFramework framework) {
        this.myFramework = framework;
        this.myDirectoryName = this.myFramework.getFrameworkName().toLowerCase() + "-app";
    }

    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector", "detectRoots"));
        }
        for (File child : children) {
            if (!child.getName().equals(this.myDirectoryName) || !child.isDirectory()) continue;
            result.add(new GroovyMvcProjectRoot(dir));
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        GroovySdkForProjectFromSourcesStep groovySdkStep = new GroovySdkForProjectFromSourcesStep(this, builder, projectDescriptor, this.myFramework);
        ModuleWizardStep javaSdkStep = ProjectWizardStepFactory.getInstance().createProjectJdkStep(builder.getContext());
        return Arrays.asList(new ModuleWizardStep[]{javaSdkStep, groovySdkStep});
    }

    private class GroovyMvcProjectRoot
    extends DetectedProjectRoot {
        public GroovyMvcProjectRoot(File dir) {
            super(dir);
        }

        @NotNull
        public String getRootTypeName() {
            String string = MvcProjectStructureDetector.this.myFramework.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector$GroovyMvcProjectRoot", "getRootTypeName"));
            }
            return string;
        }

        public boolean canContainRoot(@NotNull DetectedProjectRoot root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/groovy/mvc/MvcProjectStructureDetector$GroovyMvcProjectRoot", "canContainRoot"));
            }
            return false;
        }
    }
}

