/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;

public class LibrariesUtil {
    public static final String SOME_GROOVY_CLASS = "org.codehaus.groovy.control.CompilationUnit";

    private LibrariesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library[] getLibrariesByCondition(Module module, Condition<Library> condition) {
        if (module == null) {
            return new Library[0];
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            LibrariesUtil.populateOrderEntries(module, condition, libraries, false, (Set<Module>)new THashSet());
        }
        finally {
            accessToken.finish();
        }
        return libraries.toArray(new Library[libraries.size()]);
    }

    private static void populateOrderEntries(@NotNull Module module, Condition<Library> condition, ArrayList<Library> libraries, boolean exportedOnly, Set<Module> visited) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "populateOrderEntries"));
        }
        if (!visited.add(module)) {
            return;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            Module dep;
            if (entry instanceof LibraryOrderEntry) {
                Library library;
                LibraryOrderEntry libEntry = (LibraryOrderEntry)entry;
                if (exportedOnly && !libEntry.isExported() || !condition.value((Object)(library = libEntry.getLibrary()))) continue;
                libraries.add(library);
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry) || (dep = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            LibrariesUtil.populateOrderEntries(dep, condition, libraries, true, visited);
        }
    }

    public static Library[] getGlobalLibraries(Condition<Library> condition) {
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        List libs = ContainerUtil.findAll((Object[])table.getLibraries(), condition);
        return libs.toArray(new Library[libs.size()]);
    }

    @NotNull
    public static String getGroovyLibraryHome(Library library) {
        VirtualFile[] classRoots = library.getFiles(OrderRootType.CLASSES);
        String home = LibrariesUtil.getGroovyLibraryHome(classRoots);
        String string = home == null ? "" : home;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "getGroovyLibraryHome"));
        }
        return string;
    }

    public static boolean hasGroovySdk(@Nullable Module module) {
        return module != null && LibrariesUtil.getGroovyHomePath(module) != null;
    }

    @Nullable
    public static VirtualFile findJarWithClass(@NotNull Module module, String classQName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "findJarWithClass"));
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (PsiClass psiClass : JavaPsiFacade.getInstance((Project)module.getProject()).findClasses(classQName, scope)) {
            VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
            VirtualFile local = LibrariesUtil.getLocalFor(virtualFile);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    private static VirtualFile getLocalFor(VirtualFile virtualFile) {
        VirtualFileSystem fileSystem = virtualFile == null ? null : virtualFile.getFileSystem();
        return fileSystem instanceof LocalFileProvider ? ((LocalFileProvider)fileSystem).getLocalVirtualFileFor(virtualFile) : null;
    }

    @Nullable
    public static String getGroovyHomePath(@NotNull Module module) {
        VirtualFile parent;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "getGroovyHomePath"));
        }
        VirtualFile local = LibrariesUtil.findJarWithClass(module, SOME_GROOVY_CLASS);
        if (local != null && (parent = local.getParent()) != null) {
            if (("lib".equals(parent.getName()) || "embeddable".equals(parent.getName())) && parent.getParent() != null) {
                return parent.getParent().getPath();
            }
            return parent.getPath();
        }
        String home = LibrariesUtil.getGroovyLibraryHome(OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
        return StringUtil.isEmpty((String)home) ? null : home;
    }

    @Nullable
    private static String getGroovySdkHome(VirtualFile[] classRoots) {
        for (VirtualFile file : classRoots) {
            File parentFile;
            String jarPath;
            File realFile;
            String name = file.getName();
            if (!GroovyConfigUtils.GROOVY_JAR_PATTERN.matcher(name).matches() || !(realFile = new File(jarPath = file.getPresentableUrl())).exists() || (parentFile = realFile.getParentFile()) == null) continue;
            if ("lib".equals(parentFile.getName())) {
                return parentFile.getParent();
            }
            return parentFile.getPath();
        }
        return null;
    }

    @Nullable
    private static String getEmbeddableGroovyJar(VirtualFile[] classRoots) {
        for (VirtualFile file : classRoots) {
            String jarPath;
            File realFile;
            String name = file.getName();
            if (!GroovyConfigUtils.matchesGroovyAll(name) || !(realFile = new File(jarPath = file.getPresentableUrl())).exists()) continue;
            return realFile.getPath();
        }
        return null;
    }

    @Nullable
    public static String getGroovyLibraryHome(VirtualFile[] classRoots) {
        File emb;
        String sdkHome = LibrariesUtil.getGroovySdkHome(classRoots);
        if (sdkHome != null) {
            return sdkHome;
        }
        String embeddable = LibrariesUtil.getEmbeddableGroovyJar(classRoots);
        if (embeddable != null && (emb = new File(embeddable)).exists()) {
            File parent = emb.getParentFile();
            if ("embeddable".equals(parent.getName()) || "lib".equals(parent.getName())) {
                return parent.getParent();
            }
            return parent.getPath();
        }
        return null;
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile libFile) {
        if (libFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFile", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "getLocalFile"));
        }
        VirtualFile local = LibrariesUtil.getLocalFor(libFile);
        if (local != null) {
            VirtualFile virtualFile = local;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "getLocalFile"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = libFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/LibrariesUtil", "getLocalFile"));
        }
        return virtualFile;
    }

    public static void placeEntryToCorrectPlace(ModifiableRootModel model, LibraryOrderEntry addedEntry) {
        int i;
        OrderEntry[] order = model.getOrderEntries();
        assert (order[order.length - 1] == addedEntry);
        int insertionPoint = -1;
        for (i = 0; i < order.length - 1; ++i) {
            if (!(order[i] instanceof ModuleSourceOrderEntry)) continue;
            insertionPoint = i + 1;
            break;
        }
        if (insertionPoint >= 0) {
            for (i = order.length - 1; i > insertionPoint; --i) {
                order[i] = order[i - 1];
            }
            order[insertionPoint] = addedEntry;
            model.rearrangeOrderEntries(order);
        }
    }

    public static File[] getFilesInDirectoryByPattern(String dirPath, final Pattern pattern) {
        File distDir = new File(dirPath);
        File[] files = distDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        return files != null ? files : new File[]{};
    }
}

