/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.JiraVersion;
import com.intellij.tasks.jira.rest.JiraRestTask;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraRestApi
extends JiraRemoteApi {
    private static final Logger LOG = Logger.getInstance(JiraRestApi.class);

    public static JiraRestApi fromJiraVersion(@NotNull JiraVersion jiraVersion, @NotNull JiraRepository repository) {
        if (jiraVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jiraVersion", "com/intellij/tasks/jira/rest/JiraRestApi", "fromJiraVersion"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/rest/JiraRestApi", "fromJiraVersion"));
        }
        if (jiraVersion.getMajorNumber() == 4 && jiraVersion.getMinorNumber() >= 2) {
            return new JiraRestApi20Alpha1(repository);
        }
        if (jiraVersion.getMajorNumber() >= 5) {
            return new JiraRestApi2(repository);
        }
        LOG.warn("JIRA below 4.2.0 doesn't support REST API (" + jiraVersion + " used)");
        return null;
    }

    public static JiraRestApi fromJiraVersion(@NotNull String version, @NotNull JiraRepository repository) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/tasks/jira/rest/JiraRestApi", "fromJiraVersion"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/rest/JiraRestApi", "fromJiraVersion"));
        }
        return JiraRestApi.fromJiraVersion(new JiraVersion(version), repository);
    }

    protected JiraRestApi(@NotNull JiraRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/rest/JiraRestApi", "<init>"));
        }
        super(repository);
    }

    @Override
    @NotNull
    public final List<Task> findTasks(@NotNull String jql, int max) throws Exception {
        if (jql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jql", "com/intellij/tasks/jira/rest/JiraRestApi", "findTasks"));
        }
        GetMethod method = this.getMultipleIssuesSearchMethod(jql, max);
        String response = this.myRepository.executeMethod((HttpMethod)method);
        List<JiraIssue> issues = this.parseIssues(response);
        List list = ContainerUtil.map(issues, (Function)new Function<JiraIssue, Task>(){

            public JiraRestTask fun(JiraIssue issue) {
                return new JiraRestTask(issue, (TaskRepository)JiraRestApi.this.myRepository);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestApi", "findTasks"));
        }
        return list;
    }

    @Override
    @Nullable
    public final JiraRestTask findTask(@NotNull String key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/tasks/jira/rest/JiraRestApi", "findTask"));
        }
        GetMethod method = this.getSingleIssueSearchMethod(key);
        try {
            return new JiraRestTask(this.parseIssue(this.myRepository.executeMethod((HttpMethod)method)), (TaskRepository)this.myRepository);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    protected GetMethod getSingleIssueSearchMethod(String key) {
        GetMethod getMethod = new GetMethod(this.myRepository.getRestUrl("issue", key));
        if (getMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestApi", "getSingleIssueSearchMethod"));
        }
        return getMethod;
    }

    @NotNull
    protected GetMethod getMultipleIssuesSearchMethod(String jql, int max) {
        GetMethod method = new GetMethod(this.myRepository.getRestUrl("search"));
        method.setQueryString(new NameValuePair[]{new NameValuePair("jql", jql), new NameValuePair("maxResults", String.valueOf(max))});
        GetMethod getMethod = method;
        if (getMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/JiraRestApi", "getMultipleIssuesSearchMethod"));
        }
        return getMethod;
    }

    @NotNull
    protected abstract List<JiraIssue> parseIssues(String var1);

    @Nullable
    protected abstract JiraIssue parseIssue(String var1);

    @Override
    public void setTaskState(@NotNull Task task, @NotNull TaskState state) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/jira/rest/JiraRestApi", "setTaskState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/tasks/jira/rest/JiraRestApi", "setTaskState"));
        }
        String requestBody = this.getRequestForStateTransition(state);
        LOG.debug(String.format("Transition: %s -> %s, request: %s", task.getState(), state, requestBody));
        if (requestBody == null) {
            return;
        }
        PostMethod method = new PostMethod(this.myRepository.getRestUrl("issue", task.getId(), "transitions"));
        method.setRequestEntity(JiraRestApi.createJsonEntity(requestBody));
        this.myRepository.executeMethod((HttpMethod)method);
    }

    @Nullable
    protected abstract String getRequestForStateTransition(@NotNull TaskState var1);

    protected static RequestEntity createJsonEntity(String requestBody) {
        try {
            return new StringRequestEntity(requestBody, "application/json", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 encoding is not supported");
        }
    }
}

