/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + LambdaCanBeMethodReferenceInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Lambda can be replaced with method reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getDisplayName"));
        }
        return "Lambda can be replaced with method reference";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2MethodRef" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getShortName"));
        }
        return "Convert2MethodRef";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                if (PsiUtil.getLanguageLevel((PsiElement)expression).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiCallExpression callExpression;
                    PsiElement body = expression.getBody();
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (functionalInterfaceType != null && (callExpression = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body, expression.getParameterList().getParameters(), functionalInterfaceType)) != null) {
                        holder.registerProblem((PsiElement)callExpression, "Can be replaced with method reference", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithMethodRefFix()});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected static PsiCallExpression canBeMethodReferenceProblem(@Nullable PsiElement body, PsiParameter[] parameters, PsiType functionalInterfaceType) {
        PsiNewExpression newExpression;
        PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock(body);
        if (callExpression instanceof PsiNewExpression && ((newExpression = (PsiNewExpression)callExpression).getAnonymousClass() != null || newExpression.getArrayInitializer() != null)) {
            return null;
        }
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)callExpression, functionalInterfaceType, parameters);
        if (methodReferenceText != null) {
            LOG.assertTrue(callExpression != null);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)callExpression.getProject());
            PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(methodReferenceText, (PsiElement)callExpression);
            Map map = LambdaUtil.getFunctionalTypeMap();
            try {
                map.put(methodReferenceExpression, functionalInterfaceType);
                JavaResolveResult result = methodReferenceExpression.advancedResolve(false);
                PsiElement element = result.getElement();
                if (element != null && result.isAccessible()) {
                    if (element instanceof PsiMethod && !LambdaCanBeMethodReferenceInspection.isSimpleCall(parameters, callExpression, (PsiMethod)element)) {
                        PsiCallExpression psiCallExpression = null;
                        return psiCallExpression;
                    }
                    if (!(element instanceof PsiMethod)) {
                        LOG.assertTrue(callExpression instanceof PsiNewExpression);
                        PsiExpression[] dims = ((PsiNewExpression)callExpression).getArrayDimensions();
                        if (dims.length == 1 && parameters.length == 1) {
                            if (!LambdaCanBeMethodReferenceInspection.resolvesToParameter(dims[0], parameters[0])) {
                                PsiCallExpression psiCallExpression = null;
                                return psiCallExpression;
                            }
                        } else if (dims.length > 0) {
                            PsiCallExpression psiCallExpression = null;
                            return psiCallExpression;
                        }
                        PsiCallExpression psiCallExpression = callExpression;
                        return psiCallExpression;
                    }
                    PsiMethod method = callExpression.resolveMethod();
                    if (method == null) {
                        LOG.error((Object)callExpression);
                        PsiCallExpression psiCallExpression = null;
                        return psiCallExpression;
                    }
                    PsiCallExpression psiCallExpression = MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)element), (PsiMethod)method) ? callExpression : null;
                    return psiCallExpression;
                }
            }
            finally {
                map.remove(methodReferenceExpression);
            }
        }
        return null;
    }

    private static boolean isSimpleCall(final PsiParameter[] parameters, PsiCallExpression callExpression, PsiMethod psiMethod) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        int calledParametersCount = psiMethod.getParameterList().getParametersCount();
        PsiExpression[] expressions = argumentList.getExpressions();
        Object qualifier = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression().getQualifierExpression() : (callExpression instanceof PsiNewExpression ? ((PsiNewExpression)callExpression).getQualifier() : null);
        if (expressions.length == 0 && parameters.length == 0) {
            return true;
        }
        int offset = parameters.length - calledParametersCount;
        if (expressions.length > calledParametersCount || offset < 0) {
            return false;
        }
        for (int i = 0; i < expressions.length; ++i) {
            if (LambdaCanBeMethodReferenceInspection.resolvesToParameter(expressions[i], parameters[i + offset])) continue;
            return false;
        }
        if (offset == 0) {
            if (qualifier != null) {
                final boolean[] parameterUsed = new boolean[]{false};
                qualifier.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (parameterUsed[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        super.visitReferenceExpression(expression);
                        parameterUsed[0] = parameterUsed[0] | ArrayUtil.find((Object[])parameters, (Object)expression.resolve()) >= 0;
                    }
                });
                return !parameterUsed[0];
            }
            return true;
        }
        return LambdaCanBeMethodReferenceInspection.resolvesToParameter(qualifier, parameters[0]);
    }

    private static boolean resolvesToParameter(PsiExpression expression, PsiParameter parameter) {
        return expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).resolve() == parameter;
    }

    public static PsiCallExpression extractMethodCallFromBlock(PsiElement body) {
        PsiExpression expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
        if (expression instanceof PsiNewExpression && LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)((PsiNewExpression)expression).getQualifier())) {
            return (PsiCallExpression)expression;
        }
        if (expression instanceof PsiMethodCallExpression && LambdaCanBeMethodReferenceInspection.checkQualifier(((PsiMethodCallExpression)expression).getMethodExpression().getQualifier())) {
            return (PsiCallExpression)expression;
        }
        return null;
    }

    private static boolean checkQualifier(PsiElement qualifier) {
        return !(qualifier instanceof PsiCallExpression);
    }

    @Nullable
    private static PsiMethod getNonAmbiguousReceiver(PsiParameter[] parameters, @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getNonAmbiguousReceiver"));
        }
        String methodName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = containingClass.findMethodsByName(methodName, false);
        if (psiMethods.length == 1) {
            return psiMethod;
        }
        PsiType receiverType = parameters[0].getType();
        for (PsiMethod method : psiMethods) {
            if (!LambdaCanBeMethodReferenceInspection.isPairedNoReceiver(parameters, receiverType, method)) continue;
            PsiMethod[] deepestSuperMethods = psiMethod.findDeepestSuperMethods();
            if (deepestSuperMethods.length > 0) {
                for (PsiMethod superMethod : deepestSuperMethods) {
                    PsiMethod validSuperMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters, superMethod);
                    if (validSuperMethod == null) continue;
                    return validSuperMethod;
                }
            }
            return null;
        }
        return psiMethod;
    }

    private static boolean isPairedNoReceiver(PsiParameter[] parameters, PsiType receiverType, PsiMethod method) {
        PsiParameter[] nonReceiverCandidateParams = method.getParameterList().getParameters();
        return nonReceiverCandidateParams.length == parameters.length && method.hasModifierProperty("static") && TypeConversionUtil.areTypesConvertible((PsiType)nonReceiverCandidateParams[0].getType(), (PsiType)receiverType);
    }

    @Nullable
    protected static String createMethodReferenceText(PsiElement element, PsiType functionalInterfaceType, PsiParameter[] parameters) {
        String qualifierByNew;
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiMethod psiMethod = methodCall.resolveMethod();
            if (psiMethod == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String qualifierByMethodCall = LambdaCanBeMethodReferenceInspection.getQualifierTextByMethodCall(methodCall, functionalInterfaceType, parameters, psiMethod);
            if (qualifierByMethodCall != null) {
                return qualifierByMethodCall + "::" + ((PsiMethodCallExpression)element).getTypeArgumentList().getText() + methodExpression.getReferenceName();
            }
        } else if (element instanceof PsiNewExpression && (qualifierByNew = LambdaCanBeMethodReferenceInspection.getQualifierTextByNewExpression((PsiNewExpression)element)) != null) {
            return qualifierByNew + ((PsiNewExpression)element).getTypeArgumentList().getText() + "::new";
        }
        return null;
    }

    private static String getQualifierTextByNewExpression(PsiNewExpression element) {
        PsiType deepComponentType;
        JavaResolveResult resolve;
        PsiElement resolveElement;
        PsiType newExprType = element.getType();
        if (newExprType == null) {
            return null;
        }
        PsiClass containingClass = null;
        PsiJavaCodeReferenceElement classReference = element.getClassOrAnonymousClassReference();
        if (classReference != null && (resolveElement = (resolve = classReference.advancedResolve(false)).getElement()) instanceof PsiClass) {
            containingClass = (PsiClass)resolveElement;
        }
        String classOrPrimitiveName = null;
        if (containingClass != null) {
            classOrPrimitiveName = LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        } else if (newExprType instanceof PsiArrayType && (deepComponentType = newExprType.getDeepComponentType()) instanceof PsiPrimitiveType) {
            classOrPrimitiveName = deepComponentType.getCanonicalText();
        }
        if (classOrPrimitiveName == null) {
            return null;
        }
        int dim = newExprType.getArrayDimensions();
        while (dim-- > 0) {
            classOrPrimitiveName = classOrPrimitiveName + "[]";
        }
        return classOrPrimitiveName;
    }

    private static String getQualifierTextByMethodCall(PsiMethodCallExpression methodCall, PsiType functionalInterfaceType, PsiParameter[] parameters, PsiMethod psiMethod) {
        PsiClass parentContainingClass;
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        PsiClass containingClass = psiMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (qualifierExpression != null) {
            boolean isReceiverType = PsiMethodReferenceUtil.isReceiverType((PsiType)functionalInterfaceType, (PsiClass)containingClass, (PsiMethod)psiMethod);
            return isReceiverType ? LambdaCanBeMethodReferenceInspection.composeReceiverQualifierText(parameters, psiMethod, containingClass, qualifierExpression) : qualifierExpression.getText();
        }
        if (psiMethod.hasModifierProperty("static")) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiClass treeContainingClass = parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        while (treeContainingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)treeContainingClass, (PsiClass)containingClass, (boolean)true)) {
            treeContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)treeContainingClass, PsiClass.class, (boolean)true);
        }
        if (treeContainingClass != null && containingClass != parentContainingClass && treeContainingClass != parentContainingClass) {
            String treeContainingClassName = treeContainingClass.getName();
            if (treeContainingClassName == null) {
                return null;
            }
            return treeContainingClassName + ".this";
        }
        return "this";
    }

    private static String composeReceiverQualifierText(PsiParameter[] parameters, PsiMethod psiMethod, PsiClass containingClass, @NotNull PsiExpression qualifierExpression) {
        PsiType qualifierExpressionType;
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "composeReceiverQualifierText"));
        }
        if (psiMethod.hasModifierProperty("static")) {
            return null;
        }
        PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters, psiMethod);
        if (nonAmbiguousMethod == null) {
            return null;
        }
        PsiClass nonAmbiguousContainingClass = nonAmbiguousMethod.getContainingClass();
        if (!containingClass.equals(nonAmbiguousContainingClass)) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        if (containingClass.isPhysical() && qualifierExpression instanceof PsiReferenceExpression) {
            boolean parameterWithoutFormalType;
            PsiElement resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
            boolean bl = parameterWithoutFormalType = resolve instanceof PsiParameter && ((PsiParameter)resolve).getTypeElement() == null;
            if (parameterWithoutFormalType && ArrayUtil.find((Object[])parameters, (Object)resolve) > -1) {
                return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
            }
        }
        return (qualifierExpressionType = qualifierExpression.getType()) != null ? qualifierExpressionType.getCanonicalText() : LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
    }

    private static String getClassReferenceName(PsiClass containingClass) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        String containingClassName = containingClass.getName();
        return containingClassName != null ? containingClassName : "";
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace lambda with method reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getName"));
            }
            return "Replace lambda with method reference";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            if (lambdaExpression == null) {
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType == null || !functionalInterfaceType.isValid()) {
                return;
            }
            String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(element, functionalInterfaceType, lambdaExpression.getParameterList().getParameters());
            if (methodRefText != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression psiExpression = factory.createExpressionFromText(methodRefText, (PsiElement)lambdaExpression);
                PsiElement replace = lambdaExpression.replace((PsiElement)psiExpression);
                if (((PsiMethodReferenceExpression)replace).getFunctionalInterfaceType() == null) {
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(A)a", replace);
                    cast.getCastType().replace((PsiElement)factory.createTypeElement(functionalInterfaceType));
                    cast.getOperand().replace(replace);
                    replace = replace.replace((PsiElement)cast);
                }
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replace);
            }
        }
    }
}

