/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileAction
extends CreateElementActionBase
implements DumbAware {
    public CreateFileAction() {
        super(IdeBundle.message((String)"action.create.new.file", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.file.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
    }

    public CreateFileAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public boolean isDumbAware() {
        return CreateFileAction.class.equals(((Object)((Object)this)).getClass());
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        MyValidator validator = new MyValidator(project, directory);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement[] psiElementArray;
            try {
                psiElementArray = validator.create("test");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CreateFileAction", "invokeDialog"));
            }
            return psiElementArray;
        }
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.file.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CreateFileAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        MkDirs mkdirs = new MkDirs(newName, directory);
        PsiElement[] psiElementArray = new PsiElement[]{mkdirs.directory.createFile(this.getFileName(mkdirs.newName))};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CreateFileAction", "create"));
        }
        return psiElementArray;
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return IdeBundle.message((String)"progress.creating.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), File.separator, newName});
    }

    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    protected String getCommandName() {
        return IdeBundle.message((String)"command.create.file", (Object[])new Object[0]);
    }

    protected String getFileName(String newName) {
        if (this.getDefaultExtension() == null || FileUtilRt.getExtension((String)newName).length() > 0) {
            return newName;
        }
        return newName + "." + this.getDefaultExtension();
    }

    @Nullable
    protected String getDefaultExtension() {
        return null;
    }

    protected class MyValidator
    extends CreateElementActionBase.MyInputValidator
    implements InputValidatorEx {
        private String myErrorText;

        public MyValidator(Project project, PsiDirectory directory) {
            super((CreateElementActionBase)CreateFileAction.this, project, directory);
        }

        public boolean checkInput(String inputString) {
            if (FileTypeManager.getInstance().isFileIgnored(CreateFileAction.this.getFileName(inputString))) {
                this.myErrorText = "This filename is ignored (Settings | File Types | Ignore files and folders)";
                return false;
            }
            if (inputString.equals(".") || StringUtil.isEmpty((String)inputString.replace('.', ' ').trim())) {
                this.myErrorText = "Can't create file with name '" + inputString + "'";
                return false;
            }
            this.myErrorText = null;
            return true;
        }

        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        public PsiElement[] create(String newName) throws Exception {
            UsageTrigger.trigger("CreateFile." + ((Object)((Object)CreateFileAction.this)).getClass().getSimpleName());
            return super.create(newName);
        }

        public boolean canClose(String inputString) {
            if (inputString.length() == 0) {
                return super.canClose(inputString);
            }
            PsiDirectory psiDirectory = this.getDirectory();
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)new FakeVirtualFile(psiDirectory.getVirtualFile(), CreateFileAction.this.getFileName(inputString)), psiDirectory.getProject());
            return type != null && super.canClose(CreateFileAction.this.getFileName(inputString));
        }
    }

    public static class MkDirs {
        public final String newName;
        public final PsiDirectory directory;

        public MkDirs(@NotNull String newName, @NotNull PsiDirectory directory) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/actions/CreateFileAction$MkDirs", "<init>"));
            }
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/actions/CreateFileAction$MkDirs", "<init>"));
            }
            if (SystemInfo.isWindows) {
                newName = newName.replace('\\', '/');
            }
            if (newName.contains("/")) {
                List subDirs = StringUtil.split((String)newName, (String)"/");
                newName = (String)subDirs.remove(subDirs.size() - 1);
                for (String dir : subDirs) {
                    PsiDirectory sub = directory.findSubdirectory(dir);
                    directory = sub == null ? directory.createSubdirectory(dir) : sub;
                }
            }
            this.newName = newName;
            this.directory = directory;
        }
    }
}

