/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeDesktopEntryStep;
import com.intellij.ide.customize.CustomizeFeaturedPluginsStepPanel;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.customize.CustomizeKeyboardSchemeStepPanel;
import com.intellij.ide.customize.CustomizePluginsStepPanel;
import com.intellij.ide.customize.CustomizeUIThemeStepPanel;
import com.intellij.ide.customize.PluginGroups;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBCardLayout;
import com.intellij.util.PlatformUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CustomizeIDEWizardDialog
extends DialogWrapper
implements ActionListener {
    private static final String BUTTONS = "BUTTONS";
    private static final String NOBUTTONS = "NOBUTTONS";
    private final JButton mySkipButton = new JButton("Skip All and Set Defaults");
    private final JButton myBackButton = new JButton("Back");
    private final JButton myNextButton = new JButton("Next");
    private final JBCardLayout myCardLayout = new JBCardLayout();
    protected final List<AbstractCustomizeWizardStep> mySteps = new ArrayList<AbstractCustomizeWizardStep>();
    private int myIndex = 0;
    private final JLabel myNavigationLabel = new JLabel();
    private final JLabel myHeaderLabel = new JLabel();
    private final JLabel myFooterLabel = new JLabel();
    private final CardLayout myButtonWrapperLayout = new CardLayout();
    private final JPanel myButtonWrapper = new JPanel(this.myButtonWrapperLayout);
    private JPanel myContentPanel;

    public CustomizeIDEWizardDialog() {
        super(null, true, true);
        this.setTitle("Customize " + ApplicationNamesInfo.getInstance().getProductName());
        this.getPeer().setAppIcons();
        this.initSteps();
        this.mySkipButton.addActionListener(this);
        this.myBackButton.addActionListener(this);
        this.myNextButton.addActionListener(this);
        this.myNavigationLabel.setEnabled(false);
        this.myFooterLabel.setEnabled(false);
        this.init();
        this.initCurrentStep(true);
        this.setSize(400, 300);
        System.setProperty("StartupWizardMode", "true");
    }

    public static void showCustomSteps(String stepsProviderName) {
        CustomizeIDEWizardStepsProvider provider;
        try {
            Class<?> providerClass = Class.forName(stepsProviderName);
            provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
        }
        catch (Throwable e) {
            Main.showMessage((String)"Start Failed", (Throwable)e);
            return;
        }
        new CustomizeIDEWizardDialog(){

            @Override
            protected void initSteps() {
                provider.initSteps(this, this.mySteps);
            }
        }.show();
    }

    protected void dispose() {
        System.clearProperty("StartupWizardMode");
        super.dispose();
    }

    protected void initSteps() {
        this.mySteps.add(new CustomizeUIThemeStepPanel());
        if (SystemInfo.isMac) {
            this.mySteps.add(new CustomizeKeyboardSchemeStepPanel());
        }
        if (CustomizeDesktopEntryStep.isAvailable()) {
            this.mySteps.add(new CustomizeDesktopEntryStep("/UbuntuDesktopEntry.png"));
        }
        PluginGroups pluginGroups = new PluginGroups();
        this.mySteps.add(new CustomizePluginsStepPanel(pluginGroups));
        try {
            this.mySteps.add(new CustomizeFeaturedPluginsStepPanel(pluginGroups));
        }
        catch (CustomizeFeaturedPluginsStepPanel.OfflineException offlineException) {
            // empty catch block
        }
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout(5, 5));
        this.myContentPanel = new JPanel((LayoutManager)this.myCardLayout);
        for (AbstractCustomizeWizardStep step : this.mySteps) {
            this.myContentPanel.add((Component)step, step.getTitle());
        }
        JPanel topPanel = new JPanel(new BorderLayout(5, 5));
        topPanel.add((Component)this.myNavigationLabel, "North");
        topPanel.add((Component)this.myHeaderLabel, "Center");
        result.add((Component)topPanel, "North");
        result.add((Component)this.myContentPanel, "Center");
        result.add((Component)this.myFooterLabel, "South");
        result.setPreferredSize(new Dimension(700, 600));
        result.setBorder(AbstractCustomizeWizardStep.createSmallEmptyBorder());
        return result;
    }

    protected JComponent createSouthPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 5;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (!PlatformUtils.isCLion()) {
            buttonPanel.add((Component)this.mySkipButton, gbc);
            ++gbc.gridx;
        }
        buttonPanel.add((Component)this.myBackButton, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        buttonPanel.add((Component)this.myNextButton, gbc);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.myButtonWrapper.add((Component)buttonPanel, BUTTONS);
        this.myButtonWrapper.add((Component)new JLabel(), NOBUTTONS);
        this.myButtonWrapperLayout.show(this.myButtonWrapper, BUTTONS);
        return this.myButtonWrapper;
    }

    void setButtonsVisible(boolean visible) {
        this.myButtonWrapperLayout.show(this.myButtonWrapper, visible ? BUTTONS : NOBUTTONS);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mySkipButton) {
            this.doOKAction();
            return;
        }
        if (e.getSource() == this.myBackButton) {
            --this.myIndex;
            this.initCurrentStep(false);
            return;
        }
        if (e.getSource() == this.myNextButton) {
            if (this.myIndex >= this.mySteps.size() - 1) {
                this.doOKAction();
                return;
            }
            ++this.myIndex;
            this.initCurrentStep(true);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return null;
    }

    public void doCancelAction() {
        this.doOKAction();
    }

    protected void doOKAction() {
        for (AbstractCustomizeWizardStep step : this.mySteps) {
            if (step.beforeOkAction()) continue;
            int index = this.mySteps.indexOf(step);
            if (this.myIndex != index) {
                this.myIndex = index;
                this.initCurrentStep(true);
            }
            return;
        }
        super.doOKAction();
    }

    private void initCurrentStep(boolean forward) {
        final AbstractCustomizeWizardStep myCurrentStep = this.mySteps.get(this.myIndex);
        myCurrentStep.beforeShown(forward);
        this.myCardLayout.swipe((Container)this.myContentPanel, myCurrentStep.getTitle(), JBCardLayout.SwipeDirection.AUTO, new Runnable(){

            @Override
            public void run() {
                Component component = myCurrentStep.getDefaultFocusedComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
        this.myBackButton.setVisible(this.myIndex > 0);
        if (this.myIndex > 0) {
            this.myBackButton.setText("Back to " + this.mySteps.get(this.myIndex - 1).getTitle());
        }
        this.mySkipButton.setText("Skip " + (this.myIndex > 0 ? "Remaining" : "All") + " and Set Defaults");
        this.myNextButton.setText(this.myIndex < this.mySteps.size() - 1 ? "Next: " + this.mySteps.get(this.myIndex + 1).getTitle() : "Start using " + ApplicationNamesInfo.getInstance().getFullProductName());
        this.myHeaderLabel.setText(myCurrentStep.getHTMLHeader());
        this.myFooterLabel.setText(myCurrentStep.getHTMLFooter());
        StringBuilder navHTML = new StringBuilder("<html><body>");
        for (int i = 0; i < this.mySteps.size(); ++i) {
            if (i > 0) {
                navHTML.append("&nbsp;&#8594;&nbsp;");
            }
            if (i == this.myIndex) {
                navHTML.append("<b>");
            }
            navHTML.append(this.mySteps.get(i).getTitle());
            if (i != this.myIndex) continue;
            navHTML.append("</b>");
        }
        this.myNavigationLabel.setText(navHTML.toString());
    }
}

