/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.RoamingType;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentRoamingManager {
    private static final ComponentRoamingManager OUR_INSTANCE = new ComponentRoamingManager();
    private final Map<String, RoamingType> myRoamingTypeMap = new THashMap();

    public static ComponentRoamingManager getInstance() {
        return OUR_INSTANCE;
    }

    public RoamingType getRoamingType(@Nullable String name) {
        return name == null ? RoamingType.PER_USER : (RoamingType)ObjectUtils.notNull((Object)this.myRoamingTypeMap.get(name), (Object)RoamingType.PER_USER);
    }

    public void setRoamingType(@NotNull String name, @NotNull RoamingType roamingType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/components/impl/stores/ComponentRoamingManager", "setRoamingType"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/ComponentRoamingManager", "setRoamingType"));
        }
        if (roamingType != RoamingType.PER_USER) {
            this.myRoamingTypeMap.put(name, roamingType);
        }
    }
}

