/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.annotation.Annotation;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultStateSerializer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DefaultStateSerializer");

    private DefaultStateSerializer() {
    }

    @Nullable
    static Element serializeState(@NotNull Object state, final @Nullable Storage storage) throws WriteExternalException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DefaultStateSerializer", "serializeState"));
        }
        if (state instanceof Element) {
            return (Element)state;
        }
        if (state instanceof JDOMExternalizable) {
            Element element = new Element("temp_element");
            ((JDOMExternalizable)state).writeExternal(element);
            return element;
        }
        return XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters(){

            public boolean accepts(Accessor accessor, Object bean) {
                if (!super.accepts(accessor, bean)) {
                    return false;
                }
                if (storage != null) {
                    for (Annotation annotation : accessor.getAnnotations()) {
                        if (!StorageId.class.isAssignableFrom(annotation.annotationType()) || ((StorageId)annotation).value().equals(storage.id())) continue;
                        return false;
                    }
                    return storage.isDefault();
                }
                return true;
            }
        });
    }

    @Nullable
    static <T> T deserializeState(@Nullable Element stateElement, Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        if (stateElement == null) {
            return mergeInto;
        }
        if (stateClass.equals(Element.class)) {
            return (T)stateElement;
        }
        if (JDOMExternalizable.class.isAssignableFrom(stateClass)) {
            if (mergeInto != null) {
                String elementText = JDOMUtil.writeElement((Element)stateElement, (String)"\n");
                LOG.error("State is " + stateClass.getName() + ", merge into is " + mergeInto.toString() + ", state element text is " + elementText);
            }
            Object t = ReflectionUtil.newInstance(stateClass, (Class[])new Class[0]);
            try {
                ((JDOMExternalizable)t).readExternal(stateElement);
                return (T)t;
            }
            catch (InvalidDataException e) {
                throw new StateStorageException((Throwable)e);
            }
        }
        if (mergeInto == null) {
            return (T)XmlSerializer.deserialize((Element)stateElement, stateClass);
        }
        XmlSerializer.deserializeInto(mergeInto, (Element)stateElement);
        return mergeInto;
    }
}

