/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Producer;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class PasteFromX11Action
extends EditorAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actions.PasteFromX11Action");

    public PasteFromX11Action() {
        super((EditorActionHandler)new Handler());
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null || !SystemInfo.isXWindow) {
            presentation.setEnabled(false);
        } else {
            boolean rightPlace = true;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                rightPlace = false;
                MouseEvent me = (MouseEvent)inputEvent;
                if (editor.getMouseEventArea(me) == EditorMouseEventArea.EDITING_AREA) {
                    Component component = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
                    rightPlace = !(component instanceof JScrollBar);
                }
            }
            presentation.setEnabled(rightPlace);
        }
    }

    public static class Handler
    extends EditorWriteActionHandler {
        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Transferable content;
            Clipboard clip = editor.getComponent().getToolkit().getSystemSelection();
            if (clip == null) {
                return;
            }
            try {
                content = clip.getContents(null);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return;
            }
            if (content == null) {
                return;
            }
            TextRange range = EditorModificationUtil.pasteTransferable((Editor)editor, (Producer)new Producer<Transferable>(){

                @Nullable
                public Transferable produce() {
                    return content;
                }
            });
            editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)range);
        }
    }
}

