/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RequestsMerger;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestModifier;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.Consumer;

public class FileWatchRequestsManager {
    private final RequestsMerger myMerger;
    private final Project myProject;

    public FileWatchRequestsManager(Project project, NewMappings newMappings, LocalFileSystem localFileSystem) {
        this.myProject = project;
        this.myMerger = new RequestsMerger((Runnable)new FileWatchRequestModifier(project, newMappings, localFileSystem), (Consumer)new Consumer<Runnable>(){

            public void consume(Runnable runnable) {
                if (!FileWatchRequestsManager.this.myProject.isInitialized() || FileWatchRequestsManager.this.myProject.isDisposed()) {
                    return;
                }
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    runnable.run();
                } else {
                    application.executeOnPooledThread(runnable);
                }
            }
        });
    }

    public void ping() {
        this.myMerger.request();
    }
}

