/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.newProjectWizard.modes.ImportImlMode;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateModuleBuilder
extends ModuleBuilder {
    private final ModuleType myType;
    private List<WizardInputField> myAdditionalFields;
    private ArchivedProjectTemplate myTemplate;
    private boolean myProjectMode;
    private static final Logger LOG = Logger.getInstance(TemplateModuleBuilder.class);

    public TemplateModuleBuilder(ArchivedProjectTemplate template, ModuleType moduleType, List<WizardInputField> additionalFields) {
        this.myTemplate = template;
        this.myType = moduleType;
        this.myAdditionalFields = additionalFields;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/platform/templates/TemplateModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/platform/templates/TemplateModuleBuilder", "createWizardSteps"));
        }
        ModuleBuilder builder = this.myType.createModuleBuilder();
        return builder.createWizardSteps(wizardContext, modulesProvider);
    }

    protected List<WizardInputField> getAdditionalFields() {
        return this.myAdditionalFields;
    }

    public Module commitModule(final @NotNull Project project, ModifiableModuleModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/TemplateModuleBuilder", "commitModule"));
        }
        if (this.myProjectMode) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 0) {
                final Module module = modules[0];
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TemplateModuleBuilder.this.setupModule(module);
                        }
                        catch (ConfigurationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
                StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                                    modifiableModuleModel.renameModule(module, module.getProject().getName());
                                    modifiableModuleModel.commit();
                                    TemplateModuleBuilder.this.fixModuleName(module);
                                }
                                catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                });
                return module;
            }
            return null;
        }
        return super.commitModule(project, model);
    }

    @Nullable
    public String getBuilderId() {
        return this.myTemplate.getName();
    }

    public ModuleType getModuleType() {
        return this.myType;
    }

    public Icon getNodeIcon() {
        return this.myTemplate.getIcon();
    }

    public boolean isTemplateBased() {
        return true;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/platform/templates/TemplateModuleBuilder", "createModule"));
        }
        String path = this.getContentEntryPath();
        ExistingModuleLoader loader = ImportImlMode.setUpLoader(this.getModuleFilePath());
        this.unzip(loader.getName(), path, true);
        Module module = loader.createModule(moduleModel);
        if (this.myProjectMode) {
            moduleModel.renameModule(module, module.getProject().getName());
        }
        this.fixModuleName(module);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/TemplateModuleBuilder", "createModule"));
        }
        return module2;
    }

    private void fixModuleName(Module module) {
        List configurations = RunManager.getInstance((Project)module.getProject()).getAllConfigurationsList();
        for (RunConfiguration configuration : configurations) {
            if (!(configuration instanceof ModuleBasedConfiguration)) continue;
            ((ModuleBasedConfiguration)configuration).getConfigurationModule().setModule(module);
        }
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (WizardInputField field : this.myAdditionalFields) {
            ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById((String)field.getId());
            factory.applyResult(field.getValue(), model);
        }
        model.commit();
    }

    private WizardInputField getBasePackageField() {
        for (WizardInputField field : this.getAdditionalFields()) {
            if (!"IJ_BASE_PACKAGE".equals(field.getId())) continue;
            return field;
        }
        return null;
    }

    private void unzip(final @Nullable String projectName, String path, final boolean moduleMode) {
        File dir = new File(path);
        ZipInputStream zipInputStream = null;
        final WizardInputField basePackage = this.getBasePackageField();
        try {
            File to;
            File from;
            zipInputStream = this.myTemplate.getStream();
            NullableFunction<String, String> pathConvertor = new NullableFunction<String, String>(){

                @Nullable
                public String fun(String path) {
                    if (moduleMode && path.contains(".idea")) {
                        return null;
                    }
                    if (basePackage != null) {
                        return path.replace(TemplateModuleBuilder.getPathFragment(basePackage.getDefaultValue()), TemplateModuleBuilder.getPathFragment(basePackage.getValue()));
                    }
                    return path;
                }
            };
            ZipUtil.unzip(ProgressManager.getInstance().getProgressIndicator(), dir, zipInputStream, pathConvertor, new ZipUtil.ContentProcessor(){

                @Override
                public byte[] processContent(byte[] content, File file) throws IOException {
                    FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)file.getName()));
                    return fileType.isBinary() ? content : TemplateModuleBuilder.this.processTemplates(projectName, new String(content, CharsetToolkit.UTF8_CHARSET), file);
                }
            }, true);
            String iml = (String)ContainerUtil.find((Object[])dir.list(), (Condition)new Condition<String>(){

                public boolean value(String s) {
                    return s.endsWith(".iml");
                }
            });
            if (moduleMode && !(from = new File(path, iml)).renameTo(to = new File(this.getModuleFilePath()))) {
                throw new IOException("Can't rename " + from + " to " + to);
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            if (virtualFile == null) {
                throw new IOException("Can't find " + dir);
            }
            RefreshQueue.getInstance().refresh(false, true, null, new VirtualFile[]{virtualFile});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            StreamUtil.closeStream((Closeable)zipInputStream);
        }
    }

    private static String getPathFragment(String value) {
        return "/" + value.replace('.', '/') + "/";
    }

    @Nullable
    private byte[] processTemplates(@Nullable String projectName, String content, File file) throws IOException {
        for (WizardInputField field : this.myAdditionalFields) {
            if (field.acceptFile(file)) continue;
            return null;
        }
        Properties properties = FileTemplateManager.getInstance().getDefaultProperties();
        for (WizardInputField field : this.myAdditionalFields) {
            properties.putAll((Map<?, ?>)field.getValues());
        }
        if (projectName != null) {
            properties.put("IJ_PROJECT_NAME", projectName);
        }
        String merged = FileTemplateUtil.mergeTemplate(properties, content, true);
        return StringUtilRt.convertLineSeparators((String)merged.replace("\\$", "$").replace("\\#", "#"), (String)(SystemInfo.isWindows ? "\r\n" : "\n")).getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @Nullable
    public Project createProject(String name, final String path) {
        this.myProjectMode = true;
        this.unzip(name, path, false);
        return (Project)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<Project>(){

            @Nullable
            public Project compute() {
                try {
                    return ProjectManagerEx.getInstanceEx().convertAndLoadProject(path);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        });
    }
}

