/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.psi.codeStyle.autodetect.IndentUsageInfo;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatistics;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentUsageStatisticsImpl
implements IndentUsageStatistics {
    private static final Comparator<IndentUsageInfo> DECREASING_ORDER = new Comparator<IndentUsageInfo>(){

        @Override
        public int compare(@NotNull IndentUsageInfo o1, @NotNull IndentUsageInfo o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl$1", "compare"));
            }
            return o1.getTimesUsed() < o2.getTimesUsed() ? 1 : (o1.getTimesUsed() == o2.getTimesUsed() ? 0 : -1);
        }
    };
    private List<LineIndentInfo> myLineInfos;
    private int myPreviousLineIndent;
    private int myPreviousRelativeIndent;
    private int myTotalLinesWithTabs;
    private int myTotalLinesWithWhiteSpaces;
    private TIntIntHashMap myIndentToUsagesMap;
    private List<IndentUsageInfo> myIndentUsages;
    private Stack<IndentData> myParentIndents;

    public IndentUsageStatisticsImpl(@NotNull List<LineIndentInfo> lineInfos) {
        if (lineInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineInfos", "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl", "<init>"));
        }
        this.myTotalLinesWithTabs = 0;
        this.myTotalLinesWithWhiteSpaces = 0;
        this.myIndentToUsagesMap = new TIntIntHashMap();
        this.myIndentUsages = ContainerUtil.newArrayList();
        this.myParentIndents = ContainerUtil.newStack((Object[])new IndentData[]{new IndentData(0, 0)});
        this.myLineInfos = lineInfos;
        this.buildIndentToUsagesMap();
        this.myIndentUsages = IndentUsageStatisticsImpl.toIndentUsageList(this.myIndentToUsagesMap);
        ContainerUtil.sort(this.myIndentUsages, DECREASING_ORDER);
    }

    @NotNull
    private static List<IndentUsageInfo> toIndentUsageList(@NotNull TIntIntHashMap indentToUsages) {
        if (indentToUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentToUsages", "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl", "toIndentUsageList"));
        }
        ArrayList indentUsageInfos = ContainerUtil.newArrayList();
        TIntIntIterator it = indentToUsages.iterator();
        while (it.hasNext()) {
            it.advance();
            indentUsageInfos.add(new IndentUsageInfo(it.key(), it.value()));
        }
        ArrayList arrayList = indentUsageInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl", "toIndentUsageList"));
        }
        return arrayList;
    }

    public void buildIndentToUsagesMap() {
        this.myPreviousLineIndent = 0;
        this.myPreviousRelativeIndent = 0;
        for (LineIndentInfo lineInfo : this.myLineInfos) {
            if (lineInfo.isLineWithTabs()) {
                ++this.myTotalLinesWithTabs;
                continue;
            }
            if (!lineInfo.isLineWithWhiteSpaceIndent()) continue;
            this.handleWhiteSpaceIndent(lineInfo.getIndentSize());
        }
    }

    @NotNull
    private IndentData findParentIndent(int indent) {
        while (this.myParentIndents.size() != 1 && ((IndentData)this.myParentIndents.peek()).indent > indent) {
            this.myParentIndents.pop();
        }
        IndentData indentData = (IndentData)this.myParentIndents.peek();
        if (indentData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/IndentUsageStatisticsImpl", "findParentIndent"));
        }
        return indentData;
    }

    private void handleWhiteSpaceIndent(int currentIndent) {
        int relativeIndent = currentIndent - this.myPreviousLineIndent;
        if (relativeIndent < 0) {
            IndentData indentData = this.findParentIndent(currentIndent);
            this.myPreviousLineIndent = indentData.indent;
            this.myPreviousRelativeIndent = indentData.relativeIndent;
            relativeIndent = currentIndent - this.myPreviousLineIndent;
        }
        if (relativeIndent == 0) {
            relativeIndent = this.myPreviousRelativeIndent;
        } else {
            this.myParentIndents.push((Object)new IndentData(currentIndent, relativeIndent));
        }
        this.increaseIndentUsage(relativeIndent);
        this.myPreviousRelativeIndent = relativeIndent;
        this.myPreviousLineIndent = currentIndent;
        if (currentIndent > 0) {
            ++this.myTotalLinesWithWhiteSpaces;
        }
    }

    private void increaseIndentUsage(int relativeIndent) {
        int timesUsed = this.myIndentToUsagesMap.get(relativeIndent);
        this.myIndentToUsagesMap.put(relativeIndent, ++timesUsed);
    }

    public int getTotalLinesWithLeadingTabs() {
        return this.myTotalLinesWithTabs;
    }

    public int getTotalLinesWithLeadingSpaces() {
        return this.myTotalLinesWithWhiteSpaces;
    }

    public IndentUsageInfo getKMostUsedIndentInfo(int k) {
        return this.myIndentUsages.get(k);
    }

    public int getTimesIndentUsed(int indent) {
        return this.myIndentToUsagesMap.get(indent);
    }

    public int getTotalIndentSizesDetected() {
        return this.myIndentToUsagesMap.size();
    }

    private static class IndentData {
        public final int indent;
        public final int relativeIndent;

        public IndentData(int indent, int relativeIndent) {
            this.indent = indent;
            this.relativeIndent = relativeIndent;
        }
    }
}

