/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyImportUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyImportOptimizer
implements ImportOptimizer {
    public static Comparator<GrImportStatement> getComparator(final GroovyCodeStyleSettings settings) {
        return new Comparator<GrImportStatement>(){

            @Override
            public int compare(GrImportStatement statement1, GrImportStatement statement2) {
                String name2;
                if (settings.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
                    if (statement1.isStatic() && !statement2.isStatic()) {
                        return 1;
                    }
                    if (statement2.isStatic() && !statement1.isStatic()) {
                        return -1;
                    }
                }
                GrCodeReferenceElement ref1 = statement1.getImportReference();
                GrCodeReferenceElement ref2 = statement2.getImportReference();
                String name1 = ref1 != null ? PsiUtil.getQualifiedReferenceText(ref1) : null;
                String string = name2 = ref2 != null ? PsiUtil.getQualifiedReferenceText(ref2) : null;
                if (name1 == null) {
                    return name2 == null ? 0 : -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        };
    }

    @NotNull
    public Runnable processFile(PsiFile file) {
        MyProcessor myProcessor = new MyProcessor(file, false);
        if (myProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/editor/GroovyImportOptimizer", "processFile"));
        }
        return myProcessor;
    }

    public boolean supports(PsiFile file) {
        return file instanceof GroovyFile;
    }

    private class MyProcessor
    implements Runnable {
        private final PsiFile myFile;
        private final boolean myRemoveUnusedOnly;

        private MyProcessor(PsiFile file, boolean removeUnusedOnly) {
            this.myFile = file;
            this.myRemoveUnusedOnly = removeUnusedOnly;
        }

        @Override
        public void run() {
            if (!(this.myFile instanceof GroovyFile)) {
                return;
            }
            GroovyFile file = (GroovyFile)this.myFile;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = documentManager.getDocument((PsiFile)file);
            if (document != null) {
                documentManager.commitDocument(document);
            }
            LinkedHashSet<String> simplyImportedClasses = new LinkedHashSet<String>();
            LinkedHashSet<String> staticallyImportedMembers = new LinkedHashSet<String>();
            HashSet usedImports = new HashSet();
            HashSet unresolvedOnDemandImports = new HashSet();
            LinkedHashSet<String> implicitlyImportedClasses = new LinkedHashSet<String>();
            HashSet innerClasses = new HashSet();
            HashMap aliasImported = ContainerUtil.newHashMap();
            HashMap annotatedImports = ContainerUtil.newHashMap();
            GroovyImportUtil.processFile(this.myFile, simplyImportedClasses, staticallyImportedMembers, (Set<GrImportStatement>)usedImports, (Set<GrImportStatement>)unresolvedOnDemandImports, implicitlyImportedClasses, (Set<String>)innerClasses, aliasImported, annotatedImports);
            List<GrImportStatement> oldImports = PsiUtil.getValidImportStatements(file);
            if (this.myRemoveUnusedOnly) {
                for (GrImportStatement oldImport : oldImports) {
                    if (usedImports.contains(oldImport)) continue;
                    file.removeImport(oldImport);
                }
                return;
            }
            GrImportStatement[] newImports = this.prepare((Set<GrImportStatement>)usedImports, simplyImportedClasses, staticallyImportedMembers, implicitlyImportedClasses, (Set<String>)innerClasses, aliasImported, annotatedImports, (Set<GrImportStatement>)unresolvedOnDemandImports);
            if (oldImports.isEmpty() && newImports.length == 0 && aliasImported.isEmpty()) {
                return;
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(file.getProject());
            GroovyFile tempFile = factory.createGroovyFile("", false, null);
            for (GrImportStatement newImport : newImports) {
                tempFile.addImport(newImport);
            }
            if (!oldImports.isEmpty()) {
                String oldText;
                int startOffset = oldImports.get(0).getTextRange().getStartOffset();
                int endOffset = oldImports.get(oldImports.size() - 1).getTextRange().getEndOffset();
                String string = oldText = oldImports.isEmpty() ? "" : this.myFile.getText().substring(startOffset, endOffset);
                if (tempFile.getText().trim().equals(oldText)) {
                    return;
                }
            }
            for (GrImportStatement statement : tempFile.getImportStatements()) {
                file.addImport(statement);
            }
            for (GrImportStatement importStatement : oldImports) {
                file.removeImport(importStatement);
            }
        }

        private GrImportStatement[] prepare(Set<GrImportStatement> usedImports, Set<String> importedClasses, Set<String> staticallyImportedMembers, Set<String> implicitlyImported, Set<String> innerClasses, Map<String, String> aliased, final Map<String, String> annotations, Set<GrImportStatement> unresolvedOnDemandImports) {
            Project project = this.myFile.getProject();
            final GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(GroovyCodeStyleSettings.class);
            final GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            TObjectIntHashMap packageCountMap = new TObjectIntHashMap();
            TObjectIntHashMap classCountMap = new TObjectIntHashMap();
            for (String importedClass : importedClasses) {
                if (implicitlyImported.contains(importedClass) || innerClasses.contains(importedClass) || aliased.containsKey(importedClass) || annotations.containsKey(importedClass)) continue;
                String packageName = StringUtil.getPackageName((String)importedClass);
                if (!packageCountMap.containsKey((Object)packageName)) {
                    packageCountMap.put((Object)packageName, 0);
                }
                packageCountMap.increment((Object)packageName);
            }
            for (String importedMember : staticallyImportedMembers) {
                if (aliased.containsKey(importedMember) || annotations.containsKey(importedMember)) continue;
                String className = StringUtil.getPackageName((String)importedMember);
                if (!classCountMap.containsKey((Object)className)) {
                    classCountMap.put((Object)className, 0);
                }
                classCountMap.increment((Object)className);
            }
            HashSet onDemandImportedSimpleClassNames = new HashSet();
            final ArrayList<GrImportStatement> result = new ArrayList<GrImportStatement>();
            packageCountMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>((Set)onDemandImportedSimpleClassNames){
                final /* synthetic */ Set val$onDemandImportedSimpleClassNames;
                {
                    this.val$onDemandImportedSimpleClassNames = set;
                }

                public boolean execute(String s, int i) {
                    if (i >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND || settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(s)) {
                        GrImportStatement imp = factory.createImportStatementFromText(s, false, true, null);
                        String annos = (String)annotations.remove(s + ".*");
                        if (annos != null) {
                            imp.getAnnotationList().replace(factory.createModifierList(annos));
                        }
                        result.add(imp);
                        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)MyProcessor.this.myFile.getProject()).findPackage(s);
                        if (aPackage != null) {
                            for (PsiClass clazz : aPackage.getClasses(MyProcessor.this.myFile.getResolveScope())) {
                                this.val$onDemandImportedSimpleClassNames.add(clazz.getName());
                            }
                        }
                    }
                    return true;
                }
            });
            classCountMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                public boolean execute(String s, int i) {
                    if (i >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) {
                        GrImportStatement imp = factory.createImportStatementFromText(s, true, true, null);
                        String annos = (String)annotations.remove(s + ".*");
                        if (annos != null) {
                            imp.getAnnotationList().replace(factory.createModifierList(annos));
                        }
                        result.add(imp);
                    }
                    return true;
                }
            });
            ArrayList explicated = ContainerUtil.newArrayList();
            for (String importedClass : importedClasses) {
                String parentName = StringUtil.getPackageName((String)importedClass);
                if (!annotations.containsKey(importedClass) && !aliased.containsKey(importedClass) && (packageCountMap.get((Object)parentName) >= settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND || settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(parentName) || implicitlyImported.contains(importedClass) && !onDemandImportedSimpleClassNames.contains(StringUtil.getShortName((String)importedClass)))) continue;
                GrImportStatement imp = factory.createImportStatementFromText(importedClass, false, false, null);
                String annos = annotations.remove(importedClass);
                if (annos != null) {
                    imp.getAnnotationList().replace(factory.createModifierList(annos));
                }
                explicated.add(imp);
            }
            for (String importedMember : staticallyImportedMembers) {
                String className = StringUtil.getPackageName((String)importedMember);
                if (!annotations.containsKey(importedMember) && !aliased.containsKey(importedMember) && classCountMap.get((Object)className) >= settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) continue;
                result.add(factory.createImportStatementFromText(importedMember, true, false, null));
            }
            for (GrImportStatement anImport : usedImports) {
                if (!anImport.isAliasedImport() && !GroovyImportUtil.isAnnotatedImport(anImport)) continue;
                if (GroovyImportUtil.isAnnotatedImport(anImport)) {
                    annotations.remove(GroovyImportUtil.getImportReferenceText(anImport));
                }
                if (anImport.isStatic()) {
                    result.add(anImport);
                    continue;
                }
                explicated.add(anImport);
            }
            Comparator<GrImportStatement> comparator = GroovyImportOptimizer.getComparator(settings);
            Collections.sort(result, comparator);
            Collections.sort(explicated, comparator);
            explicated.addAll(result);
            if (!annotations.isEmpty()) {
                StringBuilder allSkippedAnnotations = new StringBuilder();
                for (String anno : annotations.values()) {
                    allSkippedAnnotations.append(anno).append(' ');
                }
                if (explicated.isEmpty()) {
                    explicated.add(factory.createImportStatementFromText("java.lang.Object", false, false, null));
                }
                GrImportStatement first = (GrImportStatement)explicated.get(0);
                allSkippedAnnotations.append(first.getAnnotationList().getText());
                first.getAnnotationList().replace(factory.createModifierList(allSkippedAnnotations));
            }
            for (GrImportStatement anImport : unresolvedOnDemandImports) {
                explicated.add(anImport);
            }
            return explicated.toArray(new GrImportStatement[explicated.size()]);
        }
    }
}

