/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.junit.Assert;

public class CompilerTestUtil {
    private CompilerTestUtil() {
    }

    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance(project);
        compilerConfiguration.projectOpened();
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    public static void scanSourceRootsToRecompile(Project project) {
        List<VirtualFile> roots = ProjectRootManager.getInstance(project).getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
    }

    public static void saveApplicationSettings() {
        CompilerTestUtil.saveApplicationComponent(ProjectJdkTable.getInstance());
        CompilerTestUtil.saveApplicationComponent(FileTypeManager.getInstance());
    }

    public static void saveApplicationComponent(Object appComponent) {
        try {
            File file;
            String componentName;
            State state = appComponent.getClass().getAnnotation(State.class);
            if (state != null) {
                componentName = state.name();
                Storage storageToWrite = CompilerTestUtil.findNonDeprecated(state.storages());
                StateStorageManager storageManager = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager();
                file = new File(storageManager.expandMacros(storageToWrite.file()));
            } else if (appComponent instanceof ExportableApplicationComponent && appComponent instanceof NamedJDOMExternalizable) {
                componentName = ((ExportableApplicationComponent)appComponent).getComponentName();
                file = PathManager.getOptionsFile((NamedJDOMExternalizable)((NamedJDOMExternalizable)appComponent));
            } else {
                throw new AssertionError((Object)(appComponent.getClass() + " doesn't have @State annotation and doesn't implement ExportableApplicationComponent"));
            }
            final Element root = new Element("application");
            Element element = JDomSerializationUtil.createComponentElement((String)componentName);
            if (appComponent instanceof JDOMExternalizable) {
                ((JDOMExternalizable)appComponent).writeExternal(element);
            } else {
                element.addContent((Collection)((Element)((PersistentStateComponent)appComponent).getState()).cloneContent());
            }
            root.addContent(element);
            Assert.assertTrue((String)("Cannot create " + file), (boolean)FileUtil.createIfDoesntExist((File)file));
            new WriteAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void run(@NotNull Result result) throws IOException {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/CompilerTestUtil$1", "run"));
                    }
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                    Assert.assertNotNull((String)file.getAbsolutePath(), (Object)virtualFile);
                    OutputStream stream = virtualFile.getOutputStream(new SaveSessionRequestor());
                    try {
                        JDOMUtil.writeParent((Parent)root, (OutputStream)stream, (String)SystemProperties.getLineSeparator());
                    }
                    finally {
                        stream.close();
                    }
                }
            }.execute().throwException();
        }
        catch (WriteExternalException e) {
            throw new RuntimeException(e);
        }
    }

    private static Storage findNonDeprecated(Storage[] storages) {
        for (Storage storage : storages) {
            if (storage.deprecated()) continue;
            return storage;
        }
        throw new AssertionFailedError("All storages are deprecated");
    }

    public static void enableExternalCompiler() {
        new WriteAction(){

            @Override
            protected void run(Result result) {
                ApplicationManagerEx.getApplicationEx().doNotSave(false);
                JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
                table.addJdk(table.getInternalJdk());
            }
        }.execute();
    }

    public static void disableExternalCompiler(final Project project) {
        new WriteAction(){

            @Override
            protected void run(Result result) {
                ApplicationManagerEx.getApplicationEx().doNotSave(true);
                Module[] modules = ModuleManager.getInstance(project).getModules();
                JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
                Sdk internalJdk = table.getInternalJdk();
                ArrayList<Module> modulesToRestore = new ArrayList<Module>();
                for (Module module : modules) {
                    Sdk sdk = ModuleRootManager.getInstance(module).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    modulesToRestore.add(module);
                }
                table.removeJdk(internalJdk);
                for (Module module : modulesToRestore) {
                    ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)internalJdk);
                }
                BuildManager.getInstance().clearState(project);
            }
        }.execute();
    }

    private static class SaveSessionRequestor
    implements StateStorage.SaveSession {
        private SaveSessionRequestor() {
        }

        @Override
        public void save() {
        }
    }
}

