/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        @NotNull
        public String[] create(int count) {
            String[] stringArray = ArrayUtil.newStringArray(count);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$1", "create"));
            }
            return stringArray;
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        @NotNull
        public Object[] create(int count) {
            Object[] objectArray = ArrayUtil.newObjectArray(count);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$2", "create"));
            }
            return objectArray;
        }
    };

    private ArrayUtil() {
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] realloc(@NotNull byte[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (newSize == 0) {
            if (EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return EMPTY_BYTE_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        byte[] result = new byte[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static boolean[] realloc(@NotNull boolean[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (newSize == 0) {
            if (EMPTY_BOOLEAN_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return EMPTY_BOOLEAN_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        boolean[] result = new boolean[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] realloc(@NotNull int[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (newSize == 0) {
            if (EMPTY_INT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] realloc(@NotNull T[] array, int newSize, @NotNull ArrayFactory<T> factory) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "realloc"));
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        T[] result = factory.create(newSize);
        if (newSize == 0) {
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return result;
        }
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] append(@NotNull int[] array, int value) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "append"));
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] insert(@NotNull int[] array, int index, int value) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "insert"));
        }
        int[] result = new int[array.length + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "insert"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] append(@NotNull byte[] array, byte value) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "append"));
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static boolean[] append(@NotNull boolean[] array, boolean value) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "append"));
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static char[] realloc(@NotNull char[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (newSize == 0) {
            if (EMPTY_CHAR_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return EMPTY_CHAR_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        char[] result = new char[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Collection<T> collection, @NotNull Class<T> aClass) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        Object[] array = (Object[])Array.newInstance(aClass, collection.size());
        Object[] objectArray = collection.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Class<T> aClass, Object ... source) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        Object[] array = (Object[])Array.newInstance(aClass, source.length);
        System.arraycopy(source, 0, array, 0, array.length);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] toObjectArray(@NotNull Collection<?> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        if (collection.isEmpty()) {
            if (EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
            }
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = collection.toArray(new Object[collection.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] toIntArray(@NotNull Collection<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/ArrayUtil", "toIntArray"));
        }
        int[] ret = ArrayUtil.newIntArray(list.size());
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        if (ret == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toIntArray"));
        }
        return ret;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2) {
        Class<?> class2;
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a1.length == 0) {
            if (a2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a1;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        Object[] result = (Object[])Array.newInstance(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        T[] res = factory.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res[i++] = t;
        }
        for (T t : c2) {
            res[i++] = t;
        }
        if (res == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2, @NotNull ArrayFactory<T> factory) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a1.length == 0) {
            if (a2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a1;
        }
        T[] result = factory.create(a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] mergeArrays(@NotNull String[] a1, String ... a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        String[] stringArray = ArrayUtil.mergeArrays(a1, a2, STRING_ARRAY_FACTORY);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] mergeArrays(@NotNull int[] a1, @NotNull int[] a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a1.length == 0) {
            if (a2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a1;
        }
        int[] result = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] mergeArrays(@NotNull byte[] a1, @NotNull byte[] a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a1.length == 0) {
            if (a2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a1;
        }
        byte[] result = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrayAndCollection(@NotNull T[] array, @NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory) {
        T[] array2;
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        if (collection.isEmpty()) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
            }
            return array;
        }
        try {
            array2 = collection.toArray(factory.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            if (array2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
            }
            return array2;
        }
        T[] result = factory.create(array.length + collection.size());
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(array2, 0, result, array.length, array2.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        T[] TArray = ArrayUtil.prepend(element, array, array.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array, @NotNull Class<T> type) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/ArrayUtil", "prepend"));
        }
        int length = array.length;
        Object[] result = (Object[])Array.newInstance(type, length + 1);
        System.arraycopy(array, 0, result, 1, length);
        result[0] = element;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static byte[] prepend(byte element, @NotNull byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        int length = array.length;
        byte[] result = new byte[length + 1];
        result[0] = element;
        System.arraycopy(array, 0, result, 1, length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "append"));
        }
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/util/ArrayUtil", "append"));
        }
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result = factory.create(length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, T element) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            if (src == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
            }
            return src;
        }
        int[] nArray = ArrayUtil.remove(src, idx);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "remove"));
        }
        int idx = ArrayUtil.find(src, element);
        if (idx == -1) {
            if (src == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
            }
            return src;
        }
        int[] nArray = ArrayUtil.remove(src, idx, factory);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static short[] remove(@NotNull short[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        short[] result = src.length == 1 ? EMPTY_SHORT_ARRAY : new short[src.length - 1];
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull T[] src, T obj) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "lastIndexOf"));
        }
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int find(@NotNull int[] src, int obj) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "find"));
        }
        return ArrayUtil.indexOf(src, obj);
    }

    @Contract(pure=true)
    public static <T> int find(@NotNull T[] src, T obj) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "find"));
        }
        return ArrayUtilRt.find(src, obj);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull byte[] array, @NotNull byte[] prefix) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <E> boolean startsWith(@NotNull E[] array, @NotNull E[] subArray) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (subArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subArray", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (array == subArray) {
            return true;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Comparing.equal(array[i], subArray[i])) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull byte[] array, int start, @NotNull byte[] subArray) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (subArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subArray", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        int length = subArray.length;
        if (array.length - start < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[start + i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean equals(@NotNull T[] a1, @NotNull T[] a2, @NotNull Equality<? super T> comparator) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "equals"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "equals"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "equals"));
        }
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean equals(@NotNull T[] a1, @NotNull T[] a2, @NotNull Comparator<? super T> comparator) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "equals"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "equals"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "equals"));
        }
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.compare(a1[i], a2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] reverseArray(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "reverseArray"));
        }
        Object[] newArray = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "reverseArray"));
        }
        return newArray;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] reverseArray(@NotNull int[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "reverseArray"));
        }
        int[] newArray = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "reverseArray"));
        }
        return newArray;
    }

    public static void reverse(@NotNull char[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "reverse"));
        }
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.swap(array, array.length - i - 1, i);
        }
    }

    @Contract(pure=true)
    public static int lexicographicCompare(@NotNull String[] obj1, @NotNull String[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj1", "com/intellij/util/ArrayUtil", "lexicographicCompare"));
        }
        if (obj2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj2", "com/intellij/util/ArrayUtil", "lexicographicCompare"));
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            String o2;
            String o1 = i < obj1.length ? obj1[i] : null;
            String string = o2 = i < obj2.length ? obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = o1.compareToIgnoreCase(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Contract(pure=true)
    public static <T> int lexicographicCompare(@NotNull T[] obj1, @NotNull T[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj1", "com/intellij/util/ArrayUtil", "lexicographicCompare"));
        }
        if (obj2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj2", "com/intellij/util/ArrayUtil", "lexicographicCompare"));
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            Object o2;
            Object o1 = i < obj1.length ? obj1[i] : null;
            Object t = o2 = i < obj2.length ? (Object)obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = ((Comparable)o1).compareTo(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> void swap(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "swap"));
        }
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull int[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "swap"));
        }
        int t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull boolean[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "swap"));
        }
        boolean t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(@NotNull char[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "swap"));
        }
        char t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static <T> void rotateLeft(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "rotateLeft"));
        }
        T t = array[i1];
        System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
        array[i2] = t;
    }

    public static <T> void rotateRight(@NotNull T[] array, int i1, int i2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "rotateRight"));
        }
        T t = array[i2];
        System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
        array[i1] = t;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, @Nullable Object object) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        return ArrayUtil.indexOf(objects, object, 0, objects.length);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, Object object, int start, int end) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        if (object == null) {
            for (int i = start; i < end; ++i) {
                if (objects[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!object.equals(objects[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Comparator<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (comparator.compare(objects.get(i), object) != 0) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull T[] objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!comparator.equals(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull short[] ints, short value) {
        if (ints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable Object o, Object ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "contains"));
        }
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable String s, String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/util/ArrayUtil", "contains"));
        }
        if (s == null) {
            for (String str : strings) {
                if (str != null) continue;
                return true;
            }
        } else {
            for (String str : strings) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] newIntArray(int count) {
        int[] nArray = count == 0 ? EMPTY_INT_ARRAY : new int[count];
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newIntArray"));
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static long[] newLongArray(int count) {
        long[] lArray = count == 0 ? EMPTY_LONG_ARRAY : new long[count];
        if (lArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newLongArray"));
        }
        return lArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] newStringArray(int count) {
        String[] stringArray = count == 0 ? EMPTY_STRING_ARRAY : new String[count];
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newStringArray"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] newObjectArray(int count) {
        Object[] objectArray = count == 0 ? EMPTY_OBJECT_ARRAY : new Object[count];
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> E[] ensureExactSize(int count, @NotNull E[] sample) {
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/intellij/util/ArrayUtil", "ensureExactSize"));
        }
        if (count == sample.length) {
            if (sample == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "ensureExactSize"));
            }
            return sample;
        }
        Object[] array = (Object[])Array.newInstance(sample.getClass().getComponentType(), count);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "ensureExactSize"));
        }
        return array;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstElement(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "getFirstElement"));
        }
        return array.length > 0 ? (T)array[0] : null;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getLastElement(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "getLastElement"));
        }
        return array.length > 0 ? (T)array[array.length - 1] : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toStringArray"));
        }
        return stringArray;
    }

    public static <T> void copy(@NotNull Collection<? extends T> src, @NotNull T[] dst, int dstOffset) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "copy"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/util/ArrayUtil", "copy"));
        }
        int i = dstOffset;
        for (T t : src) {
            dst[i++] = t;
        }
    }
}

