/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Git {
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<GitLineHandler> var1);

    @NotNull
    public GitCommandResult init(@NotNull Project var1, @NotNull VirtualFile var2, GitLineHandlerListener ... var3);

    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable Collection<VirtualFile> var3) throws VcsException;

    @NotNull
    public Collection<VirtualFile> untrackedFilesNoChunk(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable List<String> var3) throws VcsException;

    @NotNull
    public GitCommandResult clone(@NotNull Project var1, @NotNull File var2, @NotNull String var3, @NotNull String var4, GitLineHandlerListener ... var5);

    @NotNull
    public GitCommandResult config(@NotNull GitRepository var1, String ... var2);

    @NotNull
    public GitCommandResult diff(@NotNull GitRepository var1, @NotNull List<String> var2, @NotNull String var3);

    @NotNull
    public GitCommandResult merge(@NotNull GitRepository var1, @NotNull String var2, @Nullable List<String> var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository var1, @NotNull String var2, @Nullable String var3, boolean var4, GitLineHandlerListener ... var5);

    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository var1, @NotNull String var2, @Nullable GitLineHandlerListener var3);

    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository var1, @NotNull String var2, @Nullable GitLineHandlerListener var3, @NotNull String var4);

    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository var1, @NotNull String var2, boolean var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult branchContains(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult reset(@NotNull GitRepository var1, @NotNull GitResetMode var2, @NotNull String var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository var1, @Nullable String var2);

    @NotNull
    public GitCommandResult tip(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult push(@NotNull GitRepository var1, @NotNull String var2, @Nullable String var3, @NotNull String var4, boolean var5, GitLineHandlerListener ... var6);

    @NotNull
    public GitCommandResult push(@NotNull GitRepository var1, @NotNull String var2, @Nullable String var3, @NotNull String var4, GitLineHandlerListener ... var5);

    @NotNull
    public GitCommandResult push(@NotNull GitRepository var1, @NotNull GitLocalBranch var2, @NotNull GitRemoteBranch var3, boolean var4, boolean var5, @Nullable String var6, GitLineHandlerListener ... var7);

    @NotNull
    public GitCommandResult show(@NotNull GitRepository var1, String ... var2);

    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository var1, @NotNull String var2, boolean var3, GitLineHandlerListener ... var4);

    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository var1);

    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository var1, @NotNull Collection<String> var2, @NotNull Collection<VirtualFile> var3);

    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository var1, GitLineHandlerListener ... var2);

    @NotNull
    public List<GitCommit> history(@NotNull GitRepository var1, @NotNull String var2);

    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository var1, @NotNull String var2, @NotNull String var3, @NotNull List<GitLineHandlerListener> var4, String ... var5);
}

