/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtilEx {
    private static final PsiConstantEvaluationHelperImpl CONSTANT_EVALUATION_HELPER = new PsiConstantEvaluationHelperImpl();

    private AnnotationUtilEx() {
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatedElementFor(@Nullable PsiElement element, LookupType type) {
        while (element != null) {
            PsiElement e;
            if ((type == LookupType.PREFER_DECLARATION || type == LookupType.DECLARATION_ONLY) && element instanceof PsiReferenceExpression) {
                PsiElement e2 = ((PsiReferenceExpression)element).resolve();
                if (e2 instanceof PsiModifierListOwner) {
                    return (PsiModifierListOwner)e2;
                }
                if (type == LookupType.DECLARATION_ONLY) {
                    return null;
                }
            }
            element = ContextComputationProcessor.getTopLevelInjectionTarget(element);
            PsiElement parent = element.getParent();
            if (element instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getOperationTokenType() == JavaTokenType.PLUSEQ) {
                element = ((PsiAssignmentExpression)element).getLExpression();
                continue;
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression p = (PsiAssignmentExpression)parent;
                if (p.getRExpression() == element) {
                    element = p.getLExpression();
                    continue;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod m = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                if (m != null) {
                    return m;
                }
            } else {
                if (parent instanceof PsiModifierListOwner) {
                    return (PsiModifierListOwner)parent;
                }
                if (parent instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue value = (PsiArrayInitializerMemberValue)parent;
                    PsiElement pair = value.getParent();
                    if (pair instanceof PsiNameValuePair) {
                        return AnnotationUtil.getAnnotationMethod((PsiNameValuePair)((PsiNameValuePair)pair));
                    }
                } else {
                    if (parent instanceof PsiNameValuePair) {
                        return AnnotationUtil.getAnnotationMethod((PsiNameValuePair)((PsiNameValuePair)parent));
                    }
                    return PsiUtilEx.getParameterForArgument(element);
                }
            }
            if (type != LookupType.DECLARATION_ONLY && element instanceof PsiReferenceExpression && (e = ((PsiReferenceExpression)element).resolve()) instanceof PsiModifierListOwner) {
                return (PsiModifierListOwner)e;
            }
            return null;
        }
        return null;
    }

    public static void visitAnnotatedElements(@Nullable PsiElement element, AnnotatedElementVisitor visitor) {
        if (element == null) {
            return;
        }
        for (PsiElement cur = ContextComputationProcessor.getTopLevelInjectionTarget(element); cur != null; cur = cur.getParent()) {
            if (AnnotationUtilEx.visitAnnotatedElementInner(cur, visitor)) continue;
            return;
        }
    }

    private static boolean visitAnnotatedElementInner(PsiElement element, AnnotatedElementVisitor visitor) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiReferenceExpression) {
            if (!visitor.visitReference((PsiReferenceExpression)element)) {
                return false;
            }
        } else if (element instanceof PsiNameValuePair && parent != null && parent.getParent() instanceof PsiAnnotation) {
            return visitor.visitAnnotationParameter((PsiNameValuePair)element, (PsiAnnotation)parent.getParent());
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression left;
            PsiAssignmentExpression p = (PsiAssignmentExpression)parent;
            if ((p.getRExpression() == element || p.getOperationTokenType() == JavaTokenType.PLUSEQ) && (left = p.getLExpression()) instanceof PsiReferenceExpression && !visitor.visitReference((PsiReferenceExpression)left)) {
                return false;
            }
        } else {
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == element) {
                return false;
            }
            if (parent instanceof PsiReturnStatement) {
                PsiMethod m = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                if (m != null && !visitor.visitMethodReturnStatement((PsiReturnStatement)parent, m)) {
                    return false;
                }
            } else {
                if (parent instanceof PsiVariable) {
                    return visitor.visitVariable((PsiVariable)parent);
                }
                if (parent instanceof PsiModifierListOwner) {
                    return false;
                }
                if (parent instanceof PsiArrayInitializerMemberValue || parent instanceof PsiNameValuePair) {
                    return true;
                }
                if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression) {
                    return visitor.visitMethodParameter((PsiExpression)element, (PsiCallExpression)parent.getParent());
                }
            }
        }
        return true;
    }

    @NotNull
    public static PsiAnnotation[] getAnnotationFrom(PsiModifierListOwner owner, Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect, boolean inHierarchy) {
        if (!PsiUtilEx.isLanguageAnnotationTarget(owner)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/util/AnnotationUtilEx", "getAnnotationFrom"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtilEx.getAnnotationsFromImpl(owner, annotationName, allowIndirect, inHierarchy);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/util/AnnotationUtilEx", "getAnnotationFrom"));
        }
        return psiAnnotationArray;
    }

    public static PsiAnnotation[] getAnnotationsFromImpl(PsiModifierListOwner owner, Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect, boolean inHierarchy) {
        PsiAnnotation directAnnotation;
        PsiAnnotation psiAnnotation = directAnnotation = inHierarchy ? AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner, (Set)((Set)annotationName.second)) : AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Set)((Set)annotationName.second));
        if (directAnnotation != null) {
            return new PsiAnnotation[]{directAnnotation};
        }
        if (allowIndirect) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = AnnotationUtilEx.getAnnotations(owner, inHierarchy)) {
                PsiAnnotation psiAnnotation2;
                PsiElement resolved;
                PsiJavaCodeReferenceElement nameReference = annotation.getNameReferenceElement();
                if (nameReference == null || !((resolved = nameReference.resolve()) instanceof PsiClass) || (psiAnnotation2 = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)resolved), (Set)((Set)annotationName.second))) == null) continue;
                return new PsiAnnotation[]{psiAnnotation2, annotation};
            }
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public static PsiAnnotation[] getAnnotationFrom(@NotNull PsiModifierListOwner owner, @NotNull Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/intellij/plugins/intelliLang/util/AnnotationUtilEx", "getAnnotationFrom"));
        }
        if (annotationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationName", "org/intellij/plugins/intelliLang/util/AnnotationUtilEx", "getAnnotationFrom"));
        }
        return AnnotationUtilEx.getAnnotationFrom(owner, annotationName, allowIndirect, true);
    }

    @Nullable
    public static String calcAnnotationValue(PsiAnnotation[] annotation, @NonNls String attr) {
        for (PsiAnnotation psiAnnotation : annotation) {
            String value = AnnotationUtilEx.calcAnnotationValue(psiAnnotation, attr);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static String calcAnnotationValue(@NotNull PsiAnnotation annotation, @NonNls String attr) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/intellij/plugins/intelliLang/util/AnnotationUtilEx", "calcAnnotationValue"));
        }
        PsiAnnotationMemberValue value = annotation.findAttributeValue(attr);
        Object o = CONSTANT_EVALUATION_HELPER.computeConstantExpression((PsiElement)value);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private static PsiAnnotation[] getAnnotations(final @NotNull PsiModifierListOwner listOwner, boolean inHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "org/intellij/plugins/intelliLang/util/AnnotationUtilEx", "getAnnotations"));
        }
        PsiModifierList modifierList = listOwner.getModifierList();
        if (!inHierarchy) {
            return modifierList == null ? PsiAnnotation.EMPTY_ARRAY : modifierList.getAnnotations();
        }
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, (CachedValueProvider)new CachedValueProvider<PsiAnnotation[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiAnnotation[]> compute() {
                return CachedValueProvider.Result.create((Object)AnnotationUtilEx.getHierarchyAnnotations(listOwner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private static PsiAnnotation[] getHierarchyAnnotations(PsiModifierListOwner listOwner) {
        PsiParameter parameter;
        PsiElement declarationScope;
        PsiModifierList modifierList = listOwner.getModifierList();
        final HashSet<PsiAnnotation> all = new HashSet<PsiAnnotation>(){

            @Override
            public boolean add(PsiAnnotation o) {
                return !this.contains(o) && super.add(o);
            }
        };
        if (listOwner instanceof PsiMethod) {
            if (modifierList != null) {
                ContainerUtil.addAll((Collection)all, (Object[])modifierList.getAnnotations());
            }
            SuperMethodsSearch.search((PsiMethod)((PsiMethod)listOwner), null, (boolean)true, (boolean)true).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

                public boolean process(MethodSignatureBackedByPsiMethod superMethod) {
                    ContainerUtil.addAll((Collection)all, (Object[])superMethod.getMethod().getModifierList().getAnnotations());
                    return true;
                }
            });
            return all.toArray(new PsiAnnotation[all.size()]);
        }
        if (listOwner instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)listOwner).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameterList parameterList = ((PsiMethod)declarationScope).getParameterList();
            if (parameter.getParent() == parameterList) {
                PsiMethod method = (PsiMethod)declarationScope;
                final int parameterIndex = parameterList.getParameterIndex(parameter);
                if (modifierList != null) {
                    ContainerUtil.addAll((Collection)all, (Object[])modifierList.getAnnotations());
                }
                SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)true).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

                    public boolean process(MethodSignatureBackedByPsiMethod superMethod) {
                        PsiParameter superParameter = superMethod.getMethod().getParameterList().getParameters()[parameterIndex];
                        PsiModifierList modifierList = superParameter.getModifierList();
                        if (modifierList != null) {
                            ContainerUtil.addAll((Collection)all, (Object[])modifierList.getAnnotations());
                        }
                        return true;
                    }
                });
                return all.toArray(new PsiAnnotation[all.size()]);
            }
        }
        return modifierList == null ? PsiAnnotation.EMPTY_ARRAY : modifierList.getAnnotations();
    }

    public static interface AnnotatedElementVisitor {
        public boolean visitMethodParameter(PsiExpression var1, PsiCallExpression var2);

        public boolean visitMethodReturnStatement(PsiReturnStatement var1, PsiMethod var2);

        public boolean visitVariable(PsiVariable var1);

        public boolean visitAnnotationParameter(PsiNameValuePair var1, PsiAnnotation var2);

        public boolean visitReference(PsiReferenceExpression var1);
    }

    public static enum LookupType {
        PREFER_CONTEXT,
        PREFER_DECLARATION,
        CONTEXT_ONLY,
        DECLARATION_ONLY;

    }
}

