/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DownloadManager {
    private static final ExternalResourceManager resourceManager = ExternalResourceManager.getInstance();
    private final Project myProject;
    private final ProgressIndicator myProgress;
    private final String myResourcePath;

    public DownloadManager(Project project, ProgressIndicator progress) {
        this.myProject = project;
        this.myProgress = progress;
        this.myResourcePath = PathManager.getSystemPath() + File.separatorChar + "extResources";
        new File(this.myResourcePath).mkdirs();
    }

    public void fetch(final @NotNull String location) throws DownloadException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/intellij/lang/xpath/xslt/quickfix/DownloadManager", "fetch"));
        }
        if (resourceManager.getResourceLocation(location, this.myProject) != location) {
            return;
        }
        this.myProgress.setText("Downloading " + location);
        File file = null;
        try {
            file = (File)HttpRequests.request((String)location).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

                public File process(@NotNull HttpRequests.Request request) throws IOException {
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/intellij/lang/xpath/xslt/quickfix/DownloadManager$1", "process"));
                    }
                    String name = Integer.toHexString(System.identityHashCode(this)) + "_" + Integer.toHexString(location.hashCode()) + "_" + location.substring(location.lastIndexOf(47) + 1);
                    return request.saveToFile(new File(DownloadManager.this.myResourcePath, name.lastIndexOf(46) == -1 ? name + ".xml" : name), DownloadManager.this.myProgress);
                }
            });
            try {
                final File _file = file;
                final Set[] resourceDependencies = new Set[1];
                new WriteAction(){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/xslt/quickfix/DownloadManager$2", "run"));
                        }
                        final VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(_file);
                        if (vf != null) {
                            PsiFile psiFile = PsiManager.getInstance((Project)DownloadManager.this.myProject).findFile(vf);
                            if (psiFile != null && DownloadManager.this.isAccepted(psiFile)) {
                                resourceDependencies[0] = DownloadManager.this.getResourceDependencies(psiFile);
                                resourceManager.addResource(location, _file.getAbsolutePath());
                            } else {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Messages.showErrorDialog((Project)DownloadManager.this.myProject, (String)("Not a valid file: " + vf.getPresentableUrl()), (String)"Download Problem");
                                    }
                                }, DownloadManager.this.myProject.getDisposed());
                            }
                        }
                    }
                }.execute();
                if (resourceDependencies[0] != null) {
                    for (String s : resourceDependencies[0]) {
                        this.myProgress.checkCanceled();
                        this.myProgress.setFraction(0.0);
                        this.fetch(s);
                    }
                }
            }
            catch (Error err) {
                Throwable e = err.getCause();
                if (e instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    if (targetException instanceof RuntimeException) {
                        throw (RuntimeException)targetException;
                    }
                    if (targetException instanceof IOException) {
                        throw (IOException)targetException;
                    }
                    if (!(targetException instanceof InterruptedException)) {
                        Logger.getInstance((String)this.getClass().getName()).error(e);
                    }
                } else if (!(e instanceof InterruptedException)) {
                    throw err;
                }
            }
        }
        catch (IOException e) {
            throw new DownloadException(location, e);
        }
        finally {
            if (file != null && resourceManager.getResourceLocation(location, this.myProject) == location) {
                FileUtil.delete((File)file);
            }
        }
    }

    protected abstract boolean isAccepted(PsiFile var1);

    protected abstract Set<String> getResourceDependencies(PsiFile var1);

    public static class DownloadException
    extends IOException {
        private final String myLocation;

        public DownloadException(String location, IOException cause) {
            this.myLocation = location;
            this.initCause(cause);
        }

        public String getLocation() {
            return this.myLocation;
        }
    }
}

