/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.annotations.NonNull;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;

public class ArrayInstance
extends Instance {
    private final Type mType;
    private final int mLength;
    private final long mValuesOffset;

    public ArrayInstance(long id, @NonNull StackTrace stack, @NonNull Type type, int length, long valuesOffset) {
        super(id, stack);
        this.mType = type;
        this.mLength = length;
        this.mValuesOffset = valuesOffset;
    }

    @NonNull
    public Object[] getValues() {
        Object[] values = new Object[this.mLength];
        this.getBuffer().setPosition(this.mValuesOffset);
        for (int i = 0; i < this.mLength; ++i) {
            values[i] = this.readValue(this.mType);
        }
        return values;
    }

    @Override
    public final int getSize() {
        return this.mLength * this.mType.getSize();
    }

    @Override
    public final void accept(@NonNull Visitor visitor) {
        if (this.mType != Type.OBJECT) {
            return;
        }
        if (visitor.visitEnter(this)) {
            for (Object value : this.getValues()) {
                if (!(value instanceof Instance)) continue;
                ((Instance)value).accept(visitor);
            }
            visitor.visitLeave(this);
        }
    }

    public final String toString() {
        return String.format("%s[%d]@0x%08x", this.mType.name(), this.mLength, this.mId);
    }
}

