/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.rmi.RemoteException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RuntimeRemoteException;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.transfer.TransferResource;

public class TransferListenerAdapter
implements TransferListener {
    protected final MavenServerProgressIndicator myIndicator;

    public TransferListenerAdapter(MavenServerProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    private void checkCanceled() {
        try {
            if (this.myIndicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    private static String formatResourceName(TransferEvent event) {
        TransferResource resource = event.getResource();
        File file = resource.getFile();
        return (file == null ? resource.getResourceName() : file.getName()) + " [" + resource.getRepositoryUrl() + "]";
    }

    public void transferInitiated(TransferEvent event) {
        this.checkCanceled();
        try {
            this.myIndicator.setIndeterminate(true);
            this.myIndicator.setText2(TransferListenerAdapter.formatResourceName(event));
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.transferProgressed(event);
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        this.checkCanceled();
        TransferResource r = event.getResource();
        long totalLength = r.getContentLength();
        String sizeInfo = totalLength <= 0L ? StringUtil.formatFileSize((long)event.getTransferredBytes()) + " / ?" : StringUtil.formatFileSize((long)event.getTransferredBytes()) + " / " + StringUtil.formatFileSize((long)totalLength);
        try {
            this.myIndicator.setText2(TransferListenerAdapter.formatResourceName(event) + "  (" + sizeInfo + ')');
            if (totalLength <= 0L) {
                this.myIndicator.setIndeterminate(true);
            } else {
                this.myIndicator.setIndeterminate(false);
                this.myIndicator.setFraction((double)event.getTransferredBytes() / (double)totalLength);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        try {
            this.myIndicator.setText2("Checksum failed: " + TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        try {
            this.myIndicator.setText2("Finished (" + StringUtil.formatFileSize((long)event.getTransferredBytes()) + ") " + TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferFailed(TransferEvent event) {
        try {
            if (this.myIndicator.isCanceled()) {
                this.myIndicator.setText2("Canceling...");
                return;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
        try {
            this.myIndicator.setText2("Failed to download " + TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }
}

