/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.AssertProcessor;
import org.jetbrains.java.decompiler.main.ClassReference14Processor;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.EnumProcessor;
import org.jetbrains.java.decompiler.main.InitializerProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructAnnDefaultAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructConstantValueAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ClassWriter {
    private ClassReference14Processor ref14processor = new ClassReference14Processor();
    private PoolInterceptor interceptor = DecompilerContext.getPoolInterceptor();
    private static final String[] ANNOTATION_ATTRIBUTES = new String[]{"RuntimeVisibleAnnotations", "RuntimeInvisibleAnnotations"};
    private static final String[] PARAMETER_ANNOTATION_ATTRIBUTES = new String[]{"RuntimeVisibleParameterAnnotations", "RuntimeInvisibleParameterAnnotations"};
    private static final Map<Integer, String> MODIFIERS = new LinkedHashMap<Integer, String>(){
        {
            this.put(1, "public");
            this.put(4, "protected");
            this.put(2, "private");
            this.put(1024, "abstract");
            this.put(8, "static");
            this.put(16, "final");
            this.put(2048, "strictfp");
            this.put(128, "transient");
            this.put(64, "volatile");
            this.put(32, "synchronized");
            this.put(256, "native");
        }
    };
    private static final int CLASS_ALLOWED = 3103;
    private static final int FIELD_ALLOWED = 223;
    private static final int METHOD_ALLOWED = 3391;
    private static final int CLASS_EXCLUDED = 1032;
    private static final int FIELD_EXCLUDED = 25;
    private static final int METHOD_EXCLUDED = 1025;

    private void invokeProcessors(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.wrapper;
        StructClass cl = wrapper.getClassStruct();
        InitializerProcessor.extractInitializers(wrapper);
        if (node.type == 0 && DecompilerContext.getOption("dc4")) {
            this.ref14processor.processClassReferences(node);
        }
        if (cl.hasModifier(16384) && DecompilerContext.getOption("den")) {
            EnumProcessor.clearEnum(wrapper);
        }
        if (DecompilerContext.getOption("das")) {
            AssertProcessor.buildAssertions(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLambdaToJava(ClassesProcessor.ClassNode node, StringBuilder buffer, Exprent method_object, int indent) {
        ClassesProcessor.ClassNode classNode = node;
        while (classNode != null && classNode.type == 8) {
            classNode = classNode.parent;
        }
        if (classNode == null) {
            return;
        }
        boolean lambdaToAnonymous = DecompilerContext.getOption("lac");
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        BytecodeMappingTracer tracer = new BytecodeMappingTracer();
        try {
            ClassWrapper wrapper = classNode.wrapper;
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(node.simpleName);
            if (node.lambdaInformation.is_method_reference) {
                if (!node.lambdaInformation.is_content_method_static && method_object != null) {
                    buffer.append(method_object.toJava(indent, tracer));
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(new VarType(node.lambdaInformation.content_class_name, false)));
                }
                buffer.append("::");
                buffer.append(node.lambdaInformation.content_method_name);
            } else {
                StructMethod mt = cl.getMethod(node.lambdaInformation.content_method_key);
                MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
                MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                if (!lambdaToAnonymous) {
                    buffer.append('(');
                    boolean firstParameter = true;
                    int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
                    int start_index = md_content.params.length - md_lambda.params.length;
                    for (int i = 0; i < md_content.params.length; ++i) {
                        if (i >= start_index) {
                            String parameterName;
                            if (!firstParameter) {
                                buffer.append(", ");
                            }
                            buffer.append((parameterName = methodWrapper.varproc.getVarName(new VarVersionPaar(index, 0))) == null ? "param" + index : parameterName);
                            firstParameter = false;
                        }
                        index += md_content.params[i].stack_size;
                    }
                    buffer.append(") ->");
                }
                buffer.append(" {");
                buffer.append(DecompilerContext.getNewLineSeparator());
                ClassWriter.methodLambdaToJava(node, classNode, mt, buffer, indent + 1, !lambdaToAnonymous, tracer);
                InterpreterUtil.appendIndent(buffer, indent);
                buffer.append("}");
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classToJava(ClassesProcessor.ClassNode node, StringBuilder buffer, int indent) {
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        int total_offset_lines = 0;
        BytecodeMappingTracer dummy_tracer = new BytecodeMappingTracer();
        try {
            boolean hide;
            this.invokeProcessors(node);
            ClassWrapper wrapper = node.wrapper;
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(cl.qualifiedName);
            String lineSeparator = DecompilerContext.getNewLineSeparator();
            int start_class_def = buffer.length();
            this.writeClassDefinition(node, buffer, indent);
            total_offset_lines = buffer.substring(start_class_def).toString().split(lineSeparator, -1).length - 1;
            boolean hasContent = false;
            boolean enumFields = false;
            for (StructField fd : cl.getFields()) {
                boolean isEnum;
                hide = fd.isSynthetic() && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                if (hide) continue;
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
                if (isEnum) {
                    if (enumFields) {
                        buffer.append(',');
                        buffer.append(lineSeparator);
                    }
                    enumFields = true;
                } else if (enumFields) {
                    buffer.append(';');
                    buffer.append(lineSeparator);
                    buffer.append(lineSeparator);
                    enumFields = false;
                }
                this.fieldToJava(wrapper, cl, fd, buffer, indent + 1, dummy_tracer);
                hasContent = true;
            }
            if (enumFields) {
                buffer.append(';');
                buffer.append(lineSeparator);
            }
            for (StructMethod mt : cl.getMethods()) {
                BytecodeMappingTracer method_tracer;
                boolean methodSkipped;
                boolean bl = hide = mt.isSynthetic() && DecompilerContext.getOption("rsy") || mt.hasModifier(64) && DecompilerContext.getOption("rbr") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                if (hide) continue;
                int position = buffer.length();
                if (hasContent) {
                    buffer.append(lineSeparator);
                }
                boolean bl2 = methodSkipped = !this.methodToJava(node, mt, buffer, indent + 1, method_tracer = new BytecodeMappingTracer(total_offset_lines));
                if (!methodSkipped) {
                    hasContent = true;
                    DecompilerContext.getBytecodeSourceMapper().addTracer(cl.qualifiedName, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()), method_tracer);
                    total_offset_lines = method_tracer.getCurrentSourceline();
                    continue;
                }
                buffer.setLength(position);
            }
            for (ClassesProcessor.ClassNode inner : node.nested) {
                if (inner.type != 1) continue;
                StructClass innerCl = inner.classStruct;
                boolean isSynthetic = (inner.access & 0x1000) != 0 || innerCl.isSynthetic() || inner.namelessConstructorStub;
                boolean hide2 = isSynthetic && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(innerCl.qualifiedName);
                if (hide2) continue;
                if (hasContent) {
                    buffer.append(lineSeparator);
                }
                this.classToJava(inner, buffer, indent + 1);
                hasContent = true;
            }
            InterpreterUtil.appendIndent(buffer, indent);
            buffer.append('}');
            if (node.type != 2) {
                buffer.append(lineSeparator);
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    private void writeClassDefinition(ClassesProcessor.ClassNode node, StringBuilder buffer, int indent) {
        int[] interfaces;
        VarType supertype;
        StructGenericSignatureAttribute attr;
        boolean isAnnotation;
        String lineSeparator = DecompilerContext.getNewLineSeparator();
        String indentString = InterpreterUtil.getIndentString(indent);
        if (node.type == 2) {
            buffer.append(" {");
            buffer.append(lineSeparator);
            return;
        }
        ClassWrapper wrapper = node.wrapper;
        StructClass cl = wrapper.getClassStruct();
        int flags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean isDeprecated = cl.getAttributes().containsKey("Deprecated");
        boolean isSynthetic = (flags & 0x1000) != 0 || cl.getAttributes().containsKey("Synthetic");
        boolean isEnum = DecompilerContext.getOption("den") && (flags & 0x4000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean bl = isAnnotation = (flags & 0x2000) != 0;
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indentString, lineSeparator);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName);
            ClassWriter.appendRenameComment(buffer, oldName, MType.CLASS, indent, lineSeparator);
        }
        if (isSynthetic) {
            ClassWriter.appendComment(buffer, "synthetic class", indentString, lineSeparator);
        }
        ClassWriter.appendAnnotations(buffer, cl, indent, lineSeparator);
        buffer.append(indentString);
        if (isEnum) {
            flags &= 0xFFFFFBFF;
            flags &= 0xFFFFFFEF;
        }
        ClassWriter.appendModifiers(buffer, flags, 3103, isInterface, 1032);
        if (isEnum) {
            buffer.append("enum ");
        } else if (isInterface) {
            if (isAnnotation) {
                buffer.append('@');
            }
            buffer.append("interface ");
        } else {
            buffer.append("class ");
        }
        GenericClassDescriptor descriptor = null;
        if (DecompilerContext.getOption("dgs") && (attr = (StructGenericSignatureAttribute)cl.getAttributes().getWithKey("Signature")) != null) {
            descriptor = GenericMain.parseClassSignature(attr.getSignature());
        }
        buffer.append(node.simpleName);
        if (descriptor != null && !descriptor.fparameters.isEmpty()) {
            ClassWriter.appendTypeParameters(buffer, descriptor.fparameters, descriptor.fbounds);
        }
        buffer.append(' ');
        if (!(isEnum || isInterface || cl.superClass == null || VarType.VARTYPE_OBJECT.equals(supertype = new VarType(cl.superClass.getString(), true)))) {
            buffer.append("extends ");
            if (descriptor != null) {
                buffer.append(GenericMain.getGenericCastTypeName(descriptor.superclass));
            } else {
                buffer.append(ExprProcessor.getCastTypeName(supertype));
            }
            buffer.append(' ');
        }
        if (!isAnnotation && (interfaces = cl.getInterfaces()).length > 0) {
            buffer.append(isInterface ? "extends " : "implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (descriptor != null) {
                    buffer.append(GenericMain.getGenericCastTypeName(descriptor.superinterfaces.get(i)));
                    continue;
                }
                buffer.append(ExprProcessor.getCastTypeName(new VarType(cl.getInterface(i), true)));
            }
            buffer.append(' ');
        }
        buffer.append('{');
        buffer.append(lineSeparator);
    }

    private void fieldToJava(ClassWrapper wrapper, StructClass cl, StructField fd, StringBuilder buffer, int indent, BytecodeMappingTracer tracer) {
        StructConstantValueAttribute attr;
        StructGenericSignatureAttribute attr2;
        boolean isEnum;
        String indentString = InterpreterUtil.getIndentString(indent);
        String lineSeparator = DecompilerContext.getNewLineSeparator();
        boolean isInterface = cl.hasModifier(512);
        boolean isDeprecated = fd.getAttributes().containsKey("Deprecated");
        boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indentString, lineSeparator);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + fd.getName() + " " + fd.getDescriptor());
            ClassWriter.appendRenameComment(buffer, oldName, MType.FIELD, indent, lineSeparator);
        }
        if (fd.isSynthetic()) {
            ClassWriter.appendComment(buffer, "synthetic field", indentString, lineSeparator);
        }
        ClassWriter.appendAnnotations(buffer, fd, indent, lineSeparator);
        buffer.append(indentString);
        if (!isEnum) {
            ClassWriter.appendModifiers(buffer, fd.getAccessFlags(), 223, isInterface, 25);
        }
        VarType fieldType = new VarType(fd.getDescriptor(), false);
        GenericFieldDescriptor descriptor = null;
        if (DecompilerContext.getOption("dgs") && (attr2 = (StructGenericSignatureAttribute)fd.getAttributes().getWithKey("Signature")) != null) {
            descriptor = GenericMain.parseFieldSignature(attr2.getSignature());
        }
        if (!isEnum) {
            if (descriptor != null) {
                buffer.append(GenericMain.getGenericCastTypeName(descriptor.type));
            } else {
                buffer.append(ExprProcessor.getCastTypeName(fieldType));
            }
            buffer.append(' ');
        }
        buffer.append(fd.getName());
        Exprent initializer = fd.hasModifier(8) ? wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) : wrapper.getDynamicFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
        if (initializer != null) {
            if (isEnum && initializer.type == 10) {
                NewExprent nexpr = (NewExprent)initializer;
                nexpr.setEnumconst(true);
                buffer.append(nexpr.toJava(indent, tracer));
            } else {
                buffer.append(" = ");
                buffer.append(initializer.toJava(indent, tracer));
            }
        } else if (fd.hasModifier(16) && fd.hasModifier(8) && (attr = (StructConstantValueAttribute)fd.getAttributes().getWithKey("ConstantValue")) != null) {
            PrimitiveConstant constant = cl.getPool().getPrimitiveConstant(attr.getIndex());
            buffer.append(" = ");
            buffer.append(new ConstExprent(fieldType, constant.value).toJava(indent, tracer));
        }
        if (!isEnum) {
            buffer.append(";");
            buffer.append(lineSeparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodLambdaToJava(ClassesProcessor.ClassNode lambdaNode, ClassesProcessor.ClassNode classNode, StructMethod mt, StringBuilder buffer, int indent, boolean codeOnly, BytecodeMappingTracer tracer) {
        ClassWrapper classWrapper = classNode.wrapper;
        MethodWrapper methodWrapper = classWrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            RootStatement root;
            String method_name = lambdaNode.lambdaInformation.method_name;
            MethodDescriptor md_content = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.content_method_descriptor);
            MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.method_descriptor);
            if (!codeOnly) {
                InterpreterUtil.appendIndent(buffer, indent);
                buffer.append("public ");
                buffer.append(method_name);
                buffer.append("(");
                boolean firstParameter = true;
                int index = lambdaNode.lambdaInformation.is_content_method_static ? 0 : 1;
                int start_index = md_content.params.length - md_lambda.params.length;
                for (int i = 0; i < md_content.params.length; ++i) {
                    if (i >= start_index) {
                        String typeName;
                        if (!firstParameter) {
                            buffer.append(", ");
                        }
                        if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(md_content.params[i].copy())) && DecompilerContext.getOption("uto")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                        }
                        buffer.append(typeName);
                        buffer.append(" ");
                        String parameterName = methodWrapper.varproc.getVarName(new VarVersionPaar(index, 0));
                        buffer.append(parameterName == null ? "param" + index : parameterName);
                        firstParameter = false;
                    }
                    index += md_content.params[i].stack_size;
                }
                buffer.append(") {");
                buffer.append(DecompilerContext.getNewLineSeparator());
                ++indent;
            }
            if (!methodWrapper.decompiledWithErrors && (root = classWrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root) != null) {
                try {
                    buffer.append(root.toJava(indent, tracer));
                }
                catch (Throwable ex) {
                    DecompilerContext.getLogger().writeMessage("Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.", ex);
                    methodWrapper.decompiledWithErrors = true;
                }
            }
            if (methodWrapper.decompiledWithErrors) {
                InterpreterUtil.appendIndent(buffer, indent);
                buffer.append("// $FF: Couldn't be decompiled");
                buffer.append(DecompilerContext.getNewLineSeparator());
            }
            if (!codeOnly) {
                InterpreterUtil.appendIndent(buffer, --indent);
                buffer.append('}');
                buffer.append(DecompilerContext.getNewLineSeparator());
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean methodToJava(ClassesProcessor.ClassNode node, StructMethod mt, StringBuilder buffer, int indent, BytecodeMappingTracer tracer) {
        String lineSeparator;
        int start_index_method;
        boolean hideMethod;
        block47: {
            ClassWrapper wrapper = node.wrapper;
            StructClass cl = wrapper.getClassStruct();
            MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
            hideMethod = false;
            start_index_method = buffer.length();
            String indentString = InterpreterUtil.getIndentString(indent);
            lineSeparator = DecompilerContext.getNewLineSeparator();
            MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
            try {
                StructGenericSignatureAttribute attr;
                String name;
                boolean isBridge;
                boolean isInterface = cl.hasModifier(512);
                boolean isAnnotation = cl.hasModifier(8192);
                boolean isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
                boolean isDeprecated = mt.getAttributes().containsKey("Deprecated");
                boolean clinit = false;
                boolean init = false;
                boolean dinit = false;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                int flags = mt.getAccessFlags();
                if ((flags & 0x100) != 0) {
                    flags &= 0xFFFFF7FF;
                }
                if ("<clinit>".equals(mt.getName())) {
                    flags &= 8;
                }
                if (isDeprecated) {
                    ClassWriter.appendDeprecation(buffer, indentString, lineSeparator);
                }
                if (this.interceptor != null) {
                    String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + mt.getName() + " " + mt.getDescriptor());
                    ClassWriter.appendRenameComment(buffer, oldName, MType.METHOD, indent, lineSeparator);
                }
                boolean isSynthetic = (flags & 0x1000) != 0 || mt.getAttributes().containsKey("Synthetic");
                boolean bl = isBridge = (flags & 0x40) != 0;
                if (isSynthetic) {
                    ClassWriter.appendComment(buffer, "synthetic method", indentString, lineSeparator);
                }
                if (isBridge) {
                    ClassWriter.appendComment(buffer, "bridge method", indentString, lineSeparator);
                }
                ClassWriter.appendAnnotations(buffer, mt, indent, lineSeparator);
                buffer.append(indentString);
                ClassWriter.appendModifiers(buffer, flags, 3391, isInterface, 1025);
                if (isInterface && mt.containsCode()) {
                    buffer.append("default ");
                }
                if ("<init>".equals(name = mt.getName())) {
                    if (node.type == 2) {
                        name = "";
                        dinit = true;
                    } else {
                        name = node.simpleName;
                        init = true;
                    }
                } else if ("<clinit>".equals(name)) {
                    name = "";
                    clinit = true;
                }
                GenericMethodDescriptor descriptor = null;
                if (DecompilerContext.getOption("dgs") && (attr = (StructGenericSignatureAttribute)mt.getAttributes().getWithKey("Signature")) != null && (descriptor = GenericMain.parseMethodSignature(attr.getSignature())) != null) {
                    int actualParams = md.params.length;
                    if (isEnum && init) {
                        actualParams -= 2;
                    }
                    if (actualParams != descriptor.params.size()) {
                        String message = "Inconsistent generic signature in method " + mt.getName() + " " + mt.getDescriptor();
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                        descriptor = null;
                    }
                }
                boolean throwsExceptions = false;
                int paramCount = 0;
                if (!clinit && !dinit) {
                    boolean thisVar;
                    boolean bl2 = thisVar = !mt.hasModifier(8);
                    if (descriptor != null && !descriptor.fparameters.isEmpty()) {
                        ClassWriter.appendTypeParameters(buffer, descriptor.fparameters, descriptor.fbounds);
                        buffer.append(' ');
                    }
                    if (!init) {
                        if (descriptor != null) {
                            buffer.append(GenericMain.getGenericCastTypeName(descriptor.ret));
                        } else {
                            buffer.append(ExprProcessor.getCastTypeName(md.ret));
                        }
                        buffer.append(' ');
                    }
                    buffer.append(name);
                    buffer.append('(');
                    List<VarVersionPaar> signFields = methodWrapper.signatureFields;
                    int lastVisibleParameterIndex = -1;
                    for (int i = 0; i < md.params.length; ++i) {
                        if (signFields != null && signFields.get(i) != null) continue;
                        lastVisibleParameterIndex = i;
                    }
                    boolean firstParameter = true;
                    int index = isEnum && init ? 3 : (thisVar ? 1 : 0);
                    int start = isEnum && init && descriptor == null ? 2 : 0;
                    int params = descriptor == null ? md.params.length : descriptor.params.size();
                    for (int i = start; i < params; ++i) {
                        if (signFields == null || signFields.get(i) == null) {
                            String typeName;
                            boolean isVarArg;
                            Object parameterType;
                            if (!firstParameter) {
                                buffer.append(", ");
                            }
                            ClassWriter.appendParameterAnnotations(buffer, mt, paramCount);
                            if (methodWrapper.varproc.getVarFinal(new VarVersionPaar(index, 0)) == 2) {
                                buffer.append("final ");
                            }
                            if (descriptor != null) {
                                parameterType = descriptor.params.get(i);
                                boolean bl3 = isVarArg = i == lastVisibleParameterIndex && mt.hasModifier(128) && ((GenericType)parameterType).arraydim > 0;
                                if (isVarArg) {
                                    --((GenericType)parameterType).arraydim;
                                }
                                if ("<undefinedtype>".equals(typeName = GenericMain.getGenericCastTypeName((GenericType)parameterType)) && DecompilerContext.getOption("uto")) {
                                    typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                                }
                                buffer.append(typeName);
                                if (isVarArg) {
                                    buffer.append("...");
                                }
                            } else {
                                parameterType = md.params[i].copy();
                                boolean bl4 = isVarArg = i == lastVisibleParameterIndex && mt.hasModifier(128) && ((VarType)parameterType).arraydim > 0;
                                if (isVarArg) {
                                    ((VarType)parameterType).decArrayDim();
                                }
                                if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName((VarType)parameterType)) && DecompilerContext.getOption("uto")) {
                                    typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                                }
                                buffer.append(typeName);
                                if (isVarArg) {
                                    buffer.append("...");
                                }
                            }
                            buffer.append(' ');
                            String parameterName = methodWrapper.varproc.getVarName(new VarVersionPaar(index, 0));
                            buffer.append(parameterName == null ? "param" + index : parameterName);
                            firstParameter = false;
                            ++paramCount;
                        }
                        index += md.params[i].stack_size;
                    }
                    buffer.append(')');
                    StructExceptionsAttribute attr2 = (StructExceptionsAttribute)mt.getAttributes().getWithKey("Exceptions");
                    if (descriptor != null && !descriptor.exceptions.isEmpty() || attr2 != null) {
                        throwsExceptions = true;
                        buffer.append(" throws ");
                        for (int i = 0; i < attr2.getThrowsExceptions().size(); ++i) {
                            Object type;
                            if (i > 0) {
                                buffer.append(", ");
                            }
                            if (descriptor != null && !descriptor.exceptions.isEmpty()) {
                                type = descriptor.exceptions.get(i);
                                buffer.append(GenericMain.getGenericCastTypeName((GenericType)type));
                                continue;
                            }
                            type = new VarType(attr2.getExcClassname(i, cl.getPool()), true);
                            buffer.append(ExprProcessor.getCastTypeName((VarType)type));
                        }
                    }
                }
                if ((flags & 0x500) != 0) {
                    StructAnnDefaultAttribute attr3;
                    if (isAnnotation && (attr3 = (StructAnnDefaultAttribute)mt.getAttributes().getWithKey("AnnotationDefault")) != null) {
                        buffer.append(" default ");
                        buffer.append(attr3.getDefaultValue().toJava(indent + 1, new BytecodeMappingTracer()));
                    }
                    buffer.append(';');
                    buffer.append(lineSeparator);
                    break block47;
                }
                if (!clinit && !dinit) {
                    buffer.append(' ');
                }
                buffer.append('{');
                buffer.append(lineSeparator);
                RootStatement root = wrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
                if (root != null && !methodWrapper.decompiledWithErrors) {
                    try {
                        tracer.setCurrentSourceline(buffer.substring(start_index_method).split(lineSeparator, -1).length - 1);
                        String code = root.toJava(indent + 1, tracer);
                        hideMethod = (clinit || dinit || ClassWriter.hideConstructor(wrapper, init, throwsExceptions, paramCount)) && code.length() == 0;
                        buffer.append(code);
                    }
                    catch (Throwable ex) {
                        DecompilerContext.getLogger().writeMessage("Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.", ex);
                        methodWrapper.decompiledWithErrors = true;
                    }
                }
                if (methodWrapper.decompiledWithErrors) {
                    buffer.append(InterpreterUtil.getIndentString(indent + 1));
                    buffer.append("// $FF: Couldn't be decompiled");
                    buffer.append(lineSeparator);
                }
                buffer.append(indentString);
                buffer.append('}');
                buffer.append(lineSeparator);
            }
            finally {
                DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
            }
        }
        tracer.setCurrentSourceline(buffer.substring(start_index_method).split(lineSeparator, -1).length - 1);
        return !hideMethod;
    }

    private static boolean hideConstructor(ClassWrapper wrapper, boolean init, boolean throwsExceptions, int paramCount) {
        if (!init || throwsExceptions || paramCount > 0 || !DecompilerContext.getOption("hdc")) {
            return false;
        }
        int count = 0;
        for (StructMethod mt : wrapper.getClassStruct().getMethods()) {
            if (!"<init>".equals(mt.getName()) || ++count <= 1) continue;
            return false;
        }
        return true;
    }

    private static void appendDeprecation(StringBuilder buffer, String indentString, String lineSeparator) {
        buffer.append(indentString).append("/** @deprecated */").append(lineSeparator);
    }

    private static void appendRenameComment(StringBuilder buffer, String oldName, MType type, int indent, String lineSeparator) {
        if (oldName == null) {
            return;
        }
        InterpreterUtil.appendIndent(buffer, indent);
        buffer.append("// $FF: renamed from: ");
        switch (type) {
            case CLASS: {
                buffer.append(ExprProcessor.buildJavaClassName(oldName));
                break;
            }
            case FIELD: {
                String[] fParts = oldName.split(" ");
                FieldDescriptor fd = FieldDescriptor.parseDescriptor(fParts[2]);
                buffer.append(fParts[1]);
                buffer.append(' ');
                buffer.append(ClassWriter.getTypePrintOut(fd.type));
                break;
            }
            default: {
                String[] mParts = oldName.split(" ");
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mParts[2]);
                buffer.append(mParts[1]);
                buffer.append(" (");
                boolean first = true;
                for (VarType paramType : md.params) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(ClassWriter.getTypePrintOut(paramType));
                }
                buffer.append(") ");
                buffer.append(ClassWriter.getTypePrintOut(md.ret));
            }
        }
        buffer.append(lineSeparator);
    }

    private static String getTypePrintOut(VarType type) {
        String typeText = ExprProcessor.getCastTypeName(type, false);
        if ("<undefinedtype>".equals(typeText) && DecompilerContext.getOption("uto")) {
            typeText = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, false);
        }
        return typeText;
    }

    private static void appendComment(StringBuilder buffer, String comment, String indentString, String lineSeparator) {
        buffer.append(indentString).append("// $FF: ").append(comment).append(lineSeparator);
    }

    private static void appendAnnotations(StringBuilder buffer, StructMember mb, int indent, String lineSeparator) {
        BytecodeMappingTracer tracer_dummy = new BytecodeMappingTracer();
        for (String name : ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mb.getAttributes().getWithKey(name);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                buffer.append(annotation.toJava(indent, tracer_dummy)).append(lineSeparator);
            }
        }
    }

    private static void appendParameterAnnotations(StringBuilder buffer, StructMethod mt, int param) {
        BytecodeMappingTracer tracer_dummy = new BytecodeMappingTracer();
        for (String name : PARAMETER_ANNOTATION_ATTRIBUTES) {
            List<List<AnnotationExprent>> annotations;
            StructAnnotationParameterAttribute attribute = (StructAnnotationParameterAttribute)mt.getAttributes().getWithKey(name);
            if (attribute == null || param >= (annotations = attribute.getParamAnnotations()).size()) continue;
            for (AnnotationExprent annotation : annotations.get(param)) {
                buffer.append(annotation.toJava(0, tracer_dummy)).append(' ');
            }
        }
    }

    private static void appendModifiers(StringBuilder buffer, int flags, int allowed, boolean isInterface, int excluded) {
        flags &= allowed;
        if (!isInterface) {
            excluded = 0;
        }
        for (int modifier : MODIFIERS.keySet()) {
            if ((flags & modifier) != modifier || (modifier & excluded) != 0) continue;
            buffer.append(MODIFIERS.get(modifier)).append(' ');
        }
    }

    private static void appendTypeParameters(StringBuilder buffer, List<String> parameters, List<List<GenericType>> bounds) {
        buffer.append('<');
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(parameters.get(i));
            List<GenericType> parameterBounds = bounds.get(i);
            if (parameterBounds.size() <= 1 && "java/lang/Object".equals(parameterBounds.get((int)0).value)) continue;
            buffer.append(" extends ");
            buffer.append(GenericMain.getGenericCastTypeName(parameterBounds.get(0)));
            for (int j = 1; j < parameterBounds.size(); ++j) {
                buffer.append(" & ");
                buffer.append(GenericMain.getGenericCastTypeName(parameterBounds.get(j)));
            }
        }
        buffer.append('>');
    }

    private static enum MType {
        CLASS,
        FIELD,
        METHOD;

    }
}

