/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class CatchAllStatement
extends Statement {
    private Statement handler;
    private boolean isFinally;
    private VarExprent monitor;
    private List<VarExprent> vars = new ArrayList<VarExprent>();

    private CatchAllStatement() {
        this.type = 12;
    }

    private CatchAllStatement(Statement head, Statement handler) {
        this();
        StatEdge edge;
        this.first = head;
        this.stats.addWithKey(head, head.id);
        this.handler = handler;
        this.stats.addWithKey(handler, handler.id);
        List<StatEdge> lstSuccs = head.getSuccessorEdges(0x40000000);
        if (!lstSuccs.isEmpty() && (edge = lstSuccs.get(0)).getType() == 1) {
            this.post = edge.getDestination();
        }
        this.vars.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, "java/lang/Throwable"), (VarProcessor)DecompilerContext.getProperty("CURRENT_VAR_PROCESSOR")));
    }

    public static Statement isHead(Statement head) {
        if (head.getLastBasicType() != 2) {
            return null;
        }
        HashSet<Statement> setHandlers = DecHelper.getUniquePredExceptions(head);
        if (setHandlers.size() != 1) {
            return null;
        }
        for (StatEdge edge : head.getSuccessorEdges(2)) {
            List<StatEdge> lstSuccs;
            Statement exc = edge.getDestination();
            if (edge.getExceptions() != null || !setHandlers.contains(exc) || exc.getLastBasicType() != 2 || !(lstSuccs = exc.getSuccessorEdges(0x40000000)).isEmpty() && lstSuccs.get(0).getType() == 1) continue;
            if (head.isMonitorEnter() || exc.isMonitorEnter()) {
                return null;
            }
            if (!DecHelper.checkStatementExceptions(Arrays.asList(head, exc))) continue;
            return new CatchAllStatement(head, exc);
        }
        return null;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        String indstr = InterpreterUtil.getIndentString(indent);
        String indstr1 = null;
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buf = new StringBuilder();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        boolean labeled = this.isLabeled();
        if (labeled) {
            buf.append(indstr).append("label").append(this.id).append(":").append(new_line_separator);
            tracer.incrementSourceLine();
        }
        List<StatEdge> lstSuccs = this.first.getSuccessorEdges(0x40000000);
        if (this.first.type == 7 && this.first.varDefinitions.isEmpty() && this.isFinally && !labeled && !this.first.isLabeled() && (lstSuccs.isEmpty() || !lstSuccs.get((int)0).explicit)) {
            String content = ExprProcessor.jmpWrapper(this.first, indent, true, tracer);
            content = content.substring(0, content.length() - new_line_separator.length());
            buf.append(content);
        } else {
            buf.append(indstr).append("try {").append(new_line_separator);
            tracer.incrementSourceLine();
            buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, true, tracer));
            buf.append(indstr).append("}");
        }
        buf.append(this.isFinally ? " finally" : " catch (" + this.vars.get(0).toJava(indent, tracer) + ")").append(" {").append(new_line_separator);
        tracer.incrementSourceLine();
        if (this.monitor != null) {
            indstr1 = InterpreterUtil.getIndentString(indent + 1);
            buf.append(indstr1).append("if(").append(this.monitor.toJava(indent, tracer)).append(") {").append(new_line_separator);
            tracer.incrementSourceLine();
        }
        buf.append(ExprProcessor.jmpWrapper(this.handler, indent + 1 + (this.monitor != null ? 1 : 0), true, tracer));
        if (this.monitor != null) {
            buf.append(indstr1).append("}").append(new_line_separator);
            tracer.incrementSourceLine();
        }
        buf.append(indstr).append("}").append(new_line_separator);
        tracer.incrementSourceLine();
        return buf.toString();
    }

    @Override
    public void replaceStatement(Statement oldstat, Statement newstat) {
        if (this.handler == oldstat) {
            this.handler = newstat;
        }
        super.replaceStatement(oldstat, newstat);
    }

    @Override
    public Statement getSimpleCopy() {
        CatchAllStatement cas = new CatchAllStatement();
        cas.isFinally = this.isFinally;
        if (this.monitor != null) {
            cas.monitor = new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), VarType.VARTYPE_INT, (VarProcessor)DecompilerContext.getProperty("CURRENT_VAR_PROCESSOR"));
        }
        if (!this.vars.isEmpty()) {
            this.vars.add(new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, "java/lang/Throwable"), (VarProcessor)DecompilerContext.getProperty("CURRENT_VAR_PROCESSOR")));
        }
        return cas;
    }

    @Override
    public void initSimpleCopy() {
        this.first = (Statement)this.stats.get(0);
        this.handler = (Statement)this.stats.get(1);
    }

    public Statement getHandler() {
        return this.handler;
    }

    public void setHandler(Statement handler) {
        this.handler = handler;
    }

    public boolean isFinally() {
        return this.isFinally;
    }

    public void setFinally(boolean isFinally) {
        this.isFinally = isFinally;
    }

    public VarExprent getMonitor() {
        return this.monitor;
    }

    public void setMonitor(VarExprent monitor) {
        this.monitor = monitor;
    }

    public List<VarExprent> getVars() {
        return this.vars;
    }
}

