/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public class VarDefinitionHelper {
    private HashMap<Integer, Statement> mapVarDefStatements = new HashMap();
    private HashMap<Integer, HashSet<Integer>> mapStatementVars = new HashMap();
    private HashSet<Integer> implDefVars = new HashSet();
    private VarProcessor varproc;

    public VarDefinitionHelper(Statement root, StructMethod mt, VarProcessor varproc) {
        this.varproc = varproc;
        VarNamesCollector vc = DecompilerContext.getVarNamesCollector();
        boolean thisvar = !mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        int paramcount = 0;
        if (thisvar) {
            paramcount = 1;
        }
        paramcount += md.params.length;
        int varindex = 0;
        for (int i = 0; i < paramcount; ++i) {
            this.implDefVars.add(varindex);
            varproc.setVarName(new VarVersionPaar(varindex, 0), vc.getFreeName(varindex));
            if (thisvar) {
                if (i == 0) {
                    ++varindex;
                    continue;
                }
                varindex += md.params[i - 1].stack_size;
                continue;
            }
            varindex += md.params[i].stack_size;
        }
        if (thisvar) {
            StructClass current_class = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
            varproc.getThisvars().put(new VarVersionPaar(0, 0), current_class.qualifiedName);
            varproc.setVarName(new VarVersionPaar(0, 0), "this");
            vc.addName("this");
        }
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement st = (Statement)stack.removeFirst();
            List<VarExprent> lstVars = null;
            if (st.type == 12) {
                lstVars = ((CatchAllStatement)st).getVars();
            } else if (st.type == 7) {
                lstVars = ((CatchStatement)st).getVars();
            }
            if (lstVars != null) {
                for (VarExprent var : lstVars) {
                    this.implDefVars.add(var.getIndex());
                    varproc.setVarName(new VarVersionPaar(var), vc.getFreeName(var.getIndex()));
                    var.setDefinition(true);
                }
            }
            stack.addAll(st.getStats());
        }
        this.initStatement(root);
    }

    public void setVarDefinitions() {
        VarNamesCollector vc = DecompilerContext.getVarNamesCollector();
        for (Map.Entry<Integer, Statement> en : this.mapVarDefStatements.entrySet()) {
            Statement first;
            DoStatement dstat;
            Statement stat = en.getValue();
            Integer index = en.getKey();
            if (this.implDefVars.contains(index)) continue;
            this.varproc.setVarName(new VarVersionPaar((int)index, 0), vc.getFreeName(index));
            if (stat.type == 5 && (dstat = (DoStatement)stat).getLooptype() == 3) {
                if (dstat.getInitExprent() != null && VarDefinitionHelper.setDefinition(dstat.getInitExprent(), index)) continue;
                List<Exprent> lstSpecial = Arrays.asList(dstat.getConditionExprent(), dstat.getIncExprent());
                for (VarExprent var : VarDefinitionHelper.getAllVars(lstSpecial)) {
                    if (var.getIndex() != index.intValue()) continue;
                    stat = stat.getParent();
                    break;
                }
            }
            List<Exprent> lst = (first = this.findFirstBlock(stat, index)) == null ? stat.getVarDefinitions() : (first.getExprents() == null ? first.getVarDefinitions() : first.getExprents());
            boolean defset = false;
            int addindex = 0;
            for (Exprent expr : lst) {
                if (VarDefinitionHelper.setDefinition(expr, index)) {
                    defset = true;
                    break;
                }
                boolean foundvar = false;
                for (Exprent exp : expr.getAllExprents(true)) {
                    if (exp.type != 12 || ((VarExprent)exp).getIndex() != index.intValue()) continue;
                    foundvar = true;
                    break;
                }
                if (foundvar) break;
                ++addindex;
            }
            if (defset) continue;
            VarExprent var = new VarExprent(index, this.varproc.getVarType(new VarVersionPaar((int)index, 0)), this.varproc);
            var.setDefinition(true);
            lst.add(addindex, var);
        }
    }

    private Statement findFirstBlock(Statement stat, Integer varindex) {
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(stat);
        block4: while (!stack.isEmpty()) {
            Statement st = (Statement)stack.remove(0);
            if (!stack.isEmpty() && !this.mapStatementVars.get(st.id).contains(varindex)) continue;
            if (st.isLabeled() && !stack.isEmpty()) {
                return st;
            }
            if (st.getExprents() != null) {
                return st;
            }
            stack.clear();
            switch (st.type) {
                case 15: {
                    stack.addAll(0, st.getStats());
                    continue block4;
                }
                case 2: 
                case 6: 
                case 10: 
                case 13: {
                    stack.add(st.getFirst());
                    continue block4;
                }
            }
            return st;
        }
        return null;
    }

    private Set<Integer> initStatement(Statement stat) {
        List<VarExprent> condlst;
        HashMap<Integer, Integer> mapCount = new HashMap<Integer, Integer>();
        if (stat.getExprents() == null) {
            ArrayList<Integer> childVars = new ArrayList<Integer>();
            ArrayList<Exprent> currVars = new ArrayList<Exprent>();
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    CatchAllStatement fin;
                    Statement st = (Statement)obj;
                    childVars.addAll(this.initStatement(st));
                    if (st.type == 5) {
                        DoStatement dost = (DoStatement)st;
                        if (dost.getLooptype() == 3 || dost.getLooptype() == 0) continue;
                        currVars.add(dost.getConditionExprent());
                        continue;
                    }
                    if (st.type != 12 || !(fin = (CatchAllStatement)st).isFinally() || fin.getMonitor() == null) continue;
                    currVars.add(fin.getMonitor());
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                currVars.add((Exprent)obj);
            }
            for (Integer index : childVars) {
                Integer count = (Integer)mapCount.get(index);
                if (count == null) {
                    count = new Integer(0);
                }
                mapCount.put(index, new Integer(count + 1));
            }
            condlst = VarDefinitionHelper.getAllVars(currVars);
        } else {
            condlst = VarDefinitionHelper.getAllVars(stat.getExprents());
        }
        for (VarExprent var : condlst) {
            mapCount.put(new Integer(var.getIndex()), new Integer(2));
        }
        HashSet<Integer> set = new HashSet<Integer>(mapCount.keySet());
        for (Map.Entry en : mapCount.entrySet()) {
            if ((Integer)en.getValue() <= 1) continue;
            this.mapVarDefStatements.put((Integer)en.getKey(), stat);
        }
        this.mapStatementVars.put(stat.id, set);
        return set;
    }

    private static List<VarExprent> getAllVars(List<Exprent> lst) {
        ArrayList<VarExprent> res = new ArrayList<VarExprent>();
        ArrayList<Exprent> listTemp = new ArrayList<Exprent>();
        for (Exprent expr : lst) {
            listTemp.addAll(expr.getAllExprents(true));
            listTemp.add(expr);
        }
        for (Exprent exprent : listTemp) {
            if (exprent.type != 12) continue;
            res.add((VarExprent)exprent);
        }
        return res;
    }

    private static boolean setDefinition(Exprent expr, Integer index) {
        if (expr.type == 2) {
            VarExprent var;
            Exprent left = ((AssignmentExprent)expr).getLeft();
            if (left.type == 12 && (var = (VarExprent)left).getIndex() == index.intValue()) {
                var.setDefinition(true);
                return true;
            }
        }
        return false;
    }
}

