/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class FastSetFactory<E> {
    private VBStyleCollection<int[], E> colValuesInternal = new VBStyleCollection();
    private int lastBlock;
    private int lastMask;

    public FastSetFactory(Collection<E> set) {
        int block = -1;
        int mask = -1;
        int index = 0;
        for (E element : set) {
            block = index / 32;
            mask = index % 32 == 0 ? 1 : (mask <<= 1);
            this.colValuesInternal.putWithKey(new int[]{block, mask}, (int[])element);
            ++index;
        }
        this.lastBlock = block;
        this.lastMask = mask;
    }

    private int[] addElement(E element) {
        this.lastMask = this.lastMask == -1 || this.lastMask == Integer.MIN_VALUE ? 1 : (this.lastMask <<= 1);
        int[] pointer = new int[]{++this.lastBlock, this.lastMask};
        this.colValuesInternal.putWithKey(pointer, (int[])element);
        return pointer;
    }

    public FastSet<E> spawnEmptySet() {
        return new FastSet(this);
    }

    public int getLastBlock() {
        return this.lastBlock;
    }

    public int getLastMask() {
        return this.lastMask;
    }

    private VBStyleCollection<int[], E> getInternalValuesCollection() {
        return this.colValuesInternal;
    }

    public static class FastSetIterator<E>
    implements Iterator<E> {
        private VBStyleCollection<int[], E> colValuesInternal;
        private int[] data;
        private int size;
        private int pointer = -1;
        private int next_pointer = -1;

        private FastSetIterator(FastSet<E> set) {
            this.colValuesInternal = ((FastSetFactory)set.getFactory()).getInternalValuesCollection();
            this.data = ((FastSet)set).getData();
            this.size = this.colValuesInternal.size();
            int datasize = this.data.length * 32;
            if (datasize < this.size) {
                this.size = datasize;
            }
        }

        @Override
        public boolean hasNext() {
            this.next_pointer = this.pointer;
            while (++this.next_pointer < this.size) {
                int[] index = (int[])this.colValuesInternal.get(this.next_pointer);
                if ((this.data[index[0]] & index[1]) == 0) continue;
                return true;
            }
            this.next_pointer = -1;
            return false;
        }

        @Override
        public E next() {
            if (this.next_pointer >= 0) {
                this.pointer = this.next_pointer;
            } else {
                int[] index;
                while (++this.pointer < this.size && (this.data[(index = (int[])this.colValuesInternal.get(this.pointer))[0]] & index[1]) == 0) {
                }
            }
            this.next_pointer = -1;
            return this.pointer < this.size ? (E)this.colValuesInternal.getKey(this.pointer) : null;
        }

        @Override
        public void remove() {
            int[] index = (int[])this.colValuesInternal.get(this.pointer);
            int n = index[0];
            this.data[n] = this.data[n] & ~index[1];
            --this.pointer;
        }
    }

    public static class FastSet<E>
    implements Iterable<E> {
        private FastSetFactory<E> factory;
        private VBStyleCollection<int[], E> colValuesInternal;
        private int[] data;

        private FastSet(FastSetFactory<E> factory) {
            this.factory = factory;
            this.colValuesInternal = ((FastSetFactory)factory).getInternalValuesCollection();
            this.data = new int[factory.getLastBlock() + 1];
        }

        public FastSet<E> getCopy() {
            FastSet<E> copy = new FastSet<E>(this.factory);
            int arrlength = this.data.length;
            int[] cpdata = new int[arrlength];
            System.arraycopy(this.data, 0, cpdata, 0, arrlength);
            super.setData(cpdata);
            return copy;
        }

        private int[] ensureCapacity(int index) {
            int newlength = this.data.length;
            if (newlength == 0) {
                newlength = 1;
            }
            while (newlength <= index) {
                newlength *= 2;
            }
            int[] newdata = new int[newlength];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
            return newdata;
        }

        public void add(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            if (index == null) {
                index = ((FastSetFactory)this.factory).addElement(element);
            }
            if (index[0] >= this.data.length) {
                this.ensureCapacity(index[0]);
            }
            int n = index[0];
            this.data[n] = this.data[n] | index[1];
        }

        public void setAllElements() {
            int lastblock = this.factory.getLastBlock();
            int lastmask = this.factory.getLastMask();
            if (lastblock >= this.data.length) {
                this.ensureCapacity(lastblock);
            }
            for (int i = lastblock - 1; i >= 0; --i) {
                this.data[i] = -1;
            }
            this.data[lastblock] = lastmask | lastmask - 1;
        }

        public void addAll(Set<E> set) {
            for (E element : set) {
                this.add(element);
            }
        }

        public void remove(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            if (index == null) {
                index = ((FastSetFactory)this.factory).addElement(element);
            }
            if (index[0] < this.data.length) {
                int n = index[0];
                this.data[n] = this.data[n] & ~index[1];
            }
        }

        public void removeAll(Set<E> set) {
            for (E element : set) {
                this.remove(element);
            }
        }

        public boolean contains(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            if (index == null) {
                index = ((FastSetFactory)this.factory).addElement(element);
            }
            return index[0] >= this.data.length ? false : (this.data[index[0]] & index[1]) != 0;
        }

        public boolean contains(FastSet<E> set) {
            int i;
            int[] extdata = super.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (i = minlength - 1; i >= 0; --i) {
                if ((extdata[i] & ~intdata[i]) == 0) continue;
                return false;
            }
            for (i = extdata.length - 1; i >= minlength; --i) {
                if (extdata[i] == 0) continue;
                return false;
            }
            return true;
        }

        public void union(FastSet<E> set) {
            int[] extdata = super.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (int i = minlength - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] | extdata[i];
            }
            boolean expanded = false;
            for (int i = extdata.length - 1; i >= minlength; --i) {
                if (extdata[i] == 0) continue;
                if (!expanded) {
                    intdata = this.ensureCapacity(extdata.length - 1);
                }
                intdata[i] = extdata[i];
            }
        }

        public void intersection(FastSet<E> set) {
            int i;
            int[] extdata = super.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (i = minlength - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] & extdata[i];
            }
            for (i = intdata.length - 1; i >= minlength; --i) {
                intdata[i] = 0;
            }
        }

        public void symdiff(FastSet<E> set) {
            int[] extdata = super.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (int i = minlength - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] ^ extdata[i];
            }
            boolean expanded = false;
            for (int i = extdata.length - 1; i >= minlength; --i) {
                if (extdata[i] == 0) continue;
                if (!expanded) {
                    intdata = this.ensureCapacity(extdata.length - 1);
                }
                intdata[i] = extdata[i];
            }
        }

        public void complement(FastSet<E> set) {
            int[] extdata = super.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (int i = minlength - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] & ~extdata[i];
            }
        }

        public boolean equals(Object o) {
            int i;
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof FastSet)) {
                return false;
            }
            int[] longdata = ((FastSet)o).getData();
            int[] shortdata = this.data;
            if (this.data.length > longdata.length) {
                shortdata = longdata;
                longdata = this.data;
            }
            for (i = shortdata.length - 1; i >= 0; --i) {
                if (shortdata[i] == longdata[i]) continue;
                return false;
            }
            for (i = longdata.length - 1; i >= shortdata.length; --i) {
                if (longdata[i] == 0) continue;
                return false;
            }
            return true;
        }

        public int getCardinality() {
            boolean found = false;
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int block = intdata[i];
                if (block == 0) continue;
                if (found) {
                    return 2;
                }
                if ((block & block - 1) == 0) {
                    found = true;
                    continue;
                }
                return 2;
            }
            return found ? 1 : 0;
        }

        public int size() {
            int size = 0;
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                size += Integer.bitCount(intdata[i]);
            }
            return size;
        }

        public boolean isEmpty() {
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                if (intdata[i] == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return new FastSetIterator(this);
        }

        public Set<E> toPlainSet() {
            HashSet<E> set = new HashSet<E>();
            int[] intdata = this.data;
            int size = this.data.length * 32;
            if (size > this.colValuesInternal.size()) {
                size = this.colValuesInternal.size();
            }
            for (int i = size - 1; i >= 0; --i) {
                int[] index = (int[])this.colValuesInternal.get(i);
                if ((intdata[index[0]] & index[1]) == 0) continue;
                set.add(this.colValuesInternal.getKey(i));
            }
            return set;
        }

        public String toBinary() {
            StringBuilder buffer = new StringBuilder();
            int[] intdata = this.data;
            for (int i = 0; i < intdata.length; ++i) {
                buffer.append(" ").append(Integer.toBinaryString(intdata[i]));
            }
            return buffer.toString();
        }

        private int[] getData() {
            return this.data;
        }

        private void setData(int[] data) {
            this.data = data;
        }

        public int[] getLoad() {
            int[] intdata = this.data;
            int notempty = 0;
            for (int i = 0; i < intdata.length; ++i) {
                if (intdata[i] == 0) continue;
                ++notempty;
            }
            return new int[]{intdata.length, notempty};
        }

        public FastSetFactory<E> getFactory() {
            return this.factory;
        }
    }
}

