/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;

public class DefaultHighlighter {
    @NonNls
    static final String LINE_COMMENT_ID = "Line comment";
    @NonNls
    static final String BLOCK_COMMENT_ID = "Block comment";
    @NonNls
    static final String DOC_COMMENT_ID = "Groovydoc comment";
    @NonNls
    static final String DOC_COMMENT_TAG_ID = "Groovydoc tag";
    @NonNls
    static final String KEYWORD_ID = "Keyword";
    @NonNls
    static final String NUMBER_ID = "Number";
    @NonNls
    static final String GSTRING_ID = "GString";
    @NonNls
    static final String STRING_ID = "String";
    @NonNls
    static final String BRACES_ID = "Braces";
    @NonNls
    static final String BRACKETS_ID = "Brackets";
    @NonNls
    static final String PARENTHESES_ID = "Parentheses";
    @NonNls
    static final String OPERATION_SIGN_ID = "Operation sign";
    @NonNls
    static final String BAD_CHARACTER_ID = "Bad character";
    @NonNls
    static final String ANNOTATION_ID = "Annotation";
    @NonNls
    static final String INSTANCE_FIELD_ID = "Instance field";
    @NonNls
    static final String STATIC_FIELD_ID = "Static field";
    @NonNls
    static final String METHOD_CALL_ID = "Method call";
    @NonNls
    static final String STATIC_METHOD_ACCESS_ID = "Static method access";
    @NonNls
    static final String CLASS_REFERENCE_ID = "Class";
    @NonNls
    static final String TYPE_PARAMETER_ID = "Type parameter";
    @NonNls
    static final String INSTANCE_PROPERTY_REFERENCE_ID = "Instance property reference ID";
    @NonNls
    static final String STATIC_PROPERTY_REFERENCE_ID = "Static property reference ID";
    @NonNls
    static final String MAP_KEY_ID = "Map key";
    @NonNls
    static final String UNRESOLVED_ACCESS_ID = "Unresolved reference access";
    @NonNls
    static final String LITERAL_CONVERSION_ID = "List/map to object conversion";
    @NonNls
    static final String VALID_STRING_ESCAPE_ID = "Valid string escape";
    @NonNls
    static final String INVALID_STRING_ESCAPE_ID = "Invalid string escape";
    @NonNls
    static final String LABEL_ID = "Label";
    public static final TextAttributesKey LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"Line comment", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey ANNOTATION = TextAttributesKey.createTextAttributesKey((String)"Annotation", (TextAttributesKey)HighlightInfoType.ANNOTATION_NAME.getAttributesKey());
    public static final TextAttributesKey LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"Groovy var", (TextAttributesKey)HighlightInfoType.LOCAL_VARIABLE.getAttributesKey());
    public static final TextAttributesKey REASSIGNED_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"Groovy reassigned var", (TextAttributesKey)HighlightInfoType.REASSIGNED_LOCAL_VARIABLE.getAttributesKey());
    public static final TextAttributesKey PARAMETER = TextAttributesKey.createTextAttributesKey((String)"Groovy parameter", (TextAttributesKey)HighlightInfoType.PARAMETER.getAttributesKey());
    public static final TextAttributesKey REASSIGNED_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"Groovy reassigned parameter", (TextAttributesKey)HighlightInfoType.REASSIGNED_PARAMETER.getAttributesKey());
    public static final TextAttributesKey METHOD_DECLARATION = TextAttributesKey.createTextAttributesKey((String)"Groovy method declaration", (TextAttributesKey)HighlightInfoType.METHOD_DECLARATION.getAttributesKey());
    public static final TextAttributesKey CONSTRUCTOR_DECLARATION = TextAttributesKey.createTextAttributesKey((String)"Groovy constructor declaration", (TextAttributesKey)HighlightInfoType.CONSTRUCTOR_DECLARATION.getAttributesKey());
    public static final TextAttributesKey INSTANCE_FIELD = TextAttributesKey.createTextAttributesKey((String)"Instance field", (TextAttributesKey)HighlightInfoType.INSTANCE_FIELD.getAttributesKey());
    public static final TextAttributesKey METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"Method call", (TextAttributesKey)HighlightInfoType.METHOD_CALL.getAttributesKey());
    public static final TextAttributesKey CONSTRUCTOR_CALL = TextAttributesKey.createTextAttributesKey((String)"Groovy constructor call", (TextAttributesKey)HighlightInfoType.CONSTRUCTOR_CALL.getAttributesKey());
    public static final TextAttributesKey STATIC_FIELD = TextAttributesKey.createTextAttributesKey((String)"Static field", (TextAttributesKey)HighlightInfoType.STATIC_FINAL_FIELD.getAttributesKey());
    public static final TextAttributesKey STATIC_METHOD_ACCESS = TextAttributesKey.createTextAttributesKey((String)"Static method access", (TextAttributesKey)HighlightInfoType.STATIC_METHOD.getAttributesKey());
    public static final TextAttributesKey BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"Block comment", (TextAttributesKey)JavaHighlightingColors.JAVA_BLOCK_COMMENT);
    public static final TextAttributesKey DOC_COMMENT_CONTENT = TextAttributesKey.createTextAttributesKey((String)"Groovydoc comment", (TextAttributesKey)JavaHighlightingColors.DOC_COMMENT);
    public static final TextAttributesKey DOC_COMMENT_TAG = TextAttributesKey.createTextAttributesKey((String)"Groovydoc tag", (TextAttributesKey)JavaHighlightingColors.DOC_COMMENT_TAG);
    public static final TextAttributesKey CLASS_REFERENCE = TextAttributesKey.createTextAttributesKey((String)"Class", (TextAttributesKey)HighlighterColors.TEXT);
    public static final TextAttributesKey TYPE_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"Type parameter", (TextAttributesKey)CodeInsightColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
    public static final TextAttributes INSTANCE_PROPERTY_REFERENCE_ATTRIBUTES = INSTANCE_FIELD.getDefaultAttributes().clone();
    public static final TextAttributes STATIC_PROPERTY_REFERENCE_ATTRIBUTES = STATIC_FIELD.getDefaultAttributes().clone();
    public static final TextAttributesKey INSTANCE_PROPERTY_REFERENCE;
    public static final TextAttributesKey STATIC_PROPERTY_REFERENCE;
    public static final TextAttributes KEYWORD_ATTRIBUTES;
    public static final TextAttributesKey KEYWORD;
    public static final TextAttributesKey NUMBER;
    public static final TextAttributesKey GSTRING;
    public static final TextAttributesKey STRING;
    public static final TextAttributesKey BRACES;
    public static final TextAttributesKey BRACKETS;
    public static final TextAttributesKey PARENTHESES;
    public static final TextAttributesKey OPERATION_SIGN;
    public static final TextAttributesKey BAD_CHARACTER;
    public static final TextAttributes UNRESOLVED_ACCESS_ATTRIBUTES;
    public static final TextAttributesKey UNRESOLVED_ACCESS;
    public static final TextAttributes LITERAL_CONVERSION_ATTRIBUTES;
    public static final TextAttributesKey LITERAL_CONVERSION;
    public static final TextAttributes MAP_KEY_ATTRIBUTES;
    public static final Color MAP_KEY_COLOR;
    public static final TextAttributesKey MAP_KEY;
    public static final TextAttributesKey VALID_STRING_ESCAPE;
    public static final TextAttributesKey INVALID_STRING_ESCAPE;
    public static final TextAttributesKey LABEL;

    private DefaultHighlighter() {
    }

    static {
        INSTANCE_PROPERTY_REFERENCE_ATTRIBUTES.setFontType(0);
        STATIC_PROPERTY_REFERENCE_ATTRIBUTES.setFontType(2);
        INSTANCE_PROPERTY_REFERENCE = TextAttributesKey.createTextAttributesKey((String)INSTANCE_PROPERTY_REFERENCE_ID, (TextAttributes)INSTANCE_PROPERTY_REFERENCE_ATTRIBUTES);
        STATIC_PROPERTY_REFERENCE = TextAttributesKey.createTextAttributesKey((String)STATIC_PROPERTY_REFERENCE_ID, (TextAttributes)STATIC_PROPERTY_REFERENCE_ATTRIBUTES);
        KEYWORD_ATTRIBUTES = JavaHighlightingColors.KEYWORD.getDefaultAttributes().clone();
        KEYWORD = TextAttributesKey.createTextAttributesKey((String)("GROOVY_" + KEYWORD_ID.toUpperCase()), (TextAttributes)KEYWORD_ATTRIBUTES);
        KEYWORD_ATTRIBUTES.setForegroundColor((Color)new JBColor(new Color(0, 0, 67), new Color(0, 0, 67)));
        KEYWORD_ATTRIBUTES.setFontType(1);
        NUMBER = TextAttributesKey.createTextAttributesKey((String)NUMBER_ID, (TextAttributesKey)JavaHighlightingColors.NUMBER);
        GSTRING = TextAttributesKey.createTextAttributesKey((String)GSTRING_ID, (TextAttributesKey)JavaHighlightingColors.STRING);
        STRING = TextAttributesKey.createTextAttributesKey((String)STRING_ID, (TextAttributesKey)JavaHighlightingColors.STRING);
        BRACES = TextAttributesKey.createTextAttributesKey((String)BRACES_ID, (TextAttributesKey)JavaHighlightingColors.BRACES);
        BRACKETS = TextAttributesKey.createTextAttributesKey((String)BRACKETS_ID, (TextAttributesKey)JavaHighlightingColors.BRACKETS);
        PARENTHESES = TextAttributesKey.createTextAttributesKey((String)PARENTHESES_ID, (TextAttributesKey)JavaHighlightingColors.PARENTHESES);
        OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)OPERATION_SIGN_ID, (TextAttributesKey)JavaHighlightingColors.OPERATION_SIGN);
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)BAD_CHARACTER_ID, (TextAttributesKey)CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        UNRESOLVED_ACCESS_ATTRIBUTES = HighlighterColors.TEXT.getDefaultAttributes().clone();
        UNRESOLVED_ACCESS_ATTRIBUTES.setForegroundColor((Color)JBColor.BLACK);
        UNRESOLVED_ACCESS_ATTRIBUTES.setEffectColor((Color)JBColor.GRAY);
        UNRESOLVED_ACCESS_ATTRIBUTES.setEffectType(EffectType.LINE_UNDERSCORE);
        UNRESOLVED_ACCESS = TextAttributesKey.createTextAttributesKey((String)UNRESOLVED_ACCESS_ID, (TextAttributes)UNRESOLVED_ACCESS_ATTRIBUTES);
        LITERAL_CONVERSION_ATTRIBUTES = HighlighterColors.TEXT.getDefaultAttributes().clone();
        LITERAL_CONVERSION_ATTRIBUTES.setForegroundColor(PlatformColors.BLUE);
        LITERAL_CONVERSION_ATTRIBUTES.setFontType(1);
        LITERAL_CONVERSION = TextAttributesKey.createTextAttributesKey((String)LITERAL_CONVERSION_ID, (TextAttributes)LITERAL_CONVERSION_ATTRIBUTES);
        MAP_KEY_ATTRIBUTES = HighlighterColors.TEXT.getDefaultAttributes().clone();
        MAP_KEY_COLOR = new JBColor(new Color(0, 128, 0), new Color(0, 128, 0));
        MAP_KEY_ATTRIBUTES.setForegroundColor(MAP_KEY_COLOR);
        MAP_KEY = TextAttributesKey.createTextAttributesKey((String)MAP_KEY_ID, (TextAttributes)MAP_KEY_ATTRIBUTES);
        VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)VALID_STRING_ESCAPE_ID, (TextAttributesKey)JavaHighlightingColors.VALID_STRING_ESCAPE);
        INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)INVALID_STRING_ESCAPE_ID, (TextAttributesKey)JavaHighlightingColors.INVALID_STRING_ESCAPE);
        LABEL = TextAttributesKey.createTextAttributesKey((String)LABEL_ID, (TextAttributesKey)HighlighterColors.TEXT);
    }
}

