/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.runners.ExecutionUtil");
    private static final NotificationGroup ourNotificationGroup = NotificationGroup.logOnlyGroup("Execution");

    private ExecutionUtil() {
    }

    public static void handleExecutionError(@NotNull Project project, @NotNull String toolWindowId, @NotNull RunProfile runProfile, @NotNull ExecutionException e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        ExecutionUtil.handleExecutionError(project, toolWindowId, runProfile.getName(), e);
    }

    public static void handleExecutionError(@NotNull ExecutionEnvironment environment, @NotNull ExecutionException e) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        ExecutionUtil.handleExecutionError(environment.getProject(), environment.getExecutor().getToolWindowId(), environment.getRunProfile().getName(), e);
    }

    public static void handleExecutionError(final @NotNull Project project, final @NotNull String toolWindowId, @NotNull String taskName, @NotNull ExecutionException e) {
        String commandLineString;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e instanceof RunCanceledByUserException) {
            return;
        }
        LOG.debug((Throwable)e);
        String description = e.getMessage();
        if (description == null) {
            LOG.warn("Execution error without description", (Throwable)e);
            description = "Unknown error";
        }
        HyperlinkListener listener = null;
        if ((description.contains("87") || description.contains("111") || description.contains("206")) && e instanceof ProcessNotCreatedException && !PropertiesComponent.getInstance(project).isTrueValue("dynamic.classpath") && (commandLineString = ((ProcessNotCreatedException)e).getCommandLine().getCommandLineString()).length() > 32768) {
            description = "Command line is too long. In order to reduce its length classpath file can be used.<br>Would you like to enable classpath file mode for all run configurations of your project?<br><a href=\"\">Enable</a>";
            listener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    PropertiesComponent.getInstance(project).setValue("dynamic.classpath", "true");
                }
            };
        }
        final String title = ExecutionBundle.message("error.running.configuration.message", taskName);
        final String fullMessage = title + ":<br>" + description;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(fullMessage);
        }
        if (listener == null && e instanceof HyperlinkListener) {
            listener = (HyperlinkListener)((Object)e);
        }
        final HyperlinkListener finalListener = listener;
        final String finalDescription = description;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance(project);
                if (toolWindowManager.canShowNotification(toolWindowId)) {
                    toolWindowManager.notifyByBalloon(toolWindowId, MessageType.ERROR, fullMessage, null, finalListener);
                } else {
                    Messages.showErrorDialog(project, fullMessage, "");
                }
                NotificationListener notificationListener = (NotificationListener)ObjectUtils.tryCast((Object)finalListener, NotificationListener.class);
                ourNotificationGroup.createNotification(title, finalDescription, NotificationType.ERROR, notificationListener).notify(project);
            }
        });
    }

    public static void restartIfActive(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/runners/ExecutionUtil", "restartIfActive"));
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null && processHandler.isStartNotified() && !processHandler.isProcessTerminating() && !processHandler.isProcessTerminated()) {
            ExecutionUtil.restart(descriptor);
        }
    }

    public static void restart(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/runners/ExecutionUtil", "restart"));
        }
        ExecutionUtil.restart(descriptor.getComponent());
    }

    public static void restart(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/runners/ExecutionUtil", "restart"));
        }
        ExecutionUtil.restart(content.getComponent());
    }

    private static void restart(@Nullable JComponent component) {
        ExecutionEnvironment environment;
        if (component != null && (environment = LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext(component))) != null) {
            ExecutionUtil.restart(environment);
        }
    }

    public static void restart(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/ExecutionUtil", "restart"));
        }
        if (!ExecutorRegistry.getInstance().isStarting(environment)) {
            ExecutionManager.getInstance(environment.getProject()).restartRunProfile(environment);
        }
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/runners/ExecutionUtil", "runConfiguration"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionUtil", "runConfiguration"));
        }
        ExecutionEnvironmentBuilder builder = ExecutionUtil.createEnvironment(executor, configuration);
        if (builder != null) {
            ExecutionManager.getInstance(configuration.getConfiguration().getProject()).restartRunProfile(builder.activeTarget().build());
        }
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createEnvironment(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/ExecutionUtil", "createEnvironment"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/runners/ExecutionUtil", "createEnvironment"));
        }
        try {
            return ExecutionEnvironmentBuilder.create(executor, settings);
        }
        catch (ExecutionException e) {
            ExecutionUtil.handleExecutionError(settings.getConfiguration().getProject(), executor.getToolWindowId(), settings.getConfiguration().getName(), e);
            return null;
        }
    }
}

