/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class EffectiveLanguageLevelUtil {
    @NotNull
    public static LanguageLevel getEffectiveLanguageLevel(@NotNull Module module) {
        LanguageLevel level;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/EffectiveLanguageLevelUtil", "getEffectiveLanguageLevel"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LanguageLevelModuleExtension moduleLevel = LanguageLevelModuleExtension.getInstance(module);
        LanguageLevel languageLevel = level = moduleLevel == null ? null : moduleLevel.getLanguageLevel();
        if (level != null) {
            LanguageLevel languageLevel2 = level;
            if (languageLevel2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/EffectiveLanguageLevelUtil", "getEffectiveLanguageLevel"));
            }
            return languageLevel2;
        }
        LanguageLevel languageLevel3 = LanguageLevelProjectExtension.getInstance(module.getProject()).getLanguageLevel();
        if (languageLevel3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/EffectiveLanguageLevelUtil", "getEffectiveLanguageLevel"));
        }
        return languageLevel3;
    }
}

